/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import ru.noties.adapt.DynamicHolder;
import ru.noties.adapt.ItemView;

public abstract class DynamicItemView<T>
extends ItemView<T, DynamicHolder> {
    private final int layoutResId;

    @NonNull
    public static <T> DynamicItemView create(@LayoutRes int layoutResId, @NonNull BindHolder<T> bindHolder) {
        return new Impl<T>(layoutResId, bindHolder);
    }

    public DynamicItemView(@LayoutRes int layoutResId) {
        this.layoutResId = layoutResId;
    }

    @Override
    @NonNull
    public DynamicHolder createHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        return new DynamicHolder(inflater.inflate(this.layoutResId, parent, false));
    }

    @Override
    public abstract void bindHolder(@NonNull DynamicHolder var1, @NonNull T var2);

    private static class Impl<T>
    extends DynamicItemView<T> {
        private final BindHolder<T> bindHolder;

        Impl(@LayoutRes int layoutResId, @NonNull BindHolder<T> bindHolder) {
            super(layoutResId);
            this.bindHolder = bindHolder;
        }

        @Override
        public void bindHolder(@NonNull DynamicHolder holder, @NonNull T item) {
            this.bindHolder.bindHolder(holder, item);
        }
    }

    public static interface BindHolder<T> {
        public void bindHolder(@NonNull DynamicHolder var1, @NonNull T var2);
    }
}

