/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import ru.noties.adapt.Holder;

public class DynamicHolder
extends Holder {
    private final SparseArray<View> cache = new SparseArray(3);

    public DynamicHolder(@NonNull View view) {
        super(view);
    }

    @NonNull
    public <V extends View> DynamicHolder on(@IdRes int id, @NonNull Action<V> action) throws NullPointerException {
        V view = this.requireView(id);
        action.apply(view);
        return this;
    }

    @Override
    @Nullable
    public <V extends View> V findView(@IdRes int id) {
        Object view;
        int index = this.cache.indexOfKey(id);
        if (index > -1) {
            view = (View)this.cache.valueAt(index);
        } else {
            view = super.findView(id);
            this.cache.put(id, view);
        }
        return view;
    }

    @Override
    @NonNull
    public <V extends View> V requireView(@IdRes int id) throws NullPointerException {
        Object view;
        int index = this.cache.indexOfKey(id);
        if (index > -1) {
            view = (View)this.cache.valueAt(index);
            if (view == null) {
                throw new NullPointerException("Requested view is not found in layout and was previously requested by `findView` method call. Prefer using one method for the same view to be found (`findView` or `requestView`), id: R.id." + this.itemView.getResources().getResourceName(id));
            }
        } else {
            view = super.requireView(id);
            this.cache.put(id, view);
        }
        return view;
    }

    public static interface Action<V extends View> {
        public void apply(@NonNull V var1);
    }
}

