/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import java.util.Collections;
import java.util.List;
import ru.noties.adapt.AdaptUpdate;

public class DiffUtilUpdate<T>
implements AdaptUpdate<T> {
    private final Callback<T> callback;

    @NonNull
    public static <T> DiffUtilUpdate<T> create(@NonNull Callback<T> callback) {
        return new DiffUtilUpdate<T>(callback);
    }

    @NonNull
    public static <T> DiffUtilUpdate<T> create(final @NonNull AreItemsTheSame<T> areItemsTheSame) {
        return new DiffUtilUpdate<T>(new Callback<T>(){

            @Override
            public boolean areItemsTheSame(@NonNull T oldItem, @NonNull T newItem) {
                return areItemsTheSame.areItemsTheSame(oldItem, newItem);
            }
        });
    }

    DiffUtilUpdate(@NonNull Callback<T> callback) {
        this.callback = callback;
    }

    @Override
    public void updateItems(@NonNull AdaptUpdate.Source<T> source, @Nullable List<? extends T> oldItems, @Nullable List<? extends T> newItems) {
        oldItems = DiffUtilUpdate.makeNonNull(oldItems);
        newItems = DiffUtilUpdate.makeNonNull(newItems);
        boolean detectMoves = this.callback.detectMoves(oldItems, newItems);
        DiffUtilCallback<? extends T> diffUtilCallback = new DiffUtilCallback<T>(this.callback, oldItems, newItems);
        DiffUtil.DiffResult result = DiffUtil.calculateDiff(diffUtilCallback, (boolean)detectMoves);
        source.updateItems(newItems);
        result.dispatchUpdatesTo(source.recyclerViewAdapter());
    }

    @NonNull
    private static <T> List<? extends T> makeNonNull(@Nullable List<? extends T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private static class DiffUtilCallback<T>
    extends DiffUtil.Callback {
        private final Callback<T> callback;
        private final List<? extends T> oldItems;
        private final List<? extends T> newItems;

        DiffUtilCallback(@NonNull Callback<T> callback, @NonNull List<? extends T> oldItems, @NonNull List<? extends T> newItems) {
            this.callback = callback;
            this.oldItems = oldItems;
            this.newItems = newItems;
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return this.callback.areItemsTheSame(this.oldItems.get(oldItemPosition), this.newItems.get(newItemPosition));
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return this.callback.areContentsTheSame(this.oldItems.get(oldItemPosition), this.newItems.get(newItemPosition));
        }

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            return this.callback.getChangePayload(this.oldItems.get(oldItemPosition), this.newItems.get(newItemPosition));
        }
    }

    public static abstract class Callback<T> {
        public abstract boolean areItemsTheSame(@NonNull T var1, @NonNull T var2);

        public boolean detectMoves(@NonNull List<? extends T> oldItems, @NonNull List<? extends T> newItems) {
            return true;
        }

        public boolean areContentsTheSame(@NonNull T oldItem, @NonNull T newItem) {
            return oldItem.equals(newItem);
        }

        @Nullable
        public Object getChangePayload(@NonNull T oldItem, @NonNull T newItem) {
            return null;
        }
    }

    public static interface AreItemsTheSame<T> {
        public boolean areItemsTheSame(@NonNull T var1, @NonNull T var2);
    }
}

