/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import ru.noties.adapt.AdaptConfigurationError;
import ru.noties.adapt.AdaptEntry;
import ru.noties.adapt.AdaptRuntimeError;

abstract class AdaptSource<T> {
    AdaptSource() {
    }

    @NonNull
    abstract AdaptEntry<T> entry(@NonNull T var1) throws AdaptRuntimeError;

    @NonNull
    abstract AdaptEntry<T> entry(int var1) throws AdaptRuntimeError;

    abstract int assignedViewType(@NonNull T var1) throws AdaptRuntimeError;

    abstract int assignedViewType(@NonNull Class<? extends T> var1) throws AdaptRuntimeError;

    @NonNull
    static <T> Builder<T> builder(@NonNull Class<T> baseItemType) {
        return new Builder(new KeyProvider());
    }

    private static class Impl<T>
    extends AdaptSource<T> {
        private final KeyProvider keyProvider;
        private final SparseArray<AdaptEntry<? extends T>> sparseArray;

        Impl(@NonNull KeyProvider keyProvider, @NonNull SparseArray<AdaptEntry<? extends T>> sparseArray) {
            this.keyProvider = keyProvider;
            this.sparseArray = sparseArray;
        }

        @Override
        @NonNull
        AdaptEntry<T> entry(@NonNull T item) throws AdaptRuntimeError {
            AdaptEntry entry = (AdaptEntry)this.sparseArray.get(this.keyProvider.provideKey(item.getClass()));
            if (entry == null) {
                throw new AdaptRuntimeError("Specified type is not registered with this Adapt instance:" + item.getClass().getName());
            }
            return entry;
        }

        @Override
        @NonNull
        AdaptEntry<T> entry(int assignedViewType) throws AdaptRuntimeError {
            AdaptEntry entry = (AdaptEntry)this.sparseArray.get(assignedViewType);
            if (entry == null) {
                throw new AdaptRuntimeError("Specified viewType is not registered with this Adapt instance: " + assignedViewType);
            }
            return entry;
        }

        @Override
        int assignedViewType(@NonNull T item) throws AdaptRuntimeError {
            return this.assignedViewType(item.getClass());
        }

        @Override
        int assignedViewType(@NonNull Class<? extends T> type) throws AdaptRuntimeError {
            int key = this.keyProvider.provideKey(type);
            if (this.sparseArray.indexOfKey(key) < 0) {
                throw new AdaptRuntimeError("Specified type is not registered with this Adapt instance: " + type.getName());
            }
            return key;
        }
    }

    static class Builder<T> {
        private final Map<Class<? extends T>, AdaptEntry<? extends T>> map = new HashMap<Class<? extends T>, AdaptEntry<? extends T>>(3);
        private final KeyProvider keyProvider;

        Builder(@NonNull KeyProvider keyProvider) {
            this.keyProvider = keyProvider;
        }

        <I extends T> boolean append(@NonNull Class<I> type, @NonNull AdaptEntry<I> entry) {
            return this.map.put(type, entry) == null;
        }

        @NonNull
        AdaptSource<T> build() {
            int size = this.map.size();
            if (size == 0) {
                throw new AdaptConfigurationError("No entries were added");
            }
            SparseArray sparseArray = new SparseArray(size);
            for (Map.Entry<Class<T>, AdaptEntry<T>> entry : this.map.entrySet()) {
                sparseArray.append(this.keyProvider.provideKey(entry.getKey()), entry.getValue());
            }
            return new Impl(this.keyProvider, sparseArray);
        }
    }

    static class KeyProvider {
        KeyProvider() {
        }

        int provideKey(@NonNull Class<?> type) {
            return type.hashCode();
        }
    }
}

