/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ru.noties.adapt.Adapt;
import ru.noties.adapt.AdaptRuntimeError;
import ru.noties.adapt.AdaptSource;
import ru.noties.adapt.AdaptUpdate;
import ru.noties.adapt.Holder;
import ru.noties.adapt.ItemView;
import ru.noties.adapt.ViewProcessor;

class AdaptImpl<T>
extends Adapt<T>
implements AdaptUpdate.Source<T> {
    private final RecyclerViewAdapter adapter = new RecyclerViewAdapter();
    private final AdaptSource<T> adaptSource;
    private final AdaptUpdate<T> adaptUpdate;
    @Nullable
    private LayoutInflater layoutInflater;
    private List<? extends T> items;

    AdaptImpl(@NonNull Class<T> baseItemType, @Nullable LayoutInflater layoutInflater, boolean hasStableIds, @NonNull AdaptSource<T> adaptSource, @NonNull AdaptUpdate<T> adaptUpdate) {
        this.layoutInflater = layoutInflater;
        this.adapter.setHasStableIds(hasStableIds);
        this.adaptSource = adaptSource;
        this.adaptUpdate = adaptUpdate;
    }

    @Override
    @NonNull
    public RecyclerView.Adapter<? extends Holder> recyclerViewAdapter() {
        return this.adapter;
    }

    @Override
    public void setItems(@Nullable List<? extends T> items) {
        this.adaptUpdate.updateItems(this, this.items, items);
    }

    @Override
    public void updateItems(@Nullable List<? extends T> items) {
        this.items = items;
    }

    @Override
    @NonNull
    public List<? extends T> getItems() {
        return this.items != null ? Collections.unmodifiableList(this.items) : Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    @Override
    @NonNull
    public T getItem(int position) {
        return this.items.get(position);
    }

    @Override
    public int itemViewType(int position) {
        return this.itemViewType(this.getItem(position));
    }

    @Override
    public int assignedViewType(@NonNull Class<? extends T> type) {
        return this.adaptSource.assignedViewType(type);
    }

    @Override
    public boolean supportsItems(@Nullable List<? extends T> items) {
        if (items == null || items.size() == 0) {
            return true;
        }
        HashSet set = new HashSet(3);
        for (T item : items) {
            if (item == null) {
                return false;
            }
            set.add(item.getClass());
        }
        return this.supportsItemTypes(set);
    }

    @Override
    public boolean supportsItemTypes(@Nullable Collection<Class<?>> itemTypes) {
        if (itemTypes == null || itemTypes.size() == 0) {
            return true;
        }
        for (Class<?> type : itemTypes) {
            if (type == null) {
                return false;
            }
            try {
                this.adaptSource.assignedViewType(type);
            }
            catch (AdaptRuntimeError e) {
                return false;
            }
        }
        return true;
    }

    @NonNull
    private ItemView<T, Holder> itemView(int itemViewType) {
        return this.adaptSource.entry((int)itemViewType).itemView;
    }

    @NonNull
    private ItemView<T, Holder> itemView(@NonNull T item) {
        return this.adaptSource.entry(item).itemView;
    }

    private int itemViewType(@NonNull T item) {
        return this.adaptSource.assignedViewType(item);
    }

    @Nullable
    private ViewProcessor<T> viewProcessor(@NonNull T item) {
        return this.adaptSource.entry(item).viewProcessor;
    }

    private class RecyclerViewAdapter
    extends RecyclerView.Adapter<Holder> {
        private RecyclerViewAdapter() {
        }

        @NonNull
        public Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            if (AdaptImpl.this.layoutInflater == null) {
                AdaptImpl.this.layoutInflater = LayoutInflater.from((Context)parent.getContext());
            }
            return AdaptImpl.this.itemView((Object)viewType).createHolder(AdaptImpl.this.layoutInflater, parent);
        }

        public void onBindViewHolder(@NonNull Holder holder, int position) {
            this.onBindViewHolder(holder, position, Collections.emptyList());
        }

        public void onBindViewHolder(@NonNull Holder holder, int position, @NonNull List<Object> payloads) {
            Object item = AdaptImpl.this.items.get(position);
            ItemView itemView = AdaptImpl.this.itemView(item);
            itemView.bindHolder(holder, item, payloads);
            ViewProcessor viewProcessor = AdaptImpl.this.viewProcessor(item);
            if (viewProcessor != null) {
                viewProcessor.process(item, holder.itemView);
            }
        }

        public int getItemCount() {
            return AdaptImpl.this.getItemCount();
        }

        public int getItemViewType(int position) {
            return AdaptImpl.this.itemViewType(AdaptImpl.this.getItem(position));
        }

        public long getItemId(int position) {
            Object item = AdaptImpl.this.getItem(position);
            return AdaptImpl.this.itemView(item).itemId(item);
        }

        public void onViewRecycled(@NonNull Holder holder) {
            int position = holder.getAdapterPosition();
            if (position > -1) {
                AdaptImpl.this.itemView(AdaptImpl.this.getItem(position)).onViewRecycled(holder);
            }
        }
    }
}

