/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;
import ru.noties.adapt.Adapt;

public abstract class AdaptDispatcher<M, T> {
    @NonNull
    public static <M, T> AdaptDispatcher<M, T> create(@NonNull Adapt<T> adapt, @NonNull Reducer<M, T> reducer) {
        return new Impl<M, T>(adapt, reducer);
    }

    public abstract void dispatch(@NonNull M var1);

    static class Impl<M, T>
    extends AdaptDispatcher<M, T> {
        private final Adapt<T> adapt;
        private final Reducer<M, T> reducer;

        Impl(@NonNull Adapt<T> adapt, @NonNull Reducer<M, T> reducer) {
            this.adapt = adapt;
            this.reducer = reducer;
        }

        @Override
        public void dispatch(@NonNull M model) {
            this.adapt.setItems(this.reducer.reduce(model));
        }
    }

    public static interface Reducer<M, T> {
        @Nullable
        public List<? extends T> reduce(@NonNull M var1);
    }
}

