/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.adapt;

import android.view.LayoutInflater;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Modifier;
import ru.noties.adapt.Adapt;
import ru.noties.adapt.AdaptConfigurationError;
import ru.noties.adapt.AdaptEntry;
import ru.noties.adapt.AdaptImpl;
import ru.noties.adapt.AdaptSource;
import ru.noties.adapt.AdaptUpdate;
import ru.noties.adapt.Holder;
import ru.noties.adapt.ItemView;
import ru.noties.adapt.NotifyDataSetChangedUpdate;
import ru.noties.adapt.ViewProcessor;

public class AdaptBuilder<T> {
    private final Class<T> baseItemType;
    private final AdaptSource.Builder<T> adaptSourceBuilder;
    private boolean hasStableIds = true;
    private LayoutInflater layoutInflater;
    private AdaptUpdate<T> adaptUpdate;

    AdaptBuilder(@NonNull Class<T> baseItemType) {
        this.baseItemType = baseItemType;
        this.adaptSourceBuilder = AdaptSource.builder(baseItemType);
    }

    @NonNull
    public <I extends T> AdaptBuilder<T> include(@NonNull Class<I> itemType, @NonNull ItemView<? super I, ? extends Holder> itemView) throws AdaptConfigurationError {
        this.addEntry(itemType, itemView, null);
        return this;
    }

    @NonNull
    public <I extends T> AdaptBuilder<T> include(@NonNull Class<I> itemType, @NonNull ItemView<? super I, ? extends Holder> itemView, @NonNull ViewProcessor<I> viewProcessor) {
        this.addEntry(itemType, itemView, viewProcessor);
        return this;
    }

    @NonNull
    public AdaptBuilder<T> hasStableIds(boolean hasStableIds) {
        this.hasStableIds = hasStableIds;
        return this;
    }

    @NonNull
    public AdaptBuilder<T> layoutInflater(@NonNull LayoutInflater layoutInflater) {
        this.layoutInflater = layoutInflater;
        return this;
    }

    @NonNull
    public AdaptBuilder<T> adaptUpdate(@NonNull AdaptUpdate<T> adaptUpdate) {
        this.adaptUpdate = adaptUpdate;
        return this;
    }

    @NonNull
    public Adapt<T> build() throws AdaptConfigurationError {
        if (this.adaptUpdate == null) {
            this.adaptUpdate = NotifyDataSetChangedUpdate.create();
        }
        return new AdaptImpl<T>(this.baseItemType, this.layoutInflater, this.hasStableIds, this.adaptSourceBuilder.build(), this.adaptUpdate);
    }

    private <I extends T> void addEntry(@NonNull Class<I> type, @NonNull ItemView<? super I, ? extends Holder> itemView, @Nullable ViewProcessor<I> viewProcessor) throws AdaptConfigurationError {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            throw new AdaptConfigurationError("Cannot include an interface or an abstract class: " + type.getName());
        }
        AdaptEntry<I> entry = new AdaptEntry<I>(itemView, viewProcessor);
        if (!this.adaptSourceBuilder.append(type, entry)) {
            throw new AdaptConfigurationError("Provided type has been added already: " + type.getName());
        }
    }
}

