/*
 * Decompiled with CFR 0.152.
 */
package ru.mamykin.paginatedtextview.view;

import android.os.Handler;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.mamykin.paginatedtextview.view.SwipeableSpan;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/mamykin/paginatedtextview/view/SwipeableMovementMethod;", "Landroid/text/method/LinkMovementMethod;", "()V", "longClickHandler", "Landroid/os/Handler;", "startTime", "", "startXCoord", "", "getClickableSpan", "Lru/mamykin/paginatedtextview/view/SwipeableSpan;", "event", "Landroid/view/MotionEvent;", "widget", "Landroid/widget/TextView;", "buffer", "Landroid/text/Spannable;", "handleCancelAction", "", "handleDownAction", "handleUpAction", "onTouchEvent", "", "Companion", "paginatedtextview_release"})
public final class SwipeableMovementMethod
extends LinkMovementMethod {
    private Handler longClickHandler = new Handler();
    private double startXCoord;
    private long startTime;
    public static final int MAX_TIME_THRESHOLD = 500;
    public static final int MIN_COORD_POSITIVE_THRESHOLD = 100;
    public static final int MIN_COORD_NEGATIVE_THRESHOLD = -100;
    public static final long DEFAULT_LONG_CLICK_DELAY = 1000L;
    public static final Companion Companion = new Companion(null);

    public boolean onTouchEvent(@NotNull TextView widget, @NotNull Spannable buffer, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 3: {
                this.handleCancelAction();
                break;
            }
            case 0: {
                this.handleDownAction(event, buffer, widget);
                break;
            }
            case 1: {
                this.handleUpAction(event, buffer, widget);
            }
        }
        return true;
    }

    private final void handleCancelAction() {
        this.longClickHandler.removeCallbacksAndMessages(null);
    }

    private final void handleDownAction(MotionEvent event, Spannable buffer, TextView widget) {
        this.startXCoord = event.getX();
        this.startTime = event.getEventTime();
        SwipeableSpan link = this.getClickableSpan(event, widget, buffer);
        Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link), (int)buffer.getSpanEnd((Object)link));
        this.longClickHandler.postDelayed(new Runnable(link, widget){
            final /* synthetic */ SwipeableSpan $link;
            final /* synthetic */ TextView $widget;

            public final void run() {
                this.$link.onLongClick((View)this.$widget);
            }
            {
                this.$link = swipeableSpan;
                this.$widget = textView;
            }
        }, 1000L);
    }

    private final void handleUpAction(MotionEvent event, Spannable buffer, TextView widget) {
        long timeDiff = event.getEventTime() - this.startTime;
        double xCoordDiff = (double)event.getX() - this.startXCoord;
        if (timeDiff < (long)500) {
            this.longClickHandler.removeCallbacksAndMessages(null);
            SwipeableSpan link = this.getClickableSpan(event, widget, buffer);
            if (xCoordDiff > (double)100) {
                link.onSwipeLeft((View)widget);
            } else if (xCoordDiff < (double)-100) {
                link.onSwipeRight((View)widget);
            } else {
                link.onClick((View)widget);
            }
        }
    }

    private final SwipeableSpan getClickableSpan(MotionEvent event, TextView widget, Spannable buffer) {
        float clickX = event.getX() - (float)widget.getTotalPaddingLeft() + (float)widget.getScrollX();
        int clickY = (int)event.getY() - widget.getTotalPaddingTop() + widget.getScrollY();
        int line = widget.getLayout().getLineForVertical(clickY);
        int offset = widget.getLayout().getOffsetForHorizontal(line, clickX);
        SwipeableSpan[] spans = (SwipeableSpan[])buffer.getSpans(offset, offset, SwipeableSpan.class);
        SwipeableSpan swipeableSpan = spans[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)swipeableSpan), (String)"spans[0]");
        return swipeableSpan;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/mamykin/paginatedtextview/view/SwipeableMovementMethod$Companion;", "", "()V", "DEFAULT_LONG_CLICK_DELAY", "", "MAX_TIME_THRESHOLD", "", "MIN_COORD_NEGATIVE_THRESHOLD", "MIN_COORD_POSITIVE_THRESHOLD", "paginatedtextview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

