/*
 * Decompiled with CFR 0.152.
 */
package ru.mamykin.paginatedtextview.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatTextView;
import android.text.Layout;
import android.text.Spannable;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.mamykin.paginatedtextview.extension.StringKt;
import ru.mamykin.paginatedtextview.extension.ViewKt;
import ru.mamykin.paginatedtextview.pagination.PaginationController;
import ru.mamykin.paginatedtextview.pagination.ReadState;
import ru.mamykin.paginatedtextview.view.OnActionListener;
import ru.mamykin.paginatedtextview.view.OnSwipeListener;
import ru.mamykin.paginatedtextview.view.SwipeableMovementMethod;
import ru.mamykin.paginatedtextview.view.SwipeableSpan;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 N2\u00020\u0001:\u0001NB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\tH\u0002J \u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eH\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tH\u0002J\u0018\u0010/\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\tH\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000202H\u0002J\b\u00106\u001a\u00020\u001dH\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0002J(\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0014J(\u0010=\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tH\u0014J\u000e\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\fJ\u000e\u0010B\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010G\u001a\u00020\u0014H\u0016J\u0018\u0010F\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u0014H\u0016J\u000e\u0010I\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-J(\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\tH\u0002J\b\u0010M\u001a\u00020\u001dH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lru/mamykin/paginatedtextview/view/PaginatedTextView;", "Landroid/support/v7/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "actionListener", "Lru/mamykin/paginatedtextview/view/OnActionListener;", "availableSpaceRect", "Landroid/graphics/RectF;", "controller", "Lru/mamykin/paginatedtextview/pagination/PaginationController;", "initializedDimens", "", "maxTextSize", "", "swipeListener", "Lru/mamykin/paginatedtextview/view/OnSwipeListener;", "textCachedSizes", "Landroid/util/SparseIntArray;", "textPaint", "Landroid/text/TextPaint;", "textRect", "adjustTextSize", "", "calculateFitsTextSize", "start", "end", "availableSpace", "widthLimit", "checkTextFits", "suggestedSize", "availableRect", "containsRectF", "containerRect", "actualRect", "createSwipeableSpan", "Lru/mamykin/paginatedtextview/view/SwipeableSpan;", "findLeftLineBreak", "text", "", "selStart", "findRightLineBreak", "selEnd", "getSelectedParagraph", "", "widget", "Landroid/widget/TextView;", "getSelectedWord", "initPaginatedTextView", "loadFirstPage", "onSizeChanged", "width", "height", "oldWidth", "oldHeight", "onTextChanged", "lengthBefore", "lengthAfter", "setOnActionListener", "listener", "setOnSwipeListener", "setPageState", "pageState", "Lru/mamykin/paginatedtextview/pagination/ReadState;", "setTextSize", "size", "unit", "setup", "textSizeSearch", "minSize", "maxSize", "updateWordsSpannables", "Companion", "paginatedtextview_release"})
public final class PaginatedTextView
extends AppCompatTextView {
    private final SparseIntArray textCachedSizes;
    private final RectF availableSpaceRect;
    private float maxTextSize;
    private final RectF textRect;
    private final TextPaint textPaint;
    private boolean initializedDimens;
    private OnSwipeListener swipeListener;
    private OnActionListener actionListener;
    private PaginationController controller;
    public static final int MIN_TEXT_SIZE = 26;
    public static final float DEFAULT_SPACING_MULT = 1.0f;
    public static final float DEFAULT_SPACING_ADD = 0.0f;
    public static final Companion Companion = new Companion(null);

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.initializedDimens = true;
        this.textCachedSizes.clear();
        if (width != oldWidth || height != oldHeight) {
            this.adjustTextSize();
        }
    }

    public void setTextSize(float size) {
        this.maxTextSize = size;
        this.textCachedSizes.clear();
        this.adjustTextSize();
    }

    public void setTextSize(int unit, float size) {
        Context resources;
        Context context = this.getContext();
        if (context == null || (context = context.getResources()) == null) {
            context = Resources.getSystem();
        }
        Context context2 = resources = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"resources");
        this.maxTextSize = TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)context2.getDisplayMetrics());
        this.textCachedSizes.clear();
        this.adjustTextSize();
    }

    protected void onTextChanged(@NotNull CharSequence text, int start, int lengthBefore, int lengthAfter) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.adjustTextSize();
    }

    public final void setup(@NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ViewTreeObserver.OnGlobalLayoutListener layoutListener2 = new ViewTreeObserver.OnGlobalLayoutListener(this, text){
            final /* synthetic */ PaginatedTextView this$0;
            final /* synthetic */ CharSequence $text;

            public void onGlobalLayout() {
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                PaginatedTextView.access$loadFirstPage(this.this$0, this.$text);
            }
            {
                this.this$0 = $outer;
                this.$text = $captured_local_variable$1;
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(layoutListener2);
    }

    public final void setOnActionListener(@NotNull OnActionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.actionListener = listener;
    }

    public final void setOnSwipeListener(@NotNull OnSwipeListener swipeListener) {
        Intrinsics.checkParameterIsNotNull((Object)swipeListener, (String)"swipeListener");
        this.swipeListener = swipeListener;
    }

    private final void initPaginatedTextView() {
        this.setMovementMethod((MovementMethod)new SwipeableMovementMethod());
        this.setHighlightColor(0);
    }

    private final void setPageState(ReadState pageState) {
        this.setText(pageState.getPageText());
        OnActionListener onActionListener = this.actionListener;
        if (onActionListener != null) {
            onActionListener.onPageLoaded(pageState);
        }
        this.updateWordsSpannables();
    }

    private final String getSelectedWord() {
        return ((Object)StringsKt.trim((CharSequence)this.getText().subSequence(this.getSelectionStart(), this.getSelectionEnd()), (char[])new char[]{' '})).toString();
    }

    private final void loadFirstPage(CharSequence text) {
        PaginationController paginationController = this.controller = new PaginationController(text, this.getWidth(), this.getHeight(), this.textPaint, this.getLineSpacingMultiplier(), this.getLineSpacingExtra(), this.getIncludeFontPadding());
        if (paginationController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
        }
        this.setPageState(paginationController.getCurrentPage());
    }

    private final void adjustTextSize() {
        if (this.initializedDimens) {
            int heightLimit = this.getMeasuredHeight() - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
            int widthLimit = this.getMeasuredWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            this.availableSpaceRect.right = widthLimit;
            this.availableSpaceRect.bottom = heightLimit;
            int textSize = this.calculateFitsTextSize(26, (int)this.maxTextSize, this.availableSpaceRect, widthLimit);
            super.setTextSize(0, (float)textSize);
        }
    }

    private final boolean checkTextFits(int suggestedSize, RectF availableRect, int widthLimit) {
        this.textPaint.setTextSize((float)suggestedSize);
        StaticLayout layout = new StaticLayout(this.getText(), this.textPaint, widthLimit, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        this.textRect.bottom = layout.getHeight();
        this.textRect.right = ViewKt.getMaxLineWidth(layout);
        return this.containsRectF(availableRect, this.textRect);
    }

    private final boolean containsRectF(RectF containerRect, RectF actualRect) {
        containerRect.offset(0.0f, 0.0f);
        float aArea = containerRect.width() * containerRect.height();
        actualRect.offset(0.0f, 0.0f);
        float bArea = actualRect.width() * actualRect.height();
        return aArea >= bArea;
    }

    private final int calculateFitsTextSize(int start, int end, RectF availableSpace, int widthLimit) {
        int n;
        int key = this.getText().length();
        int size = this.textCachedSizes.get(key);
        if (size != 0) {
            n = size;
        } else {
            int n2;
            int $receiver = n2 = this.textSizeSearch(start, end, availableSpace, widthLimit);
            this.textCachedSizes.put(key, $receiver);
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int textSizeSearch(int minSize, int maxSize, RectF availableSpace, int widthLimit) {
        int n = maxSize;
        int n2 = minSize;
        if (n >= n2) {
            while (true) {
                void size;
                if (this.checkTextFits((int)size, availableSpace, widthLimit)) {
                    return (int)size;
                }
                if (size == n2) break;
                --size;
            }
        }
        return minSize;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWordsSpannables() {
        CharSequence charSequence = this.getText();
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
        }
        Spannable spans = (Spannable)charSequence;
        CharSequence charSequence2 = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"text");
        List<Integer> spaceIndexes = StringKt.allWordsPositions(StringsKt.trim((CharSequence)charSequence2));
        int wordStart = 0;
        int n = 0;
        int n2 = spaceIndexes.size();
        if (n <= n2) {
            while (true) {
                void i;
                SwipeableSpan swipeableSpan = this.createSwipeableSpan();
                int wordEnd = i < spaceIndexes.size() ? ((Number)spaceIndexes.get((int)i)).intValue() : spans.length();
                spans.setSpan((Object)swipeableSpan, wordStart, wordEnd, 33);
                wordStart = wordEnd + 1;
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final String getSelectedParagraph(TextView widget) {
        CharSequence text = widget.getText();
        int selStart = widget.getSelectionStart();
        int selEnd = widget.getSelectionEnd();
        CharSequence charSequence = text;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"text");
        int parStart = this.findLeftLineBreak(charSequence, selStart);
        int parEnd = this.findRightLineBreak(text, selEnd);
        return ((Object)text.subSequence(parStart, parEnd)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final int findLeftLineBreak(CharSequence text, int selStart) {
        int n = selStart;
        boolean bl = false;
        while (n >= 0) {
            void i;
            if (text.charAt((int)i) == '\n') {
                return (int)(i + true);
            }
            --i;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int findRightLineBreak(CharSequence text, int selEnd) {
        int n = selEnd;
        int n2 = text.length();
        while (n < n2) {
            void i;
            if (text.charAt((int)i) == '\n') {
                return (int)(i + true);
            }
            ++i;
        }
        return text.length() - 1;
    }

    private final SwipeableSpan createSwipeableSpan() {
        return new SwipeableSpan(this){
            final /* synthetic */ PaginatedTextView this$0;

            public void onClick(@NotNull View widget) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
                    String paragraph = PaginatedTextView.access$getSelectedParagraph(this.this$0, (TextView)widget);
                    if (TextUtils.isEmpty((CharSequence)paragraph)) break block2;
                    OnActionListener onActionListener = PaginatedTextView.access$getActionListener$p(this.this$0);
                    if (onActionListener != null) {
                        String string = paragraph;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        onActionListener.onClick(string);
                    }
                }
            }

            public void onLongClick(@NotNull View view) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    String word = PaginatedTextView.access$getSelectedWord(this.this$0);
                    if (TextUtils.isEmpty((CharSequence)word)) break block1;
                    OnActionListener onActionListener = PaginatedTextView.access$getActionListener$p(this.this$0);
                    if (onActionListener != null) {
                        onActionListener.onLongClick(word);
                    }
                }
            }

            public void onSwipeLeft(@NotNull View view) {
                block1: {
                    ReadState readState;
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    ReadState readState2 = PaginatedTextView.access$getController$p(this.this$0).getPrevPage();
                    if (readState2 == null) break block1;
                    ReadState $receiver = readState = readState2;
                    PaginatedTextView.access$setPageState(this.this$0, $receiver);
                    OnSwipeListener onSwipeListener = PaginatedTextView.access$getSwipeListener$p(this.this$0);
                    if (onSwipeListener != null) {
                        onSwipeListener.onSwipeLeft();
                    }
                }
            }

            public void onSwipeRight(@NotNull View view) {
                block1: {
                    ReadState readState;
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    ReadState readState2 = PaginatedTextView.access$getController$p(this.this$0).getNextPage();
                    if (readState2 == null) break block1;
                    ReadState $receiver = readState = readState2;
                    PaginatedTextView.access$setPageState(this.this$0, $receiver);
                    OnSwipeListener onSwipeListener = PaginatedTextView.access$getSwipeListener$p(this.this$0);
                    if (onSwipeListener != null) {
                        onSwipeListener.onSwipeRight();
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public PaginatedTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.textCachedSizes = new SparseIntArray();
        this.availableSpaceRect = new RectF();
        this.maxTextSize = this.getTextSize();
        this.textRect = new RectF();
        this.textPaint = new TextPaint((Paint)this.getPaint());
        this.initPaginatedTextView();
    }

    public PaginatedTextView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.textCachedSizes = new SparseIntArray();
        this.availableSpaceRect = new RectF();
        this.maxTextSize = this.getTextSize();
        this.textRect = new RectF();
        this.textPaint = new TextPaint((Paint)this.getPaint());
        this.initPaginatedTextView();
    }

    public PaginatedTextView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.textCachedSizes = new SparseIntArray();
        this.availableSpaceRect = new RectF();
        this.maxTextSize = this.getTextSize();
        this.textRect = new RectF();
        this.textPaint = new TextPaint((Paint)this.getPaint());
        this.initPaginatedTextView();
    }

    public static final /* synthetic */ void access$loadFirstPage(PaginatedTextView $this, @NotNull CharSequence text) {
        $this.loadFirstPage(text);
    }

    @Nullable
    public static final /* synthetic */ String access$getSelectedParagraph(PaginatedTextView $this, @NotNull TextView widget) {
        return $this.getSelectedParagraph(widget);
    }

    @Nullable
    public static final /* synthetic */ OnActionListener access$getActionListener$p(PaginatedTextView $this) {
        return $this.actionListener;
    }

    public static final /* synthetic */ void access$setActionListener$p(PaginatedTextView $this, @Nullable OnActionListener onActionListener) {
        $this.actionListener = onActionListener;
    }

    @NotNull
    public static final /* synthetic */ String access$getSelectedWord(PaginatedTextView $this) {
        return $this.getSelectedWord();
    }

    @NotNull
    public static final /* synthetic */ PaginationController access$getController$p(PaginatedTextView $this) {
        PaginationController paginationController = $this.controller;
        if (paginationController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
        }
        return paginationController;
    }

    public static final /* synthetic */ void access$setController$p(PaginatedTextView $this, @NotNull PaginationController paginationController) {
        $this.controller = paginationController;
    }

    public static final /* synthetic */ void access$setPageState(PaginatedTextView $this, @NotNull ReadState pageState) {
        $this.setPageState(pageState);
    }

    @Nullable
    public static final /* synthetic */ OnSwipeListener access$getSwipeListener$p(PaginatedTextView $this) {
        return $this.swipeListener;
    }

    public static final /* synthetic */ void access$setSwipeListener$p(PaginatedTextView $this, @Nullable OnSwipeListener onSwipeListener) {
        $this.swipeListener = onSwipeListener;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lru/mamykin/paginatedtextview/view/PaginatedTextView$Companion;", "", "()V", "DEFAULT_SPACING_ADD", "", "DEFAULT_SPACING_MULT", "MIN_TEXT_SIZE", "", "paginatedtextview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

