/*
 * Decompiled with CFR 0.152.
 */
package ru.mamykin.paginatedtextview.pagination;

import android.text.TextPaint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.mamykin.paginatedtextview.pagination.Paginator;
import ru.mamykin.paginatedtextview.pagination.ReadState;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0015\u001a\u00020\nH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lru/mamykin/paginatedtextview/pagination/PaginationController;", "", "text", "", "width", "", "height", "paint", "Landroid/text/TextPaint;", "spacingMult", "", "spacingAdd", "includePad", "", "(Ljava/lang/CharSequence;IILandroid/text/TextPaint;FFZ)V", "paginator", "Lru/mamykin/paginatedtextview/pagination/Paginator;", "getCurrentPage", "Lru/mamykin/paginatedtextview/pagination/ReadState;", "getNextPage", "getPrevPage", "getReadPercent", "paginatedtextview_release"})
public final class PaginationController {
    private final Paginator paginator;

    @NotNull
    public final ReadState getCurrentPage() {
        return new ReadState(this.paginator.getCurrentIndex() + 1, this.paginator.getPagesCount(), this.getReadPercent(), this.paginator.getCurrentPage());
    }

    @Nullable
    public final ReadState getNextPage() {
        ReadState readState;
        if (this.paginator.getCurrentIndex() < this.paginator.getPagesCount() - 1) {
            Paginator paginator = this.paginator;
            int n = paginator.getCurrentIndex();
            paginator.setCurrentIndex(n + 1);
            readState = this.getCurrentPage();
        } else {
            readState = null;
        }
        return readState;
    }

    @Nullable
    public final ReadState getPrevPage() {
        ReadState readState;
        if (this.paginator.getCurrentIndex() > 0) {
            Paginator paginator = this.paginator;
            int n = paginator.getCurrentIndex();
            paginator.setCurrentIndex(n + -1);
            readState = this.getCurrentPage();
        } else {
            readState = null;
        }
        return readState;
    }

    private final float getReadPercent() {
        float f;
        switch (this.paginator.getPagesCount()) {
            case 0: {
                f = 0.0f;
                break;
            }
            default: {
                f = (float)(this.paginator.getCurrentIndex() + 1) / (float)this.paginator.getPagesCount() * (float)100;
            }
        }
        return f;
    }

    public PaginationController(@NotNull CharSequence text, int width, int height, @NotNull TextPaint paint, float spacingMult, float spacingAdd, boolean includePad) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.paginator = new Paginator(text, width, height, paint, spacingMult, spacingAdd, includePad);
    }
}

