/*
 * Decompiled with CFR 0.152.
 */
package ru.kolotnev.formattedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.PluralsRes;
import androidx.appcompat.widget.AppCompatEditText;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import ru.kolotnev.formattedittext.R;

public class DecimalEditText
extends AppCompatEditText {
    public static final String TAG = "DecimalEditText";
    @NonNull
    private BigDecimal value = BigDecimal.ZERO;
    @NonNull
    private BigDecimal min = BigDecimal.ZERO;
    @NonNull
    private BigDecimal max = BigDecimal.ZERO;
    private String current;
    private int decimalRounding = 3;
    @PluralsRes
    private int pluralLabel = 0;
    private final TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            String str = s.toString();
            if (str.length() > 0 && str.equals(DecimalEditText.this.current)) {
                return;
            }
            DecimalEditText.this.parseValue(str);
            DecimalEditText.this.updateText();
        }
    };

    public DecimalEditText(Context context) {
        this(context, null);
    }

    public DecimalEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DecimalEditText);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int at = a.getIndex(i);
            if (at == R.styleable.DecimalEditText_plural) {
                this.pluralLabel = a.getResourceId(at, this.pluralLabel);
                continue;
            }
            if (at != R.styleable.DecimalEditText_rounding) continue;
            this.decimalRounding = a.getInt(at, this.decimalRounding);
        }
        a.recycle();
        this.setInputType(this.getInputType() | 2 | 0x2000);
        this.addTextChangedListener(this.textWatcher);
        this.setText((CharSequence)this.getText());
    }

    @NonNull
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(@NonNull BigDecimal value) {
        this.value = value;
        this.clampCurrentValue();
        this.updateText();
    }

    public int getDecimalRounding() {
        return this.decimalRounding;
    }

    public void setDecimalRounding(int decimalRounding) {
        this.decimalRounding = decimalRounding;
        if (this.decimalRounding < 0) {
            this.decimalRounding = 0;
        }
        this.parseValue(this.current);
        this.updateText();
    }

    @PluralsRes
    public int getPluralResource() {
        return this.pluralLabel;
    }

    public void setPluralResource(@PluralsRes int pluralResource) {
        this.pluralLabel = pluralResource;
        this.updateText();
    }

    public void setFormat(int decimalRounding, @PluralsRes int pluralResource) {
        this.decimalRounding = decimalRounding;
        if (this.decimalRounding < 0) {
            this.decimalRounding = 0;
        }
        this.pluralLabel = pluralResource;
        this.updateText();
    }

    public void setLimits(@NonNull BigDecimal min, @NonNull BigDecimal max) {
        this.min = min;
        this.max = max;
    }

    private void parseValue(@NonNull String str) {
        String cleanString = str.replaceAll("((?<!^)[\\D]|^[^\\d+-]|([+-]$)|(^\\D+$))", "");
        if (cleanString.length() > 0) {
            try {
                this.value = new BigDecimal(cleanString).setScale(this.decimalRounding, 3).divide(new BigDecimal(Math.pow(10.0, this.decimalRounding)), 3);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Failed to convert " + cleanString + " to decimal. Parameter " + str));
                e.printStackTrace();
            }
            this.clampCurrentValue();
        } else {
            this.value = BigDecimal.ZERO;
        }
    }

    private void clampCurrentValue() {
        if (this.min.compareTo(this.max) != 0) {
            if (this.max.compareTo(this.value) < 0) {
                this.value = this.max;
            }
            if (this.min.compareTo(this.value) > 0) {
                this.value = this.min;
            }
        }
    }

    private void updateText() {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.setMinimumFractionDigits(this.decimalRounding);
        df.setMaximumFractionDigits(this.decimalRounding);
        df.setRoundingMode(RoundingMode.FLOOR);
        String formattedClear = df.format(this.value);
        this.current = this.pluralLabel == 0 ? formattedClear : this.getResources().getQuantityString(this.pluralLabel, this.value.intValue(), new Object[]{formattedClear});
        int pos = this.current.contains(formattedClear) ? this.current.indexOf(formattedClear) + formattedClear.length() : 0;
        this.removeTextChangedListener(this.textWatcher);
        this.setText(this.current);
        this.setSelection(pos);
        this.addTextChangedListener(this.textWatcher);
    }
}

