/*
 * Decompiled with CFR 0.152.
 */
package ru.kolotnev.formattedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import ru.kolotnev.formattedittext.R;

public class CurrencyEditText
extends AppCompatEditText {
    private static final String TAG = "CurrencyEditText";
    @NonNull
    private Locale locale;
    @NonNull
    private Currency currency;
    @NonNull
    private BigDecimal value = BigDecimal.ZERO;
    private String current = "";
    private final TextWatcher textWatcher = new TextWatcher(){
        private boolean isDeleting;

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.isDeleting = after <= 0 && count > 0;
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            String str = s.toString();
            if (str.length() > 0 && str.equals(CurrencyEditText.this.current)) {
                return;
            }
            CurrencyEditText.this.parseValue(str);
            CurrencyEditText.this.updateText();
        }
    };

    public CurrencyEditText(Context context) {
        this(context, null, null, null);
    }

    public CurrencyEditText(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, null, null);
    }

    public CurrencyEditText(Context context, @Nullable AttributeSet attrs, @Nullable Locale locale) {
        this(context, attrs, locale, null);
    }

    public CurrencyEditText(Context context, @Nullable AttributeSet attrs, @Nullable Locale locale, @Nullable Currency currency) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CurrencyEditText);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int at = a.getIndex(i);
            if (at == R.styleable.CurrencyEditText_locale) {
                String lang = a.getString(at);
                if (lang == null) continue;
                locale = new Locale(lang);
                continue;
            }
            if (at != R.styleable.CurrencyEditText_currency) continue;
            currency = Currency.getInstance(a.getString(at));
        }
        a.recycle();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        if (currency == null) {
            currency = NumberFormat.getCurrencyInstance(locale).getCurrency();
        }
        if (currency == null) {
            currency = Currency.getInstance("USD");
        }
        this.currency = currency;
        this.setInputType(this.getInputType() | 2 | 0x2000);
        this.addTextChangedListener(this.textWatcher);
        this.setText((CharSequence)this.getText());
    }

    @NonNull
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(@NonNull BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.updateText();
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@NonNull Locale locale) {
        this.locale = locale;
        this.updateText();
    }

    @NonNull
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(@NonNull Currency currency) {
        this.currency = currency;
        this.updateText();
    }

    private void parseValue(String str) {
        String cleanString = str.replaceAll("[^\\d]", "");
        this.value = cleanString.length() > 0 ? new BigDecimal(cleanString).setScale(2, 3).divide(new BigDecimal(100), 3) : BigDecimal.ZERO;
    }

    private DecimalFormat getCurrencyFormatter() {
        NumberFormat.getCurrencyInstance();
        NumberFormat format = NumberFormat.getCurrencyInstance(this.locale);
        format.setMaximumFractionDigits(this.currency.getDefaultFractionDigits());
        format.setCurrency(this.currency);
        return (DecimalFormat)format;
    }

    private void updateText() {
        int end;
        DecimalFormat formatter = this.getCurrencyFormatter();
        this.current = formatter.format(this.value);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setCurrencySymbol("");
        formatter.setDecimalFormatSymbols(symbols);
        String formattedClear = formatter.format(this.value);
        int start = 0;
        if (Character.isSpaceChar(formattedClear.charAt(start))) {
            ++start;
        }
        if (Character.isSpaceChar(formattedClear.charAt(end = formattedClear.length() - 1))) {
            --end;
        }
        formattedClear = formattedClear.substring(start, end + 1);
        int pos = this.current.indexOf(formattedClear) + formattedClear.length();
        this.removeTextChangedListener(this.textWatcher);
        this.setText(this.current);
        this.setSelection(Math.min(pos, this.current.length()));
        this.addTextChangedListener(this.textWatcher);
    }
}

