/*
 * Decompiled with CFR 0.152.
 */
package ru.kolotnev.formattedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.AttributeSet;
import ru.kolotnev.formattedittext.R;

public class MaskedEditText
extends AppCompatEditText {
    public static final String TAG = "MaskedEditText";
    private static final char NUMBER_MASK = '9';
    private static final char ALPHA_MASK = 'A';
    private static final char ALPHANUMERIC_MASK = '*';
    private static final char CHARACTER_MASK = '?';
    private static final char ESCAPE_CHAR = '\\';
    private static final char PLACEHOLDER = ' ';
    @NonNull
    private String mask;
    @NonNull
    private String placeholder;

    public MaskedEditText(Context context) {
        this(context, "");
    }

    public MaskedEditText(Context context, String mask) {
        this(context, mask, ' ');
    }

    public MaskedEditText(Context context, String mask, char placeholder) {
        this(context, null, mask, placeholder);
    }

    public MaskedEditText(Context context, AttributeSet attr) {
        this(context, attr, "");
    }

    public MaskedEditText(Context context, AttributeSet attr, String mask) {
        this(context, attr, "", ' ');
    }

    public MaskedEditText(Context context, AttributeSet attr, @NonNull String mask, char placeholder) {
        super(context, attr);
        TypedArray a = context.obtainStyledAttributes(attr, R.styleable.MaskedEditText);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            String pl;
            int at = a.getIndex(i);
            if (at == R.styleable.MaskedEditText_mask) {
                String m = a.getString(at);
                if (!mask.isEmpty() || m == null) continue;
                mask = m;
                continue;
            }
            if (at != R.styleable.MaskedEditText_placeholder || (pl = a.getString(at)) == null || pl.length() <= 0 || placeholder != ' ') continue;
            placeholder = pl.charAt(0);
        }
        a.recycle();
        this.mask = mask;
        this.placeholder = String.valueOf(placeholder);
        TextWatcher textWatcher = new TextWatcher(){
            private boolean updating = false;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (this.updating || MaskedEditText.this.mask.length() == 0) {
                    return;
                }
                this.updating = true;
                MaskedEditText.this.stripMaskChars(s);
                MaskedEditText.this.formatMask(s);
                this.updating = false;
            }
        };
        this.addTextChangedListener(textWatcher);
        if (mask.length() > 0) {
            this.setText((CharSequence)this.getText());
        }
    }

    @NonNull
    public String getMask() {
        return this.mask;
    }

    public void setMask(@NonNull String mask) {
        this.mask = mask;
        this.setText((CharSequence)this.getText());
    }

    public char getPlaceholder() {
        return this.placeholder.charAt(0);
    }

    public void setPlaceholder(char placeholder) {
        this.placeholder = String.valueOf(placeholder);
        this.setText((CharSequence)this.getText());
    }

    @NonNull
    public Editable getText(boolean removeMask) {
        if (removeMask) {
            SpannableStringBuilder value = new SpannableStringBuilder((CharSequence)this.getText());
            this.stripMaskChars((Editable)value);
            return value;
        }
        return this.getText();
    }

    private void formatMask(@NonNull Editable value) {
        int newInputType;
        InputFilter[] inputFilters = value.getFilters();
        value.setFilters(new InputFilter[0]);
        int indexInMask = 0;
        int indexInText = 0;
        int maskLength = 0;
        int inputLength = 0;
        boolean treatNextCharAsLiteral = false;
        boolean maskIsNotNumeric = false;
        Object selection = new Object();
        value.setSpan(selection, Selection.getSelectionStart((CharSequence)value), Selection.getSelectionEnd((CharSequence)value), 17);
        while (indexInMask < this.mask.length()) {
            char charInMask = this.mask.charAt(indexInMask);
            if (!treatNextCharAsLiteral && this.isMaskChar(charInMask)) {
                maskIsNotNumeric |= charInMask != '9';
                if (indexInText >= value.length()) {
                    value.insert(indexInText, (CharSequence)this.placeholder);
                    value.setSpan((Object)new PlaceholderSpan(), indexInText, indexInText + 1, 33);
                    ++indexInText;
                    ++inputLength;
                    ++maskLength;
                    ++indexInMask;
                    continue;
                }
                if (!this.matchMask(charInMask, value.charAt(indexInText))) {
                    value.delete(indexInText, indexInText + 1);
                    continue;
                }
                ++indexInText;
                ++inputLength;
                ++maskLength;
                ++indexInMask;
                continue;
            }
            if (!treatNextCharAsLiteral && charInMask == '\\') {
                treatNextCharAsLiteral = true;
                ++indexInMask;
                continue;
            }
            value.insert(indexInText, (CharSequence)String.valueOf(charInMask));
            value.setSpan((Object)new LiteralSpan(), indexInText, indexInText + 1, 33);
            treatNextCharAsLiteral = false;
            ++indexInText;
            ++maskLength;
            ++indexInMask;
        }
        while (value.length() > maskLength) {
            int pos = value.length() - 1;
            value.delete(pos, pos + 1);
        }
        Selection.setSelection((Spannable)value, (int)value.getSpanStart(selection), (int)value.getSpanEnd(selection));
        value.removeSpan(selection);
        value.setFilters(inputFilters);
        int n = inputLength > 0 ? (maskIsNotNumeric ? 1 : 2) : (newInputType = 0);
        if (this.getInputType() != newInputType) {
            this.setInputType(newInputType);
        }
    }

    private void stripMaskChars(@NonNull Editable value) {
        PlaceholderSpan[] pSpans = (PlaceholderSpan[])value.getSpans(0, value.length(), PlaceholderSpan.class);
        LiteralSpan[] literalSpans = (LiteralSpan[])value.getSpans(0, value.length(), LiteralSpan.class);
        for (PlaceholderSpan placeholderSpan : pSpans) {
            value.delete(value.getSpanStart((Object)placeholderSpan), value.getSpanEnd((Object)placeholderSpan));
        }
        for (LiteralSpan literalSpan : literalSpans) {
            value.delete(value.getSpanStart((Object)literalSpan), value.getSpanEnd((Object)literalSpan));
        }
    }

    private boolean matchMask(char mask, char value) {
        return mask == '?' || mask == 'A' && Character.isLetter(value) || mask == '9' && Character.isDigit(value) || mask == '*' && (Character.isDigit(value) || Character.isLetter(value));
    }

    private boolean isMaskChar(char mask) {
        switch (mask) {
            case '*': 
            case '9': 
            case '?': 
            case 'A': {
                return true;
            }
        }
        return false;
    }

    private class LiteralSpan {
        private LiteralSpan() {
        }
    }

    private class PlaceholderSpan {
        private PlaceholderSpan() {
        }
    }
}

