/*
 * Decompiled with CFR 0.152.
 */
package ru.kode.detekt.rule.compose;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import ru.kode.detekt.rule.compose.UnnecessaryEventHandlerParameter;
import ru.kode.detekt.rule.compose.node.NodePredicatesKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isStateParameter", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "UnnecessaryHandlerArgumentsVisitor", "detekt-rules-compose"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryEventHandlerParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryEventHandlerParameter.kt\nru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n766#2:138\n857#2,2:139\n766#2:141\n857#2,2:142\n*S KotlinDebug\n*F\n+ 1 UnnecessaryEventHandlerParameter.kt\nru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter\n*L\n75#1:138\n75#1:139,2\n76#1:141\n76#1:142,2\n*E\n"})
public final class UnnecessaryEventHandlerParameter
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessaryEventHandlerParameter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Checks for unnecessary event handler parameters", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryEventHandlerParameter(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        block4: {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            String[] stringArray = new String[]{"Composable"};
            if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray)) break block4;
            List list = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.isStateParameter(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stateParameters = (List)destination$iv$iv;
            List list2 = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            Iterable $this$filter$iv2 = list2;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!NodePredicatesKt.isEventHandler(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List eventParameters = (List)destination$iv$iv2;
            if (!((Collection)stateParameters).isEmpty()) {
                KtExpression ktExpression = function.getBodyExpression();
                if (ktExpression != null) {
                    ktExpression.accept((PsiElementVisitor)new UnnecessaryHandlerArgumentsVisitor(stateParameters, eventParameters));
                }
            }
        }
    }

    private final boolean isStateParameter(KtParameter $this$isStateParameter) {
        return !NodePredicatesKt.isEventHandler($this$isStateParameter);
    }

    public UnnecessaryEventHandlerParameter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter$UnnecessaryHandlerArgumentsVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "stateParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "eventParameters", "(Lru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter;Ljava/util/List;Ljava/util/List;)V", "stateParameterNames", "", "reportError", "", "eventParameter", "argumentReceiverName", "argumentIndex", "", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-compose"})
    @SourceDebugExtension(value={"SMAP\nUnnecessaryEventHandlerParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryEventHandlerParameter.kt\nru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter$UnnecessaryHandlerArgumentsVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,137:1\n1549#2:138\n1620#2,3:139\n1864#2,2:143\n1866#2:150\n777#2:153\n788#2:154\n1864#2,2:155\n789#2,2:157\n1866#2:159\n791#2:160\n1#3:142\n643#4,5:145\n40#5,2:151\n*S KotlinDebug\n*F\n+ 1 UnnecessaryEventHandlerParameter.kt\nru/kode/detekt/rule/compose/UnnecessaryEventHandlerParameter$UnnecessaryHandlerArgumentsVisitor\n*L\n89#1:138\n89#1:139,3\n95#1:143,2\n95#1:150\n124#1:153\n124#1:154\n124#1:155,2\n124#1:157,2\n124#1:159\n124#1:160\n107#1:145,5\n123#1:151,2\n*E\n"})
    private final class UnnecessaryHandlerArgumentsVisitor
    extends DetektVisitor {
        @NotNull
        private final List<KtParameter> stateParameters;
        @NotNull
        private final List<KtParameter> eventParameters;
        @NotNull
        private final List<String> stateParameterNames;

        /*
         * WARNING - void declaration
         */
        public UnnecessaryHandlerArgumentsVisitor(@NotNull List<? extends KtParameter> stateParameters, List<? extends KtParameter> eventParameters) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(stateParameters, (String)"stateParameters");
            Intrinsics.checkNotNullParameter(eventParameters, (String)"eventParameters");
            this.stateParameters = stateParameters;
            this.eventParameters = eventParameters;
            Iterable iterable = this.stateParameters;
            UnnecessaryHandlerArgumentsVisitor unnecessaryHandlerArgumentsVisitor = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtParameter ktParameter = (KtParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            unnecessaryHandlerArgumentsVisitor.stateParameterNames = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Object v1;
            Object object;
            block13: {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitCallExpression(expression);
                object = this.eventParameters;
                for (Object t : object) {
                    KtParameter it = (KtParameter)t;
                    boolean bl = false;
                    KtExpression ktExpression = expression.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)(ktExpression != null ? ktExpression.getText() : null))) continue;
                    v1 = t;
                    break block13;
                }
                v1 = null;
            }
            KtParameter eventParameterForCall = v1;
            if (eventParameterForCall != null) {
                void $this$forEachIndexed$iv;
                List list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                Iterable iterable = list;
                object = UnnecessaryEventHandlerParameter.this;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    String argumentReceiverName;
                    String string;
                    int index;
                    block14: {
                        void argument;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        KtValueArgument ktValueArgument = (KtValueArgument)item$iv;
                        index = n;
                        boolean bl = false;
                        KtExpression argumentExpression = argument.getArgumentExpression();
                        if (argumentExpression instanceof KtDotQualifiedExpression && !(((KtDotQualifiedExpression)argumentExpression).getLastChild() instanceof KtCallExpression)) {
                            boolean hasSealedParent;
                            boolean bl2;
                            Object object2;
                            KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtDotQualifiedExpression)argumentExpression).getReceiverExpression(), (BindingContext)object.getBindingContext());
                            if (kotlinType != null) {
                                Boolean bl3;
                                KotlinType $this$visitCallExpression_u24lambda_u244_u24lambda_u242 = kotlinType;
                                boolean bl4 = false;
                                Collection collection = $this$visitCallExpression_u24lambda_u244_u24lambda_u242.getConstructor().getSupertypes();
                                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupertypes(...)");
                                KotlinType kotlinType2 = (KotlinType)CollectionsKt.firstOrNull((Iterable)collection);
                                if (kotlinType2 != null && (kotlinType2 = kotlinType2.getConstructor()) != null && (kotlinType2 = (object2 = kotlinType2.getDeclarationDescriptor())) != null) {
                                    Intrinsics.checkNotNull((Object)kotlinType2);
                                    bl3 = DescriptorUtilKt.isSealed((DeclarationDescriptor)((DeclarationDescriptor)object2));
                                } else {
                                    bl3 = null;
                                }
                                bl2 = Intrinsics.areEqual(bl3, (Object)true);
                            } else {
                                bl2 = hasSealedParent = false;
                            }
                            if (!hasSealedParent) {
                                String $this$takeWhile$iv;
                                Intrinsics.checkNotNullExpressionValue((Object)((KtDotQualifiedExpression)argumentExpression).getText(), (String)"getText(...)");
                                boolean $i$f$takeWhile = false;
                                int n2 = $this$takeWhile$iv.length();
                                for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                                    char it = $this$takeWhile$iv.charAt(index$iv2);
                                    boolean bl5 = false;
                                    if (it != '.') continue;
                                    object2 = $this$takeWhile$iv;
                                    int n3 = 0;
                                    String string2 = ((String)object2).substring(n3, index$iv2);
                                    string = string2;
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                                    break block14;
                                }
                                string = $this$takeWhile$iv;
                            } else {
                                string = null;
                            }
                        } else {
                            string = argumentExpression instanceof KtNameReferenceExpression ? argument.getText() : null;
                        }
                    }
                    if ((argumentReceiverName = string) == null || !this.stateParameterNames.contains(argumentReceiverName)) continue;
                    this.reportError(eventParameterForCall, argumentReceiverName, index);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void reportError(KtParameter eventParameter, String argumentReceiverName, int argumentIndex) {
            void $this$filterIndexedTo$iv$iv;
            Object element$iv2;
            block4: {
                PsiElement[] psiElementArray = eventParameter.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] $this$firstIsInstance$iv = psiElementArray;
                boolean $i$f$firstIsInstance = false;
                for (Object element$iv2 : $this$firstIsInstance$iv) {
                    if (!(element$iv2 instanceof KtTypeReference)) {
                        continue;
                    }
                    break block4;
                }
                throw new NoSuchElementException("No element of given type found");
            }
            KtTypeElement ktTypeElement = ((KtTypeReference)element$iv2).getTypeElement();
            Intrinsics.checkNotNull((Object)ktTypeElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
            KtFunctionType type = (KtFunctionType)ktTypeElement;
            List list = type.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            Iterable $this$filterIndexed$iv = list;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                KtParameter cfr_ignored_0 = (KtParameter)element$iv$iv;
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(index != argumentIndex)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List parameterList = (List)destination$iv$iv;
            UnnecessaryEventHandlerParameter.this.report((Finding)new CodeSmell(UnnecessaryEventHandlerParameter.this.getIssue(), Entity.Companion.from((PsiElement)eventParameter, Location.Companion.from$default((Location.Companion)Location.Companion, (PsiElement)((PsiElement)eventParameter), (int)0, (int)2, null)), "Unnecessary event callback arguments. Move all \"" + argumentReceiverName + "\" access to the parent composable event handler and switch \"" + eventParameter.getName() + "\" type to \"" + CollectionsKt.joinToString$default((Iterable)parameterList, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)reportError.1.INSTANCE, (int)25, null) + " -> Unit\"", null, null, 24, null));
        }
    }
}

