/*
 * Decompiled with CFR 0.152.
 */
package ru.kode.detekt.rule.compose;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import ru.kode.detekt.rule.compose.node.NodePredicatesKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/kode/detekt/rule/compose/ReusedModifierInstance;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "modifierClassPackage", "", "(Lio/gitlab/arturbosch/detekt/api/Config;Ljava/lang/String;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "ChildComposableCallsVisitor", "ChildrenWithModifiersVisitor", "detekt-rules-compose"})
@SourceDebugExtension(value={"SMAP\nReusedModifierInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReusedModifierInstance.kt\nru/kode/detekt/rule/compose/ReusedModifierInstance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,125:1\n1747#2,3:126\n158#3:129\n13309#4,2:130\n*S KotlinDebug\n*F\n+ 1 ReusedModifierInstance.kt\nru/kode/detekt/rule/compose/ReusedModifierInstance\n*L\n68#1:126,3\n69#1:129\n69#1:130,2\n*E\n"})
public final class ReusedModifierInstance
extends Rule {
    @NotNull
    private final String modifierClassPackage;
    @NotNull
    private final Issue issue;

    public ReusedModifierInstance(@NotNull Config config, @NotNull String modifierClassPackage) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)modifierClassPackage, (String)"modifierClassPackage");
        super(config, null, 2, null);
        this.modifierClassPackage = modifierClassPackage;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Reports errors in using modifier on wrong level of composable hierarchy", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ReusedModifierInstance(Config config, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n & 2) != 0) {
            string = "androidx.compose.ui";
        }
        this(config, string);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String[] stringArray = new String[]{"Composable"};
        if (KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray)) {
            boolean bl;
            block9: {
                List list = function.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!NodePredicatesKt.isModifier(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtCallExpression[] ktCallExpressionArray = function.getBodyBlockExpression();
                if (ktCallExpressionArray != null) {
                    PsiElement $this$getChildrenOfType$iv = (PsiElement)ktCallExpressionArray;
                    boolean $i$f$getChildrenOfType = false;
                    PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtCallExpression.class);
                    if (psiElementArray == null) {
                        psiElementArray = (PsiElement[])new KtCallExpression[0];
                    }
                    if ((ktCallExpressionArray = (KtCallExpression[])psiElementArray) != null) {
                        KtCallExpression[] $this$forEach$iv = ktCallExpressionArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            KtCallExpression element$iv;
                            KtCallExpression it = element$iv = $this$forEach$iv[i];
                            boolean bl3 = false;
                            it.accept((PsiElementVisitor)new ChildComposableCallsVisitor());
                        }
                    }
                }
            }
        }
        super.visitNamedFunction(function);
    }

    public ReusedModifierInstance() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b*\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0002\u00a8\u0006\u000b"}, d2={"Lru/kode/detekt/rule/compose/ReusedModifierInstance$ChildComposableCallsVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lru/kode/detekt/rule/compose/ReusedModifierInstance;)V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "hasModifierParameter", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "detekt-rules-compose"})
    @SourceDebugExtension(value={"SMAP\nReusedModifierInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReusedModifierInstance.kt\nru/kode/detekt/rule/compose/ReusedModifierInstance$ChildComposableCallsVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n1#2:126\n187#3,3:127\n*S KotlinDebug\n*F\n+ 1 ReusedModifierInstance.kt\nru/kode/detekt/rule/compose/ReusedModifierInstance$ChildComposableCallsVisitor\n*L\n89#1:127,3\n*E\n"})
    private final class ChildComposableCallsVisitor
    extends DetektVisitor {
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)ReusedModifierInstance.this.getBindingContext());
            boolean bl = resolvedCall != null ? this.hasModifierParameter((ResolvedCall<? extends CallableDescriptor>)resolvedCall) : false;
            if (bl) {
                Object v3;
                block4: {
                    List list = expression.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        KtValueArgument it = (KtValueArgument)t;
                        boolean bl2 = false;
                        if (!(it.getArgumentExpression() instanceof KtLambdaExpression)) continue;
                        v3 = t;
                        break block4;
                    }
                    v3 = null;
                }
                KtValueArgument ktValueArgument = v3;
                KtLambdaExpression contentLambdaExpression = (KtLambdaExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null);
                KtLambdaExpression ktLambdaExpression = contentLambdaExpression;
                if (ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) != null) {
                    ktLambdaExpression.accept((PsiElementVisitor)new ChildrenWithModifiersVisitor());
                }
            } else {
                super.visitCallExpression(expression);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasModifierParameter(ResolvedCall<? extends CallableDescriptor> $this$hasModifierParameter) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Map map = $this$hasModifierParameter.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getValueArguments(...)");
                Map map2 = map;
                ReusedModifierInstance reusedModifierInstance = ReusedModifierInstance.this;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl2 = false;
                        KotlinType kotlinType = ((ValueParameterDescriptor)it.getKey()).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                        FqName fqName = TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType);
                        if (!Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)(reusedModifierInstance.modifierClassPackage + ".Modifier"))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lru/kode/detekt/rule/compose/ReusedModifierInstance$ChildrenWithModifiersVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lru/kode/detekt/rule/compose/ReusedModifierInstance;)V", "reportError", "", "node", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "expression", "isModifierChainExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-compose"})
    @SourceDebugExtension(value={"SMAP\nReusedModifierInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReusedModifierInstance.kt\nru/kode/detekt/rule/compose/ReusedModifierInstance$ChildrenWithModifiersVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
    private final class ChildrenWithModifiersVisitor
    extends DetektVisitor {
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            KtExpression modifierArgExpression;
            Object v3;
            block5: {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                List list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    boolean bl;
                    KtExpression ktExpression;
                    KtValueArgument it = (KtValueArgument)t;
                    boolean bl2 = false;
                    KtExpression ktExpression2 = ktExpression = it.getArgumentExpression();
                    if (ktExpression2 != null) {
                        Intrinsics.checkNotNull((Object)ktExpression2);
                        bl = this.isModifierChainExpression(ktExpression);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            KtValueArgument ktValueArgument = v3;
            KtExpression ktExpression = modifierArgExpression = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
            if (modifierArgExpression != null) {
                String string = modifierArgExpression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"modifier", (boolean)false, (int)2, null)) {
                    this.reportError(expression);
                }
            }
            super.visitCallExpression(expression);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isModifierChainExpression(KtExpression $this$isModifierChainExpression) {
            KtExpression ktExpression = $this$isModifierChainExpression;
            if (ktExpression instanceof KtDotQualifiedExpression) {
                String string = ((KtDotQualifiedExpression)$this$isModifierChainExpression).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"Modifier", (boolean)false, (int)2, null)) return true;
                String string2 = ((KtDotQualifiedExpression)$this$isModifierChainExpression).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"modifier", (boolean)false, (int)2, null)) return false;
                return true;
            }
            if (!(ktExpression instanceof KtReferenceExpression)) return false;
            boolean bl = Intrinsics.areEqual((Object)((KtReferenceExpression)$this$isModifierChainExpression).getText(), (Object)"modifier");
            return bl;
        }

        private final void reportError(KtCallExpression node) {
            ReusedModifierInstance.this.report((Finding)new CodeSmell(ReusedModifierInstance.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)node), (int)0, (int)2, null), "Composable uses \"modifier\" on the wrong level, non-direct children should use \"Modifier\"", null, null, 24, null));
        }
    }
}

