/*
 * Decompiled with CFR 0.152.
 */
package ru.kode.detekt.rule.compose;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtValueArgument;
import ru.kode.detekt.rule.compose.ModifierHeightWithText;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lru/kode/detekt/rule/compose/ModifierHeightWithText;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "ChildrenWithModifiersVisitor", "detekt-rules-compose"})
public final class ModifierHeightWithText
extends Rule {
    @NotNull
    private final Issue issue;

    public ModifierHeightWithText(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Reports usage of height modifier in composable functions with text", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ModifierHeightWithText(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String[] stringArray = new String[]{"Composable"};
        if (KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray)) {
            KtBlockExpression ktBlockExpression = function.getBodyBlockExpression();
            if (ktBlockExpression != null) {
                ktBlockExpression.accept((PsiElementVisitor)new ChildrenWithModifiersVisitor());
            }
        }
        super.visitNamedFunction(function);
    }

    public ModifierHeightWithText() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lru/kode/detekt/rule/compose/ModifierHeightWithText$ChildrenWithModifiersVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lru/kode/detekt/rule/compose/ModifierHeightWithText;)V", "reportError", "", "node", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isModifierChainExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-compose"})
    @SourceDebugExtension(value={"SMAP\nModifierHeightWithText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierHeightWithText.kt\nru/kode/detekt/rule/compose/ModifierHeightWithText$ChildrenWithModifiersVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n1#2:101\n242#3:102\n253#3,9:103\n274#3:112\n158#3:113\n253#3,9:116\n274#3:125\n12474#4,2:114\n*S KotlinDebug\n*F\n+ 1 ModifierHeightWithText.kt\nru/kode/detekt/rule/compose/ModifierHeightWithText$ChildrenWithModifiersVisitor\n*L\n69#1:102\n69#1:103,9\n69#1:112\n72#1:113\n88#1:116,9\n88#1:125\n72#1:114,2\n*E\n"})
    private final class ChildrenWithModifiersVisitor
    extends DetektVisitor {
        /*
         * Unable to fully structure code
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            block14: {
                block12: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        v0 = expression.getValueArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValueArguments(...)");
                        var5_2 = v0;
                        for (T var7_4 : var5_2) {
                            it = (KtValueArgument)var7_4;
                            $i$a$-find-ModifierHeightWithText$ChildrenWithModifiersVisitor$visitCallExpression$contentLambdaExpression$1 = false;
                            if (!(it.getArgumentExpression() instanceof KtLambdaExpression)) continue;
                            v1 = var7_4;
                            break block11;
                        }
                        v1 = null;
                    }
                    var3_8 = v1;
                    contentLambdaExpression = (KtLambdaExpression)(var3_8 != null ? var3_8.getArgumentExpression() : null);
                    if (contentLambdaExpression == null) break block14;
                    v2 = expression.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getValueArguments(...)");
                    var5_2 = v2;
                    for (T var7_4 : var5_2) {
                        arg = (KtValueArgument)var7_4;
                        $i$a$-find-ModifierHeightWithText$ChildrenWithModifiersVisitor$visitCallExpression$argumentWithHeight$1 = false;
                        v3 = var10_10 = arg.getArgumentExpression();
                        if (v3 != null) {
                            Intrinsics.checkNotNull((Object)v3);
                            v4 = this.isModifierChainExpression(var10_10);
                        } else {
                            v4 = false;
                        }
                        if (!v4) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)arg);
                        var10_10 = (PsiElement)arg;
                        predicate$iv = visitCallExpression.argumentWithHeight.1.1.INSTANCE;
                        $i$f$anyDescendantOfType = false;
                        $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                        $i$f$findDescendantOfType = false;
                        $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                        $i$f$findDescendantOfType = false;
                        result$iv$iv$iv = new Ref.ObjectRef();
                        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(@NotNull PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        v5 = (PsiElement)result$iv$iv$iv.element != null;
                        if (v5) {
                            v6 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v7 = var7_4;
                        break block12;
                    }
                    v7 = null;
                }
                argumentWithHeight = v7;
                if (argumentWithHeight == null) break block14;
                v8 = contentLambdaExpression.getBodyExpression();
                if (v8 == null) ** GOTO lbl-1000
                $this$getChildrenOfType$iv = (PsiElement)v8;
                $i$f$getChildrenOfType = false;
                v9 = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtCallExpression.class);
                if (v9 == null) {
                    v9 = (PsiElement[])new KtCallExpression[0];
                }
                if ((v8 = (KtCallExpression[])v9) != null) {
                    block13: {
                        $this$any$iv = v8;
                        $i$f$any = false;
                        var10_11 = $this$any$iv.length;
                        for (var9_7 = 0; var9_7 < var10_11; ++var9_7) {
                            it = element$iv = $this$any$iv[var9_7];
                            $i$a$-any-ModifierHeightWithText$ChildrenWithModifiersVisitor$visitCallExpression$containsTextChild$1 = false;
                            v10 = it.getCalleeExpression();
                            if (!Intrinsics.areEqual((Object)(v10 != null ? v10.getText() : null), (Object)"Text")) continue;
                            v11 = true;
                            break block13;
                        }
                        v11 = false;
                    }
                    v12 = v11;
                } else lbl-1000:
                // 2 sources

                {
                    v12 = containsTextChild = null;
                }
                if (Intrinsics.areEqual(containsTextChild, (Object)true)) {
                    this.reportError(argumentWithHeight);
                }
            }
            super.visitCallExpression(expression);
        }

        private final boolean isModifierChainExpression(KtExpression $this$isModifierChainExpression) {
            boolean bl;
            Object object = $this$isModifierChainExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)$this$isModifierChainExpression : null;
            if (object != null && (object = object.getText()) != null) {
                Object it = object;
                boolean bl2 = false;
                bl = StringsKt.startsWith$default((String)it, (String)"Modifier", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"modifier", (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final void reportError(KtValueArgument node) {
            void $this$findDescendantOfType$iv;
            PsiElement psiElement = (PsiElement)node;
            Function1 predicate$iv = reportError.heightCall.1.INSTANCE;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            KtCallExpression ktCallExpression = (KtCallExpression)((PsiElement)result$iv$iv.element);
            if (ktCallExpression == null) {
                throw new IllegalStateException("didn't find height-call node".toString());
            }
            KtCallExpression heightCall2 = ktCallExpression;
            ModifierHeightWithText.this.report((Finding)new CodeSmell(ModifierHeightWithText.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)heightCall2), (int)0, (int)2, null), "Composable uses \"height\" modifier and contains a Text child. Use heightIn(min = N.dp) instead", null, null, 24, null));
        }
    }
}

