/*
 * Decompiled with CFR 0.152.
 */
package ru.kode.detekt.rule.compose;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ru.kode.detekt.rule.compose.node.NodePredicatesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lru/kode/detekt/rule/compose/MissingModifierDefaultValue;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "reportError", "", "node", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-compose"})
@SourceDebugExtension(value={"SMAP\nMissingModifierDefaultValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingModifierDefaultValue.kt\nru/kode/detekt/rule/compose/MissingModifierDefaultValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class MissingModifierDefaultValue
extends Rule {
    @NotNull
    private final Issue issue;

    public MissingModifierDefaultValue(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Checks that Modifier parameter has a default value", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MissingModifierDefaultValue(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        block8: {
            KtParameter modifierParameter;
            block10: {
                block9: {
                    Object v1;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        if (KtModifierListKt.isActual((KtModifierListOwner)((KtModifierListOwner)function))) {
                            return;
                        }
                        String[] stringArray = new String[]{"Composable"};
                        if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray)) break block8;
                        List list = function.getValueParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
                        Iterable iterable = list;
                        for (Object t : iterable) {
                            KtParameter it = (KtParameter)t;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!NodePredicatesKt.isModifier(it)) continue;
                            v1 = t;
                            break block7;
                        }
                        v1 = null;
                    }
                    modifierParameter = v1;
                    if (KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)function)) || KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)function))) break block9;
                    KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)function));
                    boolean bl = ktClass != null ? ktClass.isInterface() : false;
                    if (!bl) break block10;
                }
                return;
            }
            if (!KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
                KtParameter ktParameter = modifierParameter;
                boolean bl = ktParameter != null ? !ktParameter.hasDefaultValue() : false;
                if (bl) {
                    this.reportError(modifierParameter);
                }
            }
        }
    }

    private final void reportError(KtParameter node) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)node), (int)0, (int)2, null), "Modifier parameter should have a default value: \"modifier = Modifier\"", null, null, 24, null));
    }

    public MissingModifierDefaultValue() {
        this(null, 1, null);
    }
}

