/*
 * Decompiled with CFR 0.152.
 */
package ru.kode.detekt.rule.compose;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import ru.kode.detekt.rule.compose.node.NodePredicatesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lru/kode/detekt/rule/compose/ComposableEventParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "reportError", "", "node", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-compose"})
@SourceDebugExtension(value={"SMAP\nComposableEventParameterNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableEventParameterNaming.kt\nru/kode/detekt/rule/compose/ComposableEventParameterNaming\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n766#2:75\n857#2,2:76\n1855#2,2:78\n*S KotlinDebug\n*F\n+ 1 ComposableEventParameterNaming.kt\nru/kode/detekt/rule/compose/ComposableEventParameterNaming\n*L\n47#1:75\n47#1:76,2\n47#1:78,2\n*E\n"})
public final class ComposableEventParameterNaming
extends Rule {
    @NotNull
    private final Issue issue;

    public ComposableEventParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Checks Composable event parameters naming", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ComposableEventParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String[] stringArray = new String[]{"Composable"};
        if (KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray)) {
            void $this$filterTo$iv$iv;
            List list = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!NodePredicatesKt.isEventHandler(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name;
                KtParameter parameter = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parameter.getName());
                if (!StringsKt.startsWith$default((String)name, (String)"on", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)parameter);
                    this.reportError(parameter);
                    continue;
                }
                if (!StringsKt.endsWith$default((String)name, (String)"ed", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)parameter);
                this.reportError(parameter);
            }
        }
    }

    private final void reportError(KtParameter node) {
        String string = node.getName();
        Intrinsics.checkNotNull((Object)string);
        String name = string;
        boolean usesPastTense = StringsKt.startsWith$default((String)name, (String)"on", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"ed", (boolean)false, (int)2, null);
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)node), (int)0, (int)2, null), usesPastTense ? "Invalid event parameter name \"" + name + "\". Do not use past tense. For example: \"onClicked\" \u2192 \"onClick\"" : "Invalid event parameter name \"" + name + "\". Use names like \"onClick\", \"onValueChange\" etc", null, null, 24, null));
    }

    public ComposableEventParameterNaming() {
        this(null, 1, null);
    }
}

