/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.CoordinateTranslator;
import ru.fix.completable.reactor.graph.viewer.EndPointNode;
import ru.fix.completable.reactor.graph.viewer.GraphNode;
import ru.fix.completable.reactor.graph.viewer.GraphPane;
import ru.fix.completable.reactor.graph.viewer.GraphViewPane;
import ru.fix.completable.reactor.graph.viewer.GraphViewPaneKt;
import ru.fix.completable.reactor.graph.viewer.GraphViewer;
import ru.fix.completable.reactor.graph.viewer.HandlerNode;
import ru.fix.completable.reactor.graph.viewer.MergerNode;
import ru.fix.completable.reactor.graph.viewer.NodeDragger;
import ru.fix.completable.reactor.graph.viewer.NodeDraggerListener;
import ru.fix.completable.reactor.graph.viewer.RouterNode;
import ru.fix.completable.reactor.graph.viewer.Shortcut;
import ru.fix.completable.reactor.graph.viewer.ShortcutType;
import ru.fix.completable.reactor.graph.viewer.StartPointNode;
import ru.fix.completable.reactor.graph.viewer.SubgraphNode;
import ru.fix.completable.reactor.graph.viewer.TransitionLine;
import ru.fix.completable.reactor.model.CompileTimeGraph;
import ru.fix.completable.reactor.model.EndPoint;
import ru.fix.completable.reactor.model.Figure;
import ru.fix.completable.reactor.model.HandleableVertexFigure;
import ru.fix.completable.reactor.model.Handler;
import ru.fix.completable.reactor.model.Merger;
import ru.fix.completable.reactor.model.Router;
import ru.fix.completable.reactor.model.Source;
import ru.fix.completable.reactor.model.StartPoint;
import ru.fix.completable.reactor.model.Subgraph;
import ru.fix.completable.reactor.model.Transition;
import ru.fix.completable.reactor.model.TransitionableFigure;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0018\u0010*\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010+\u001a\u00020,R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010$\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b%\u0010 \"\u0004\b&\u0010\"\u00a8\u0006-"}, d2={"Lru/fix/completable/reactor/graph/viewer/GraphViewPane;", "Ljavafx/scene/control/ScrollPane;", "actionListener", "Lru/fix/completable/reactor/graph/viewer/GraphViewer$ActionListener;", "shortcutProvider", "Lkotlin/Function1;", "Lru/fix/completable/reactor/graph/viewer/ShortcutType;", "Lru/fix/completable/reactor/graph/viewer/Shortcut;", "(Lru/fix/completable/reactor/graph/viewer/GraphViewer$ActionListener;Lkotlin/jvm/functions/Function1;)V", "MAX_SCALE", "", "getMAX_SCALE", "()D", "MIN_SCALE", "getMIN_SCALE", "ZOOM_CHANGE_FACTOR", "getZOOM_CHANGE_FACTOR", "getActionListener", "()Lru/fix/completable/reactor/graph/viewer/GraphViewer$ActionListener;", "<set-?>", "Lru/fix/completable/reactor/model/CompileTimeGraph;", "graphModel", "getGraphModel", "()Lru/fix/completable/reactor/model/CompileTimeGraph;", "oldScrollPosition", "Ljavafx/geometry/Point2D;", "pane", "Lru/fix/completable/reactor/graph/viewer/GraphPane;", "getShortcutProvider", "()Lkotlin/jvm/functions/Function1;", "targetViewportPositionX", "getTargetViewportPositionX", "()Ljava/lang/Double;", "setTargetViewportPositionX", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "targetViewportPositionY", "getTargetViewportPositionY", "setTargetViewportPositionY", "enableNodeDragging", "", "initializePopupMenu", "openGraph", "resetViewer", "", "completable-reactor-graph-viewer"})
public final class GraphViewPane
extends ScrollPane {
    private final double MIN_SCALE = 0.3;
    private final double MAX_SCALE = 2.0;
    private final double ZOOM_CHANGE_FACTOR = 1.15;
    private final GraphPane pane;
    private Point2D oldScrollPosition;
    @Nullable
    private CompileTimeGraph graphModel;
    @Nullable
    private Double targetViewportPositionX;
    @Nullable
    private Double targetViewportPositionY;
    @NotNull
    private final GraphViewer.ActionListener actionListener;
    @NotNull
    private final Function1<ShortcutType, Shortcut> shortcutProvider;

    public final double getMIN_SCALE() {
        return this.MIN_SCALE;
    }

    public final double getMAX_SCALE() {
        return this.MAX_SCALE;
    }

    public final double getZOOM_CHANGE_FACTOR() {
        return this.ZOOM_CHANGE_FACTOR;
    }

    @Nullable
    public final CompileTimeGraph getGraphModel() {
        return this.graphModel;
    }

    public final void initializePopupMenu() {
        Object object;
        ContextMenu contextMenu;
        block3: {
            block2: {
                contextMenu = new ContextMenu();
                object = (Shortcut)this.shortcutProvider.invoke((Object)ShortcutType.GOTO_GRAPH);
                if (object == null || (object = ((Shortcut)object).getTitle()) == null) break block2;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = " (" + (String)it + ')';
                if (object != null) break block3;
            }
            object = "";
        }
        Object shortcutTitleSuffix = object;
        MenuItem buildGraphMenuItem = new MenuItem("Graph location" + (String)shortcutTitleSuffix);
        buildGraphMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void handle(ActionEvent it) {
                block0: {
                    CompileTimeGraph compileTimeGraph = this.this$0.getGraphModel();
                    if (compileTimeGraph == null || (compileTimeGraph = compileTimeGraph.getStartPoint()) == null || (compileTimeGraph = compileTimeGraph.getSource()) == null) break block0;
                    CompileTimeGraph compileTimeGraph2 = compileTimeGraph;
                    boolean bl = false;
                    boolean bl2 = false;
                    CompileTimeGraph it2 = compileTimeGraph2;
                    boolean bl3 = false;
                    this.this$0.getActionListener().goToSource((Source)it2);
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        contextMenu.getItems().add((Object)buildGraphMenuItem);
        this.pane.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(this, contextMenu){
            final /* synthetic */ GraphViewPane this$0;
            final /* synthetic */ ContextMenu $contextMenu;

            public final void handle(ContextMenuEvent contextMenuEvent) {
                this.$contextMenu.show((Node)GraphViewPane.access$getPane$p(this.this$0), contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
            {
                this.this$0 = graphViewPane2;
                this.$contextMenu = contextMenu;
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(contextMenu){
            final /* synthetic */ ContextMenu $contextMenu;

            public final void handle(MouseEvent event) {
                this.$contextMenu.hide();
            }
            {
                this.$contextMenu = contextMenu;
            }
        });
    }

    @NotNull
    public final GraphViewPane openGraph(@NotNull CompileTimeGraph graphModel, boolean resetViewer) {
        GraphNode it;
        TransitionLine line;
        MergerNode mergerNode;
        Object element$iv;
        Object mergerNode2;
        Object endPointNode;
        Object handlerNode;
        Intrinsics.checkParameterIsNotNull((Object)graphModel, (String)"graphModel");
        this.graphModel = graphModel;
        if (!resetViewer) {
            this.oldScrollPosition = new Point2D(this.getHvalue(), this.getVvalue());
        }
        this.pane.getChildren().clear();
        AtomicReference<StartPointNode> graphNodeTreeForAutoLayout = new AtomicReference<StartPointNode>();
        HashMap handlers = new HashMap();
        Iterator iterator = graphModel.getHandlers().values().iterator();
        while (iterator.hasNext()) {
            Handler handler;
            Handler handler2 = handler = (Handler)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)handler2, (String)"handler");
            handlerNode = new HandlerNode(handler2, this.actionListener);
            ((Map)handlers).put(handler, handlerNode);
            this.pane.getChildren().add(handlerNode);
        }
        HashMap subgraphs = new HashMap();
        handlerNode = graphModel.getSubgraphs().values().iterator();
        while (handlerNode.hasNext()) {
            Subgraph subgraph;
            Subgraph subgraph2 = subgraph = (Subgraph)handlerNode.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)subgraph2, (String)"subgraph");
            SubgraphNode subgraphNode = new SubgraphNode(subgraph2, this.actionListener);
            ((Map)subgraphs).put(subgraph, subgraphNode);
            this.pane.getChildren().add((Object)subgraphNode);
        }
        StartPointNode startPointNode = new StartPointNode(graphModel.getStartPoint(), graphModel, this.actionListener);
        this.pane.getChildren().add((Object)startPointNode);
        graphNodeTreeForAutoLayout.set(startPointNode);
        HashMap endpoints = new HashMap();
        Iterator iterator2 = graphModel.getEndpoints().values().iterator();
        while (iterator2.hasNext()) {
            EndPoint endPoint;
            EndPoint endPoint2 = endPoint = (EndPoint)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)endPoint2, (String)"endPoint");
            endPointNode = new EndPointNode(endPoint2, this.actionListener);
            ((Map)endpoints).put(endPoint, endPointNode);
            this.pane.getChildren().addAll((Object[])new Node[]{(Node)endPointNode});
        }
        HashMap mergers = new HashMap();
        endPointNode = graphModel.getMergers().values().iterator();
        while (endPointNode.hasNext()) {
            Merger merger;
            Merger merger2 = merger = (Merger)endPointNode.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)merger2, (String)"merger");
            mergerNode2 = new MergerNode(merger2, this.actionListener);
            ((Map)mergers).put(merger, mergerNode2);
            this.pane.getChildren().add(mergerNode2);
        }
        HashMap routers = new HashMap();
        mergerNode2 = graphModel.getRouters().values().iterator();
        while (mergerNode2.hasNext()) {
            Router router;
            Router router2 = router = (Router)mergerNode2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)router2, (String)"router");
            RouterNode routerNode = new RouterNode(router2, this.actionListener);
            ((Map)routers).put(router, routerNode);
            this.pane.getChildren().add((Object)routerNode);
        }
        Function1<TransitionableFigure, GraphNode> $fun$transitionable$1 = new Function1<TransitionableFigure, GraphNode>(mergers, routers){
            final /* synthetic */ HashMap $mergers;
            final /* synthetic */ HashMap $routers;

            @NotNull
            public final GraphNode invoke(@NotNull TransitionableFigure figure) {
                GraphNode graphNode;
                Intrinsics.checkParameterIsNotNull((Object)figure, (String)"figure");
                TransitionableFigure transitionableFigure = figure;
                if (transitionableFigure instanceof Merger) {
                    V v = this.$mergers.get(figure);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"mergers[figure]!!");
                    graphNode = (GraphNode)v;
                } else if (transitionableFigure instanceof Router) {
                    V v = this.$routers.get(figure);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"routers[figure]!!");
                    graphNode = (GraphNode)v;
                } else {
                    throw (Throwable)new IllegalArgumentException("figure: " + figure);
                }
                return graphNode;
            }
            {
                this.$mergers = hashMap;
                this.$routers = hashMap2;
                super(1);
            }
        };
        var $fun$figureNode$2 = new Function1<Figure, GraphNode>(subgraphs, handlers, mergers, routers, endpoints, startPointNode){
            final /* synthetic */ HashMap $subgraphs;
            final /* synthetic */ HashMap $handlers;
            final /* synthetic */ HashMap $mergers;
            final /* synthetic */ HashMap $routers;
            final /* synthetic */ HashMap $endpoints;
            final /* synthetic */ StartPointNode $startPointNode;

            @Nullable
            public final GraphNode invoke(@NotNull Figure figure) {
                GraphNode graphNode;
                Intrinsics.checkParameterIsNotNull((Object)figure, (String)"figure");
                Figure figure2 = figure;
                if (figure2 instanceof Subgraph) {
                    graphNode = (GraphNode)this.$subgraphs.get(figure);
                } else if (figure2 instanceof Handler) {
                    graphNode = (GraphNode)this.$handlers.get(figure);
                } else if (figure2 instanceof Merger) {
                    graphNode = (GraphNode)this.$mergers.get(figure);
                } else if (figure2 instanceof Router) {
                    graphNode = (GraphNode)this.$routers.get(figure);
                } else if (figure2 instanceof EndPoint) {
                    graphNode = (GraphNode)this.$endpoints.get(figure);
                } else if (figure2 instanceof StartPoint) {
                    graphNode = this.$startPointNode;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return graphNode;
            }
            {
                this.$subgraphs = hashMap;
                this.$handlers = hashMap2;
                this.$mergers = hashMap3;
                this.$routers = hashMap4;
                this.$endpoints = hashMap5;
                this.$startPointNode = startPointNode;
                super(1);
            }
        };
        Collection collection = graphModel.getHandlers().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"graphModel.handlers.values");
        Object $this$forEach$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<Handler, Pair<? extends HandlerNode, ? extends MergerNode>>(graphModel, handlers, mergers){
            final /* synthetic */ CompileTimeGraph $graphModel;
            final /* synthetic */ HashMap $handlers;
            final /* synthetic */ HashMap $mergers;

            @Nullable
            public final Pair<HandlerNode, MergerNode> invoke(@NotNull Handler handler) {
                Pair pair;
                Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
                Merger merger = (Merger)this.$graphModel.getMergers().get(handler.getName());
                if (merger != null) {
                    Merger merger2 = merger;
                    boolean bl = false;
                    boolean bl2 = false;
                    Merger merger3 = merger2;
                    boolean bl3 = false;
                    V v = this.$handlers.get(handler);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    V v2 = this.$mergers.get(merger3);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    pair = new Pair(v, v2);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$graphModel = compileTimeGraph;
                this.$handlers = hashMap;
                this.$mergers = hashMap2;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            Pair $dstr$handlerNode$mergerNode = (Pair)element$iv;
            boolean bl = false;
            HandlerNode handlerNode2 = (HandlerNode)$dstr$handlerNode$mergerNode.component1();
            mergerNode = (MergerNode)$dstr$handlerNode$mergerNode.component2();
            Node node = (Node)this.pane;
            HandlerNode handlerNode3 = handlerNode2;
            Intrinsics.checkExpressionValueIsNotNull((Object)handlerNode3, (String)"handlerNode");
            Node node2 = (Node)handlerNode3;
            MergerNode mergerNode3 = mergerNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergerNode3, (String)"mergerNode");
            line = new TransitionLine(node, node2, (Node)mergerNode3, null, this.actionListener);
            this.pane.getChildren().add((Object)line);
            line.toBack();
            ((ArrayList)handlerNode2.getGraphChildren()).add(mergerNode);
        }
        Collection collection2 = graphModel.getSubgraphs().values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"graphModel.subgraphs.values");
        $this$forEach$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)((Function1)new Function1<Subgraph, Pair<? extends SubgraphNode, ? extends MergerNode>>(graphModel, subgraphs, mergers){
            final /* synthetic */ CompileTimeGraph $graphModel;
            final /* synthetic */ HashMap $subgraphs;
            final /* synthetic */ HashMap $mergers;

            @Nullable
            public final Pair<SubgraphNode, MergerNode> invoke(@NotNull Subgraph subgraph) {
                Pair pair;
                Intrinsics.checkParameterIsNotNull((Object)subgraph, (String)"subgraph");
                Merger merger = (Merger)this.$graphModel.getMergers().get(subgraph.getName());
                if (merger != null) {
                    Merger merger2 = merger;
                    boolean bl = false;
                    boolean bl2 = false;
                    Merger merger3 = merger2;
                    boolean bl3 = false;
                    V v = this.$subgraphs.get(subgraph);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    V v2 = this.$mergers.get(merger3);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    pair = new Pair(v, v2);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$graphModel = compileTimeGraph;
                this.$subgraphs = hashMap;
                this.$mergers = hashMap2;
                super(1);
            }
        }));
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            Pair $dstr$subgraphNode$mergerNode = (Pair)element$iv;
            boolean bl = false;
            SubgraphNode subgraphNode = (SubgraphNode)$dstr$subgraphNode$mergerNode.component1();
            mergerNode = (MergerNode)$dstr$subgraphNode$mergerNode.component2();
            Node node = (Node)this.pane;
            SubgraphNode subgraphNode2 = subgraphNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)subgraphNode2, (String)"subgraphNode");
            Node node3 = (Node)subgraphNode2;
            MergerNode mergerNode4 = mergerNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergerNode4, (String)"mergerNode");
            line = new TransitionLine(node, node3, (Node)mergerNode4, null, this.actionListener);
            this.pane.getChildren().add((Object)line);
            line.toBack();
            ((ArrayList)subgraphNode.getGraphChildren()).add(mergerNode);
        }
        $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)graphModel.getTransitionable().getValues()), (Function1)openGraph.7.INSTANCE), (Function1)((Function1)new Function1<TransitionableFigure, Pair<? extends TransitionableFigure, ? extends GraphNode>>($fun$transitionable$1){
            final /* synthetic */ openGraph.1 $transitionable$1;

            @NotNull
            public final Pair<TransitionableFigure, GraphNode> invoke(@NotNull TransitionableFigure it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new Pair((Object)it, (Object)this.$transitionable$1.invoke(it));
            }
            {
                this.$transitionable$1 = var1_1;
                super(1);
            }
        }));
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        block7: while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            Pair $dstr$transitionable$transitionableNode = (Pair)element$iv;
            boolean bl = false;
            TransitionableFigure transitionable = (TransitionableFigure)$dstr$transitionable$transitionableNode.component1();
            GraphNode transitionableNode = (GraphNode)$dstr$transitionable$transitionableNode.component2();
            for (Transition transition : transitionable.getTransitions()) {
                GraphNode toNode = $fun$figureNode$2.invoke(transition.getTarget());
                if (toNode == null) {
                    GraphViewPaneKt.access$getLog$p().error((Function0)new Function0<String>(transitionableNode, transition){
                        final /* synthetic */ GraphNode $transitionableNode;
                        final /* synthetic */ Transition $transition;

                        @NotNull
                        public final String invoke() {
                            return "Failed to build transition line" + " from " + this.$transitionableNode.getFigure() + " to " + this.$transition.getTarget() + '.' + " Skip line and children.";
                        }
                        {
                            this.$transitionableNode = graphNode;
                            this.$transition = transition;
                            super(0);
                        }
                    });
                    continue block7;
                }
                TransitionLine line2 = new TransitionLine((Node)this.pane, (Node)transitionableNode, (Node)toNode, transition, this.actionListener);
                this.pane.getChildren().add((Object)line2);
                line2.toBack();
                ((ArrayList)transitionableNode.getGraphChildren()).add(toNode);
            }
        }
        $this$forEach$iv = graphModel.getStartPoint().getHandleBy();
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            HandleableVertexFigure figure = (HandleableVertexFigure)element$iv;
            boolean bl = false;
            GraphNode toNode = $fun$figureNode$2.invoke((Figure)figure);
            if (toNode == null) {
                GraphViewPaneKt.access$getLog$p().error((Function0)new Function0<String>(figure){
                    final /* synthetic */ HandleableVertexFigure $figure;

                    @NotNull
                    public final String invoke() {
                        return "Failed to build transition line" + " from StartPoint to " + this.$figure + '.' + " Skip transition and children.";
                    }
                    {
                        this.$figure = handleableVertexFigure;
                        super(0);
                    }
                });
                continue;
            }
            TransitionLine line3 = new TransitionLine((Node)this.pane, (Node)startPointNode, (Node)toNode, null, this.actionListener);
            this.pane.getChildren().add((Object)line3);
            line3.toBack();
            ((ArrayList)startPointNode.getGraphChildren()).add(toNode);
        }
        Collection collection3 = mergers.values();
        Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"mergers.values");
        $this$forEach$iv = collection3;
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            it = (MergerNode)element$iv;
            boolean bl = false;
            it.toFront();
        }
        Collection collection4 = routers.values();
        Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"routers.values");
        $this$forEach$iv = collection4;
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            it = (RouterNode)element$iv;
            boolean bl = false;
            it.toFront();
        }
        this.enableNodeDragging();
        this.hvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void changed(ObservableValue<? extends Number> observable, Number old, Number number) {
                Double positionX = this.this$0.getTargetViewportPositionX();
                if (positionX != null && Intrinsics.areEqual((Object)positionX, (Object)number) ^ true) {
                    Platform.runLater((Runnable)new Runnable(this, positionX){
                        final /* synthetic */ openGraph.13 this$0;
                        final /* synthetic */ Double $positionX;

                        public final void run() {
                            this.this$0.this$0.setTargetViewportPositionX(null);
                            this.this$0.this$0.setHvalue(this.$positionX);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$positionX = d;
                        }
                    });
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        this.vvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void changed(ObservableValue<? extends Number> observable, Number old, Number number) {
                Double positionY = this.this$0.getTargetViewportPositionY();
                if (positionY != null && Intrinsics.areEqual((Object)positionY, (Object)number) ^ true) {
                    Platform.runLater((Runnable)new Runnable(this, positionY){
                        final /* synthetic */ openGraph.14 this$0;
                        final /* synthetic */ Double $positionY;

                        public final void run() {
                            this.this$0.this$0.setTargetViewportPositionY(null);
                            this.this$0.this$0.setVvalue(this.$positionY);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$positionY = d;
                        }
                    });
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        this.pane.requestResize((Function0<Unit>)((Function0)new Function0<Unit>(this, resetViewer){
            final /* synthetic */ GraphViewPane this$0;
            final /* synthetic */ boolean $resetViewer;

            public final void invoke() {
                Point2D position = this.$resetViewer ? new Point2D(0.5, 0.5) : GraphViewPane.access$getOldScrollPosition$p(this.this$0);
                this.this$0.setTargetViewportPositionX(position.getX());
                this.this$0.setTargetViewportPositionY(position.getY());
                this.this$0.setHvalue(position.getX());
                this.this$0.setVvalue(position.getY());
            }
            {
                this.this$0 = graphViewPane2;
                this.$resetViewer = bl;
                super(0);
            }
        }));
        return this;
    }

    public static /* synthetic */ GraphViewPane openGraph$default(GraphViewPane graphViewPane2, CompileTimeGraph compileTimeGraph, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return graphViewPane2.openGraph(compileTimeGraph, bl);
    }

    public final void enableNodeDragging() {
        ObservableList observableList = this.pane.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"pane.children");
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)observableList)), (Function1)enableNodeDragging.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphNode it = (GraphNode)element$iv;
            boolean bl = false;
            NodeDragger.Companion.attach(it, new NodeDraggerListener(this){
                final /* synthetic */ GraphViewPane this$0;
                {
                    this.this$0 = graphViewPane2;
                }

                public void modelChanging() {
                    GraphViewPane.access$getPane$p(this.this$0).requestLayout();
                }

                public void modelChanged() {
                    block0: {
                        GraphViewPane.access$getPane$p(this.this$0).requestResize((Function0<Unit>)((Function0)enableNodeDragging.2.modelChanged.1.INSTANCE));
                        CompileTimeGraph compileTimeGraph = this.this$0.getGraphModel();
                        if (compileTimeGraph == null) break block0;
                        CompileTimeGraph compileTimeGraph2 = compileTimeGraph;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompileTimeGraph it = compileTimeGraph2;
                        boolean bl3 = false;
                        this.this$0.getActionListener().coordinatesChanged(it);
                    }
                }
            }, new CoordinateTranslator(this.pane));
        }
    }

    @Nullable
    public final Double getTargetViewportPositionX() {
        return this.targetViewportPositionX;
    }

    public final void setTargetViewportPositionX(@Nullable Double d) {
        this.targetViewportPositionX = d;
    }

    @Nullable
    public final Double getTargetViewportPositionY() {
        return this.targetViewportPositionY;
    }

    public final void setTargetViewportPositionY(@Nullable Double d) {
        this.targetViewportPositionY = d;
    }

    @NotNull
    public final GraphViewer.ActionListener getActionListener() {
        return this.actionListener;
    }

    @NotNull
    public final Function1<ShortcutType, Shortcut> getShortcutProvider() {
        return this.shortcutProvider;
    }

    public GraphViewPane(@NotNull GraphViewer.ActionListener actionListener, @NotNull Function1<? super ShortcutType, Shortcut> shortcutProvider) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        Intrinsics.checkParameterIsNotNull(shortcutProvider, (String)"shortcutProvider");
        this.actionListener = actionListener;
        this.shortcutProvider = shortcutProvider;
        this.MIN_SCALE = 0.3;
        this.MAX_SCALE = 2.0;
        this.ZOOM_CHANGE_FACTOR = 1.15;
        this.pane = new GraphPane();
        this.oldScrollPosition = new Point2D(0.5, 0.5);
        this.pane.getStyleClass().add((Object)"graphViewer");
        this.setPannable(true);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setContent((Node)this.pane);
        this.pane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public final void handle(ScrollEvent scrollEvent) {
                ScrollEvent scrollEvent2 = scrollEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)scrollEvent2, (String)"scrollEvent");
                if (scrollEvent2.isControlDown()) {
                    scrollEvent.consume();
                    double zoomChangeFactor = scrollEvent.getDeltaY() > 0.0 ? this.getZOOM_CHANGE_FACTOR() : 1.0 / this.getZOOM_CHANGE_FACTOR();
                    double newScaleX = pane.getScaleX() * zoomChangeFactor;
                    double newScaleY = pane.getScaleY() * zoomChangeFactor;
                    if (newScaleX > this.getMIN_SCALE() && newScaleX < this.getMAX_SCALE() && newScaleY > this.getMIN_SCALE() && newScaleY < this.getMAX_SCALE()) {
                        pane.setScaleX(newScaleX);
                        pane.setScaleY(newScaleY);
                    }
                } else {
                    scrollEvent.consume();
                }
            }
        });
        this.initializePopupMenu();
    }

    public static final /* synthetic */ CompileTimeGraph access$getGraphModel$p(GraphViewPane $this) {
        return $this.graphModel;
    }

    public static final /* synthetic */ void access$setGraphModel$p(GraphViewPane $this, CompileTimeGraph compileTimeGraph) {
        $this.graphModel = compileTimeGraph;
    }

    public static final /* synthetic */ Point2D access$getOldScrollPosition$p(GraphViewPane $this) {
        return $this.oldScrollPosition;
    }

    public static final /* synthetic */ void access$setOldScrollPosition$p(GraphViewPane $this, Point2D point2D) {
        $this.oldScrollPosition = point2D;
    }
}

