/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.viewer.AutoLayoutable;
import ru.fix.completable.reactor.model.EndPoint;
import ru.fix.completable.reactor.model.Figure;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0017\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0082\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lru/fix/completable/reactor/graph/viewer/AutoLayout;", "", "()V", "deltaX", "", "deltaY", "layout", "", "node", "Lru/fix/completable/reactor/graph/viewer/AutoLayoutable;", "recursiveFixCoordinates", "nodes", "", "completable-reactor-graph-viewer"})
public final class AutoLayout {
    private final int deltaX = 200;
    private final int deltaY = 55;

    public final void layout(@NotNull AutoLayoutable node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.recursiveFixCoordinates(CollectionsKt.listOf((Object)node));
    }

    private final void recursiveFixCoordinates(List<? extends AutoLayoutable> nodes2) {
        while (true) {
            ArrayList<AutoLayoutable> nodesToProcess = new ArrayList<AutoLayoutable>();
            for (AutoLayoutable parentNode : nodes2) {
                int parentX = parentNode.nodeCenterX();
                int parentY = parentNode.nodeCenterY();
                int index = -1 * (parentNode.getGraphChildren().size() / 2);
                for (AutoLayoutable node : parentNode.getGraphChildren()) {
                    Figure figure = node.getFigure();
                    if (figure instanceof EndPoint) {
                        if (node.isUserDefinedCoordinates()) continue;
                        node.setNodeX(parentX);
                        node.setNodeY(this.deltaY + parentY);
                        continue;
                    }
                    if (!node.isUserDefinedCoordinates()) {
                        node.setNodeX(this.deltaX * index++ + parentX);
                        node.setNodeY(this.deltaY + parentY);
                    }
                    nodesToProcess.add(node);
                }
            }
            if (nodesToProcess.isEmpty()) break;
            nodes2 = nodesToProcess;
        }
    }
}

