/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer;

import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.viewer.CentrableNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lru/fix/completable/reactor/graph/viewer/NodeCenter;", "", "world", "Ljavafx/scene/Node;", "node", "(Ljavafx/scene/Node;Ljavafx/scene/Node;)V", "centerX", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "getCenterX", "()Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "centerY", "getCenterY", "completable-reactor-graph-viewer"})
public final class NodeCenter {
    @NotNull
    private final ReadOnlyDoubleWrapper centerX;
    @NotNull
    private final ReadOnlyDoubleWrapper centerY;

    @NotNull
    public final ReadOnlyDoubleWrapper getCenterX() {
        return this.centerX;
    }

    @NotNull
    public final ReadOnlyDoubleWrapper getCenterY() {
        return this.centerY;
    }

    public NodeCenter(final @NotNull Node world, final @NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.centerX = new ReadOnlyDoubleWrapper();
        this.centerY = new ReadOnlyDoubleWrapper();
        final Ref.ObjectRef centrableNode = new Ref.ObjectRef();
        centrableNode.element = node instanceof CentrableNode ? (CentrableNode)node : (CentrableNode)null;
        node.boundsInParentProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public final void changed(ObservableValue<? extends Bounds> observableValue, Bounds oldBounds, Bounds newBounds) {
                double nodeCenterY;
                double nodeCenterX;
                double diffx = 0.0;
                double diffy = 0.0;
                for (Parent pNode = node.getParent(); pNode != null && Intrinsics.areEqual((Object)pNode, (Object)world) ^ true; pNode = pNode.getParent()) {
                    diffx += pNode.getLayoutX();
                    diffy += pNode.getLayoutY();
                }
                if ((CentrableNode)centrableNode.element != null) {
                    nodeCenterX = ((CentrableNode)centrableNode.element).getCenterX();
                    nodeCenterY = ((CentrableNode)centrableNode.element).getCenterY();
                } else {
                    Bounds bounds = newBounds;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"newBounds");
                    nodeCenterX = bounds.getMinX() + newBounds.getWidth() / (double)2;
                    nodeCenterY = newBounds.getMinY() + newBounds.getHeight() / (double)2;
                }
                this.getCenterX().set(nodeCenterX + diffx);
                this.getCenterY().set(nodeCenterY + diffy);
            }
        });
    }
}

