/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.GraphViewPane;
import ru.fix.completable.reactor.graph.viewer.GraphViewer;
import ru.fix.completable.reactor.graph.viewer.GraphViewer$WhenMappings;
import ru.fix.completable.reactor.graph.viewer.Shortcut;
import ru.fix.completable.reactor.graph.viewer.ShortcutType;
import ru.fix.completable.reactor.model.CompileTimeGraph;
import ru.fix.completable.reactor.model.Source;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0015\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0013J\u001e\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\b\b\u0002\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006&"}, d2={"Lru/fix/completable/reactor/graph/viewer/GraphViewer;", "", "()V", "actionListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lru/fix/completable/reactor/graph/viewer/GraphViewer$ActionListener;", "graphViewPanes", "", "Lru/fix/completable/reactor/graph/viewer/GraphViewPane;", "<set-?>", "Ljavafx/scene/Scene;", "scene", "getScene", "()Ljavafx/scene/Scene;", "setScene", "(Ljavafx/scene/Scene;)V", "shortcuts", "", "Lru/fix/completable/reactor/graph/viewer/Shortcut;", "Lru/fix/completable/reactor/graph/viewer/ShortcutType;", "viewPaneActionListener", "ru/fix/completable/reactor/graph/viewer/GraphViewer$viewPaneActionListener$1", "Lru/fix/completable/reactor/graph/viewer/GraphViewer$viewPaneActionListener$1;", "addShortcutListener", "", "pane", "getShortcut", "shortcutType", "openGraph", "graphs", "Lru/fix/completable/reactor/model/CompileTimeGraph;", "resetViewer", "", "registerListener", "actionListener", "setShortcut", "shortcut", "ActionListener", "completable-reactor-graph-viewer"})
public final class GraphViewer {
    @NotNull
    private Scene scene;
    private List<GraphViewPane> graphViewPanes = CollectionsKt.emptyList();
    private CopyOnWriteArrayList<ActionListener> actionListeners = new CopyOnWriteArrayList();
    private final viewPaneActionListener.1 viewPaneActionListener = new ActionListener(this){
        final /* synthetic */ GraphViewer this$0;

        public void goToSource(@NotNull Source source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            for (ActionListener listener : GraphViewer.access$getActionListeners$p(this.this$0)) {
                listener.goToSource(source);
            }
        }

        public void goToSubgraph(@NotNull String subgraphPayloadClass) {
            Intrinsics.checkParameterIsNotNull((Object)subgraphPayloadClass, (String)"subgraphPayloadClass");
            for (ActionListener listener : GraphViewer.access$getActionListeners$p(this.this$0)) {
                listener.goToSubgraph(subgraphPayloadClass);
            }
        }

        public void coordinatesChanged(@NotNull CompileTimeGraph graphModel) {
            Intrinsics.checkParameterIsNotNull((Object)graphModel, (String)"graphModel");
            for (ActionListener listener : GraphViewer.access$getActionListeners$p(this.this$0)) {
                listener.coordinatesChanged(graphModel);
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    private final Map<Shortcut, ShortcutType> shortcuts = new ConcurrentHashMap();

    @NotNull
    public final Scene getScene() {
        return this.scene;
    }

    private final void setScene(Scene scene) {
        this.scene = scene;
    }

    public final void openGraph(@NotNull List<CompileTimeGraph> graphs, boolean resetViewer) {
        Intrinsics.checkParameterIsNotNull(graphs, (String)"graphs");
        if (graphs.isEmpty()) {
            return;
        }
        if (graphs.size() == 1) {
            if (resetViewer || this.graphViewPanes.isEmpty()) {
                GraphViewPane graphViewPane2;
                GraphViewPane $receiver = graphViewPane2 = new GraphViewPane(this.viewPaneActionListener, (Function1<? super ShortcutType, Shortcut>)((Function1)new Function1<ShortcutType, Shortcut>(this){
                    final /* synthetic */ GraphViewer this$0;

                    @Nullable
                    public final Shortcut invoke(@NotNull ShortcutType it) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return this.this$0.getShortcut(it);
                    }
                    {
                        this.this$0 = graphViewer;
                        super(1);
                    }
                }));
                $receiver.setPrefSize(700.0, 600.0);
                this.addShortcutListener($receiver);
                GraphViewPane viewer2 = graphViewPane2;
                this.graphViewPanes = CollectionsKt.listOf((Object)((Object)viewer2));
                this.scene.setRoot((Parent)viewer2);
            }
            ((GraphViewPane)((Object)CollectionsKt.first(this.graphViewPanes))).openGraph(graphs.get(0), resetViewer);
        } else {
            TabPane tabPane;
            Parent parent = this.scene.getRoot();
            Parent it = parent;
            Parent parent2 = it;
            if (!(parent2 instanceof TabPane)) {
                parent2 = null;
            }
            Integer previouslySelectedTabIndex = (tabPane = (TabPane)parent2) != null && (tabPane = tabPane.getSelectionModel()) != null ? Integer.valueOf(tabPane.getSelectedIndex()) : null;
            TabPane tabPane2 = new TabPane();
            tabPane2.setPrefSize(700.0, 600.0);
            this.scene.setRoot((Parent)tabPane2);
            for (CompileTimeGraph graph : graphs) {
                Tab tab;
                GraphViewPane graphViewPane3 = new GraphViewPane(this.viewPaneActionListener, (Function1<? super ShortcutType, Shortcut>)((Function1)new Function1<ShortcutType, Shortcut>(this){
                    final /* synthetic */ GraphViewer this$0;

                    @Nullable
                    public final Shortcut invoke(@NotNull ShortcutType it) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return this.this$0.getShortcut(it);
                    }
                    {
                        this.this$0 = graphViewer;
                        super(1);
                    }
                }));
                Tab $receiver = tab = new Tab();
                $receiver.setText(graph.getGraphClass() + '<' + graph.getStartPoint().getPayloadType() + '>');
                $receiver.setContent((Node)graphViewPane3);
                Tab tab2 = tab;
                tabPane2.getTabs().add((Object)tab2);
                graphViewPane3.openGraph(graph, resetViewer);
                this.addShortcutListener(graphViewPane3);
            }
            if (previouslySelectedTabIndex != null && previouslySelectedTabIndex < tabPane2.getTabs().size()) {
                tabPane2.getSelectionModel().select(previouslySelectedTabIndex.intValue());
            }
        }
    }

    public static /* synthetic */ void openGraph$default(GraphViewer graphViewer, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        graphViewer.openGraph(list, bl);
    }

    private final void addShortcutListener(GraphViewPane pane) {
        pane.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(this, pane){
            final /* synthetic */ GraphViewer this$0;
            final /* synthetic */ GraphViewPane $pane;

            public final void handle(KeyEvent keyEvent) {
                GraphViewer.access$getShortcuts$p(this.this$0).forEach((BiConsumer)new BiConsumer<Shortcut, ShortcutType>(this, keyEvent){
                    final /* synthetic */ addShortcutListener.1 this$0;
                    final /* synthetic */ KeyEvent $keyEvent;

                    public final void accept(@NotNull Shortcut shortcut, @NotNull ShortcutType shortcutType) {
                        Intrinsics.checkParameterIsNotNull((Object)shortcut, (String)"shortcut");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)shortcutType), (String)"shortcutType");
                        if (shortcut.getPredicate().test(this.$keyEvent)) {
                            switch (GraphViewer$WhenMappings.$EnumSwitchMapping$0[shortcutType.ordinal()]) {
                                case 1: {
                                    CompileTimeGraph compileTimeGraph;
                                    CompileTimeGraph compileTimeGraph2 = this.this$0.$pane.getGraphModel();
                                    if (compileTimeGraph2 == null || (compileTimeGraph2 = compileTimeGraph2.getStartPoint()) == null || (compileTimeGraph2 = compileTimeGraph2.getSource()) == null) break;
                                    CompileTimeGraph it = compileTimeGraph = compileTimeGraph2;
                                    GraphViewer.access$getViewPaneActionListener$p(this.this$0.this$0).goToSource((Source)it);
                                    break;
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$keyEvent = keyEvent;
                    }
                });
            }
            {
                this.this$0 = graphViewer;
                this.$pane = graphViewPane2;
            }
        });
    }

    @NotNull
    public final GraphViewer registerListener(@NotNull ActionListener actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        this.actionListeners.add(actionListener);
        return this;
    }

    public final void setShortcut(@NotNull ShortcutType shortcutType, @NotNull Shortcut shortcut) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shortcutType), (String)"shortcutType");
        Intrinsics.checkParameterIsNotNull((Object)shortcut, (String)"shortcut");
        Map<Shortcut, ShortcutType> map = this.shortcuts;
        ShortcutType shortcutType2 = shortcutType;
        map.put(shortcut, shortcutType2);
    }

    @Nullable
    public final Shortcut getShortcut(@NotNull ShortcutType shortcutType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shortcutType), (String)"shortcutType");
        Map<Shortcut, ShortcutType> map = this.shortcuts;
        Iterator<Map.Entry<Shortcut, ShortcutType>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Shortcut, ShortcutType> entry;
            Map.Entry<Shortcut, ShortcutType> entry2 = entry = iterator.next();
            Shortcut shortcut = entry2.getKey();
            entry2 = entry;
            ShortcutType type = entry2.getValue();
            if (type != shortcutType) continue;
            return shortcut;
        }
        return null;
    }

    public GraphViewer() {
        this.scene = new Scene((Parent)new Pane());
        this.scene.getStylesheets().add((Object)this.getClass().getResource("/css/styles.css").toExternalForm());
    }

    @NotNull
    public static final /* synthetic */ Map access$getShortcuts$p(GraphViewer $this) {
        return $this.shortcuts;
    }

    @NotNull
    public static final /* synthetic */ viewPaneActionListener.1 access$getViewPaneActionListener$p(GraphViewer $this) {
        return $this.viewPaneActionListener;
    }

    @NotNull
    public static final /* synthetic */ CopyOnWriteArrayList access$getActionListeners$p(GraphViewer $this) {
        return $this.actionListeners;
    }

    public static final /* synthetic */ void access$setActionListeners$p(GraphViewer $this, @NotNull CopyOnWriteArrayList copyOnWriteArrayList) {
        $this.actionListeners = copyOnWriteArrayList;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lru/fix/completable/reactor/graph/viewer/GraphViewer$ActionListener;", "", "coordinatesChanged", "", "graphModel", "Lru/fix/completable/reactor/model/CompileTimeGraph;", "goToSource", "source", "Lru/fix/completable/reactor/model/Source;", "goToSubgraph", "subgraphPayloadType", "", "completable-reactor-graph-viewer"})
    public static interface ActionListener {
        public void goToSource(@NotNull Source var1);

        public void goToSubgraph(@NotNull String var1);

        public void coordinatesChanged(@NotNull CompileTimeGraph var1);
    }
}

