/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer;

import java.util.ArrayList;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.AutoLayoutable;
import ru.fix.completable.reactor.model.CompileTimeGraphKt;
import ru.fix.completable.reactor.model.Coordinates;
import ru.fix.completable.reactor.model.Figure;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u0013j\b\u0012\u0004\u0012\u00020\u0000`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR$\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010#R$\u0010$\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u001c\"\u0004\b&\u0010#\u00a8\u0006'"}, d2={"Lru/fix/completable/reactor/graph/viewer/GraphNode;", "Ljavafx/scene/layout/VBox;", "Lru/fix/completable/reactor/graph/viewer/AutoLayoutable;", "figure", "Lru/fix/completable/reactor/model/Figure;", "(Lru/fix/completable/reactor/model/Figure;)V", "autoLayoutX", "", "getAutoLayoutX", "()Ljava/lang/Integer;", "setAutoLayoutX", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "autoLayoutY", "getAutoLayoutY", "setAutoLayoutY", "getFigure", "()Lru/fix/completable/reactor/model/Figure;", "graphChildren", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getGraphChildren", "()Ljava/util/ArrayList;", "isUserDefinedCoordinates", "", "()Z", "nodeHeight", "getNodeHeight", "()I", "nodeWidth", "getNodeWidth", "value", "nodeX", "getNodeX", "setNodeX", "(I)V", "nodeY", "getNodeY", "setNodeY", "completable-reactor-graph-viewer"})
public class GraphNode
extends VBox
implements AutoLayoutable {
    @NotNull
    private final ArrayList<GraphNode> graphChildren;
    @Nullable
    private Integer autoLayoutX;
    @Nullable
    private Integer autoLayoutY;
    @NotNull
    private final Figure figure;

    @NotNull
    public ArrayList<GraphNode> getGraphChildren() {
        return this.graphChildren;
    }

    @Nullable
    public final Integer getAutoLayoutX() {
        return this.autoLayoutX;
    }

    public final void setAutoLayoutX(@Nullable Integer n) {
        this.autoLayoutX = n;
    }

    @Nullable
    public final Integer getAutoLayoutY() {
        return this.autoLayoutY;
    }

    public final void setAutoLayoutY(@Nullable Integer n) {
        this.autoLayoutY = n;
    }

    @Override
    public int getNodeX() {
        int n;
        if (this.isUserDefinedCoordinates()) {
            Coordinates coordinates = this.getFigure().getCoordinates();
            if (coordinates == null) {
                coordinates = CompileTimeGraphKt.getDEFAULT_COORDINATES();
            }
            n = coordinates.getX();
        } else {
            Integer n2 = this.autoLayoutX;
            n = n2 != null ? n2.intValue() : CompileTimeGraphKt.getDEFAULT_COORDINATES().getX();
        }
        return n;
    }

    @Override
    public void setNodeX(int value) {
        if (this.isUserDefinedCoordinates()) {
            throw (Throwable)new IllegalStateException("Auto layout tries to override user defined coordinates");
        }
        this.autoLayoutX = value;
    }

    @Override
    public int getNodeY() {
        int n;
        if (this.isUserDefinedCoordinates()) {
            Coordinates coordinates = this.getFigure().getCoordinates();
            if (coordinates == null) {
                coordinates = CompileTimeGraphKt.getDEFAULT_COORDINATES();
            }
            n = coordinates.getY();
        } else {
            Integer n2 = this.autoLayoutY;
            n = n2 != null ? n2.intValue() : CompileTimeGraphKt.getDEFAULT_COORDINATES().getY();
        }
        return n;
    }

    @Override
    public void setNodeY(int value) {
        if (this.isUserDefinedCoordinates()) {
            throw (Throwable)new IllegalStateException("Auto layout tries to override user defined coordinates");
        }
        this.autoLayoutY = value;
    }

    @Override
    public boolean isUserDefinedCoordinates() {
        return this.getFigure().getCoordinates() != null;
    }

    @Override
    public int getNodeHeight() {
        return (int)super.getHeight();
    }

    @Override
    public int getNodeWidth() {
        return (int)super.getWidth();
    }

    @Override
    @NotNull
    public Figure getFigure() {
        return this.figure;
    }

    public GraphNode(@NotNull Figure figure) {
        Intrinsics.checkParameterIsNotNull((Object)figure, (String)"figure");
        this.figure = figure;
        this.graphChildren = new ArrayList();
    }

    @Override
    public int nodeCenterX() {
        return AutoLayoutable.DefaultImpls.nodeCenterX(this);
    }

    @Override
    public int nodeCenterY() {
        return AutoLayoutable.DefaultImpls.nodeCenterY(this);
    }
}

