/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer.gl.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.viewer.gl.code.CodeUpdater;
import ru.fix.completable.reactor.graph.viewer.gl.code.CoordinateCodePhrase;
import ru.fix.completable.reactor.model.Coordinates;
import ru.fix.completable.reactor.model.EndPoint;
import ru.fix.completable.reactor.model.GraphModel;
import ru.fix.completable.reactor.model.Handler;
import ru.fix.completable.reactor.model.Merger;
import ru.fix.completable.reactor.model.Router;
import ru.fix.completable.reactor.model.Source;
import ru.fix.completable.reactor.model.Subgraph;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J#\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\u0012J\u0016\u0010\u0010\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater;", "", "codeType", "Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$CodeType;", "(Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$CodeType;)V", "coordinateCodePhraseFromModel", "", "Lru/fix/completable/reactor/graph/viewer/gl/code/CoordinateCodePhrase;", "graphModel", "Lru/fix/completable/reactor/model/GraphModel;", "generateCoordinateBuilderMemberCode", "", "phrase", "printCoordinates", "coordinates", "padding", "updateCoordinates", "codeBlock", "updateCoordinates$completable_reactor_graph_viewer", "", "editor", "Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$Editor;", "CodeType", "Companion", "Editor", "completable-reactor-graph-viewer"})
public final class CodeUpdater {
    private final CodeType codeType;
    private static final Map<KClass<? extends CoordinateCodePhrase>, Integer> coordinateTypeOrder;
    public static final Companion Companion;

    private final List<CoordinateCodePhrase> coordinateCodePhraseFromModel(GraphModel graphModel) {
        Coordinates mergerCoordinates;
        ArrayList<CoordinateCodePhrase> result = new ArrayList<CoordinateCodePhrase>();
        GraphModel $receiver = graphModel;
        Coordinates coordinates = $receiver.getStartPoint().getCoordinates();
        if (coordinates != null) {
            Coordinates coordinates2;
            Coordinates $receiver2 = coordinates2 = coordinates;
            result.add(new CoordinateCodePhrase.StartPointPhrase($receiver2.getX(), $receiver2.getY()));
        }
        Collection collection = $receiver.getHandlers().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"handlers.values");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            Handler handler = (Handler)element$iv;
            Coordinates handlerCoordinates = handler.getCoordinates();
            Merger merger = (Merger)$receiver.getMergers().get(handler.getName());
            Object object = mergerCoordinates = merger != null ? merger.getCoordinates() : null;
            if (handlerCoordinates == null) continue;
            if (mergerCoordinates != null) {
                result.add(new CoordinateCodePhrase.ComplexVertexPhrase(handler.getName(), handlerCoordinates.getX(), handlerCoordinates.getY(), mergerCoordinates.getX(), mergerCoordinates.getY()));
                continue;
            }
            result.add(new CoordinateCodePhrase.PlainVertexPhrase(handler.getName(), handlerCoordinates.getX(), handlerCoordinates.getY()));
        }
        Collection collection2 = $receiver.getSubgraphs().values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"subgraphs.values");
        $receiver$iv = collection2;
        for (Object element$iv : $receiver$iv) {
            Subgraph subgraph = (Subgraph)element$iv;
            Coordinates subgraphCoordinates = subgraph.getCoordinates();
            Merger merger = (Merger)$receiver.getMergers().get(subgraph.getName());
            Object object = mergerCoordinates = merger != null ? merger.getCoordinates() : null;
            if (subgraphCoordinates == null) continue;
            if (mergerCoordinates != null) {
                result.add(new CoordinateCodePhrase.ComplexVertexPhrase(subgraph.getName(), subgraphCoordinates.getX(), subgraphCoordinates.getY(), mergerCoordinates.getX(), mergerCoordinates.getY()));
                continue;
            }
            result.add(new CoordinateCodePhrase.PlainVertexPhrase(subgraph.getName(), subgraphCoordinates.getX(), subgraphCoordinates.getY()));
        }
        Collection collection3 = $receiver.getRouters().values();
        Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"routers.values");
        $receiver$iv = collection3;
        for (Object element$iv : $receiver$iv) {
            Router router = (Router)element$iv;
            Coordinates routerCoordinates = router.getCoordinates();
            if (routerCoordinates == null) continue;
            result.add(new CoordinateCodePhrase.PlainVertexPhrase(router.getName(), routerCoordinates.getX(), routerCoordinates.getY()));
        }
        Collection collection4 = $receiver.getEndpoints().values();
        Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"endpoints.values");
        $receiver$iv = collection4;
        for (Object element$iv : $receiver$iv) {
            Coordinates coordinates3;
            EndPoint endpoint = (EndPoint)element$iv;
            if (endpoint.getCoordinates() == null) continue;
            Coordinates $receiver3 = coordinates3;
            result.add(new CoordinateCodePhrase.EndPointPhrase(endpoint.getName(), $receiver3.getX(), $receiver3.getY()));
        }
        return result;
    }

    private final String printCoordinates(List<? extends CoordinateCodePhrase> coordinates, String padding) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)coordinates), (Comparator)printCoordinates.1.INSTANCE), (CharSequence)('\n' + padding), (CharSequence)("coordinates()\n" + padding), (CharSequence)(this.codeType == CodeType.JAVA ? ";" : ""), (int)0, null, (Function1)((Function1)new Function1<CoordinateCodePhrase, String>(this){
            final /* synthetic */ CodeUpdater this$0;

            @NotNull
            public final String invoke(@NotNull CoordinateCodePhrase item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return CodeUpdater.access$generateCoordinateBuilderMemberCode(this.this$0, item);
            }
            {
                this.this$0 = codeUpdater;
                super(1);
            }
        }), (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String updateCoordinates$completable_reactor_graph_viewer(@NotNull String codeBlock, @NotNull List<? extends CoordinateCodePhrase> coordinates) {
        int n;
        int n2;
        String string;
        block3: {
            String it;
            Intrinsics.checkParameterIsNotNull((Object)codeBlock, (String)"codeBlock");
            Intrinsics.checkParameterIsNotNull(coordinates, (String)"coordinates");
            Object object = SequencesKt.last((Sequence)StringsKt.lineSequence((CharSequence)codeBlock));
            string = it = (String)object;
            n2 = 0;
            CharSequence $receiver$iv = it;
            int n3 = 0;
            int n4 = $receiver$iv.length();
            while (n3 < n4) {
                void index$iv;
                char it2 = $receiver$iv.charAt((int)index$iv);
                if (!CharsKt.isWhitespace((char)it2)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n5 = n;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n2, n5);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String padding = string3;
        return this.printCoordinates(coordinates, padding);
    }

    private final String generateCoordinateBuilderMemberCode(CoordinateCodePhrase phrase) {
        String string;
        CoordinateCodePhrase coordinateCodePhrase = phrase;
        if (coordinateCodePhrase instanceof CoordinateCodePhrase.StartPointPhrase) {
            string = ".pd(" + ((CoordinateCodePhrase.StartPointPhrase)phrase).getX() + ", " + ((CoordinateCodePhrase.StartPointPhrase)phrase).getY() + ')';
        } else if (coordinateCodePhrase instanceof CoordinateCodePhrase.PlainVertexPhrase) {
            string = ".vx(" + ((CoordinateCodePhrase.PlainVertexPhrase)phrase).getName() + ", " + ((CoordinateCodePhrase.PlainVertexPhrase)phrase).getX() + ", " + ((CoordinateCodePhrase.PlainVertexPhrase)phrase).getY() + ')';
        } else if (coordinateCodePhrase instanceof CoordinateCodePhrase.ComplexVertexPhrase) {
            string = ".vx(" + ((CoordinateCodePhrase.ComplexVertexPhrase)phrase).getName() + ", " + ((CoordinateCodePhrase.ComplexVertexPhrase)phrase).getX() + ", " + ((CoordinateCodePhrase.ComplexVertexPhrase)phrase).getY() + ", " + ((CoordinateCodePhrase.ComplexVertexPhrase)phrase).getX2() + ", " + ((CoordinateCodePhrase.ComplexVertexPhrase)phrase).getY2() + ')';
        } else if (coordinateCodePhrase instanceof CoordinateCodePhrase.EndPointPhrase) {
            string = ".ct(" + ((CoordinateCodePhrase.EndPointPhrase)phrase).getName() + ", " + ((CoordinateCodePhrase.EndPointPhrase)phrase).getX() + ", " + ((CoordinateCodePhrase.EndPointPhrase)phrase).getY() + ')';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCoordinates(@NotNull GraphModel graphModel, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)graphModel, (String)"graphModel");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        List<CoordinateCodePhrase> coordinates = this.coordinateCodePhraseFromModel(graphModel);
        Source start = graphModel.getCoordinatesStart();
        Source end = graphModel.getCoordinatesEnd();
        if (start != null && end != null) {
            Source source = graphModel.getCoordinatesStart();
            if (source == null) {
                Intrinsics.throwNpe();
            }
            Source source2 = graphModel.getCoordinatesEnd();
            if (source2 == null) {
                Intrinsics.throwNpe();
            }
            String codeBlock = editor.getCodeBlock(source, source2);
            String newCodeBlock = this.updateCoordinates$completable_reactor_graph_viewer(codeBlock, coordinates);
            editor.replaceCodeBlock(start, end, newCodeBlock);
        } else {
            Source endOfBlock = graphModel.getEndOfLastCodeBlocksWithinGraph();
            if (endOfBlock != null) {
                int n;
                int n2;
                String string;
                block8: {
                    String string2;
                    String it;
                    Source startOfLine = new Source(endOfBlock.getFilePath(), endOfBlock.getLine(), 1, endOfBlock.getOffset() - endOfBlock.getColumn() + 1);
                    string = it = (string2 = editor.getCodeBlock(startOfLine, endOfBlock));
                    n2 = 0;
                    CharSequence $receiver$iv = it;
                    int n3 = 0;
                    int n4 = $receiver$iv.length();
                    while (n3 < n4) {
                        void index$iv;
                        char it2 = $receiver$iv.charAt((int)index$iv);
                        if (!CharsKt.isWhitespace((char)it2)) {
                            n = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int n5 = n;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2, n5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String padding = string4;
                editor.insert(endOfBlock, "\n\n" + padding + this.printCoordinates(coordinates, padding + "    "));
            }
        }
    }

    public CodeUpdater(@NotNull CodeType codeType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)codeType), (String)"codeType");
        this.codeType = codeType;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Companion = new Companion(null);
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(CoordinateCodePhrase.StartPointPhrase.class), Reflection.getOrCreateKotlinClass(CoordinateCodePhrase.PlainVertexPhrase.class), Reflection.getOrCreateKotlinClass(CoordinateCodePhrase.ComplexVertexPhrase.class), Reflection.getOrCreateKotlinClass(CoordinateCodePhrase.EndPointPhrase.class)});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index;
            void type;
            int n = index$iv$iv++;
            KClass kClass = (KClass)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            Pair pair = new Pair((Object)type, (Object)((int)index));
            collection.add(pair);
        }
        coordinateTypeOrder = MapsKt.toMap((Iterable)((List)var2_2));
    }

    @NotNull
    public static final /* synthetic */ Map access$getCoordinateTypeOrder$cp() {
        return coordinateTypeOrder;
    }

    @NotNull
    public static final /* synthetic */ String access$generateCoordinateBuilderMemberCode(CodeUpdater $this, @NotNull CoordinateCodePhrase phrase) {
        return $this.generateCoordinateBuilderMemberCode(phrase);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$CodeType;", "", "(Ljava/lang/String;I)V", "JAVA", "KOTLIN", "completable-reactor-graph-viewer"})
    public static final class CodeType
    extends Enum<CodeType> {
        public static final /* enum */ CodeType JAVA;
        public static final /* enum */ CodeType KOTLIN;
        private static final /* synthetic */ CodeType[] $VALUES;

        static {
            CodeType[] codeTypeArray = new CodeType[2];
            CodeType[] codeTypeArray2 = codeTypeArray;
            codeTypeArray[0] = JAVA = new CodeType();
            codeTypeArray[1] = KOTLIN = new CodeType();
            $VALUES = codeTypeArray;
        }

        public static CodeType[] values() {
            return (CodeType[])$VALUES.clone();
        }

        public static CodeType valueOf(String string) {
            return Enum.valueOf(CodeType.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H&J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u000e"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$Editor;", "", "getCodeBlock", "", "coordinatesStart", "Lru/fix/completable/reactor/model/Source;", "coordinatesEnd", "insert", "", "position", "newCodeBlock", "replaceCodeBlock", "start", "end", "completable-reactor-graph-viewer"})
    public static interface Editor {
        @NotNull
        public String getCodeBlock(@NotNull Source var1, @NotNull Source var2);

        public void replaceCodeBlock(@NotNull Source var1, @NotNull Source var2, @NotNull String var3);

        public void insert(@NotNull Source var1, @NotNull String var2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/code/CodeUpdater$Companion;", "", "()V", "coordinateTypeOrder", "", "Lkotlin/reflect/KClass;", "Lru/fix/completable/reactor/graph/viewer/gl/code/CoordinateCodePhrase;", "", "completable-reactor-graph-viewer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

