/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer.gl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.viewer.gl.CoordinateTranslator;
import ru.fix.completable.reactor.graph.viewer.gl.GraphNode;
import ru.fix.completable.reactor.graph.viewer.gl.NodeDraggerListener;
import ru.fix.completable.reactor.model.Coordinates;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/NodeDragger;", "", "node", "Lru/fix/completable/reactor/graph/viewer/gl/GraphNode;", "draggerListener", "Lru/fix/completable/reactor/graph/viewer/gl/NodeDraggerListener;", "translator", "Lru/fix/completable/reactor/graph/viewer/gl/CoordinateTranslator;", "(Lru/fix/completable/reactor/graph/viewer/gl/GraphNode;Lru/fix/completable/reactor/graph/viewer/gl/NodeDraggerListener;Lru/fix/completable/reactor/graph/viewer/gl/CoordinateTranslator;)V", "getDraggerListener", "()Lru/fix/completable/reactor/graph/viewer/gl/NodeDraggerListener;", "getNode", "()Lru/fix/completable/reactor/graph/viewer/gl/GraphNode;", "getTranslator", "()Lru/fix/completable/reactor/graph/viewer/gl/CoordinateTranslator;", "fireModelChanged", "", "fireModelChanging", "Companion", "completable-reactor-graph-viewer"})
public final class NodeDragger {
    @NotNull
    private final GraphNode node;
    @NotNull
    private final NodeDraggerListener draggerListener;
    @NotNull
    private final CoordinateTranslator translator;
    public static final Companion Companion = new Companion(null);

    private final void fireModelChanged() {
        this.draggerListener.modelChanged();
    }

    private final void fireModelChanging() {
        this.draggerListener.modelChanging();
    }

    @NotNull
    public final GraphNode getNode() {
        return this.node;
    }

    @NotNull
    public final NodeDraggerListener getDraggerListener() {
        return this.draggerListener;
    }

    @NotNull
    public final CoordinateTranslator getTranslator() {
        return this.translator;
    }

    private NodeDragger(GraphNode node, NodeDraggerListener draggerListener, CoordinateTranslator translator) {
        this.node = node;
        this.draggerListener = draggerListener;
        this.translator = translator;
        final AtomicBoolean draggingState = new AtomicBoolean();
        final AtomicReference startDragMousePoint = new AtomicReference();
        final AtomicReference startDragNodePosition = new AtomicReference();
        this.node.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent event) {
                if (event.isControlDown()) {
                    this.getNode().setCursor(Cursor.OPEN_HAND);
                } else {
                    this.getNode().setCursor(Cursor.DEFAULT);
                }
            }
        });
        this.node.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent event) {
                if (event.isControlDown()) {
                    this.getNode().setCursor(Cursor.CLOSED_HAND);
                    draggingState.set(true);
                    MouseEvent mouseEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                    startDragMousePoint.set(new Point2D(mouseEvent.getSceneX(), event.getSceneY()));
                    startDragNodePosition.set(new Point2D(this.getNode().getLayoutX(), this.getNode().getLayoutY()));
                } else {
                    this.getNode().setCursor(Cursor.DEFAULT);
                    if (draggingState.compareAndSet(true, false)) {
                        this.fireModelChanged();
                    }
                }
            }
        });
        this.node.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent event) {
                MouseEvent mouseEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                if (mouseEvent.isControlDown()) {
                    if (draggingState.compareAndSet(true, false)) {
                        this.fireModelChanged();
                    }
                    this.getNode().setCursor(Cursor.OPEN_HAND);
                } else {
                    if (draggingState.compareAndSet(true, false)) {
                        this.fireModelChanged();
                    }
                    this.getNode().setCursor(Cursor.DEFAULT);
                }
            }
        });
        this.node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent event) {
                MouseEvent mouseEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                if (mouseEvent.isControlDown()) {
                    if (draggingState.get()) {
                        event.consume();
                        Point2D nodePosition = (Point2D)startDragNodePosition.get();
                        Point2D mousePosition = (Point2D)startDragMousePoint.get();
                        if (nodePosition == null || mousePosition == null) {
                            return;
                        }
                        int newCoordinateX = this.getTranslator().paneLayoutToModelX(nodePosition.getX() + event.getSceneX() - mousePosition.getX());
                        int newCoordinateY = this.getTranslator().paneLayoutToModelY(nodePosition.getY() + event.getSceneY() - mousePosition.getY());
                        this.getNode().getFigure().setCoordinates(new Coordinates(newCoordinateX, newCoordinateY));
                        this.fireModelChanging();
                    } else {
                        draggingState.set(true);
                        this.getNode().setCursor(Cursor.CLOSED_HAND);
                    }
                } else {
                    if (draggingState.compareAndSet(true, false)) {
                        this.fireModelChanged();
                    }
                    this.getNode().setCursor(Cursor.DEFAULT);
                }
            }
        });
        this.node.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent event) {
                MouseEvent mouseEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                if (mouseEvent.isControlDown()) {
                    this.getNode().setCursor(Cursor.OPEN_HAND);
                } else {
                    this.getNode().setCursor(Cursor.DEFAULT);
                }
            }
        });
    }

    public /* synthetic */ NodeDragger(@NotNull GraphNode node, @NotNull NodeDraggerListener draggerListener, @NotNull CoordinateTranslator translator, DefaultConstructorMarker $constructor_marker) {
        this(node, draggerListener, translator);
    }

    @JvmStatic
    public static final void attach(@NotNull GraphNode node, @NotNull NodeDraggerListener draggerListener, @NotNull CoordinateTranslator translator) {
        Companion.attach(node, draggerListener, translator);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/NodeDragger$Companion;", "", "()V", "attach", "", "node", "Lru/fix/completable/reactor/graph/viewer/gl/GraphNode;", "draggerListener", "Lru/fix/completable/reactor/graph/viewer/gl/NodeDraggerListener;", "translator", "Lru/fix/completable/reactor/graph/viewer/gl/CoordinateTranslator;", "completable-reactor-graph-viewer"})
    public static final class Companion {
        @JvmStatic
        public final void attach(@NotNull GraphNode node, @NotNull NodeDraggerListener draggerListener, @NotNull CoordinateTranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)draggerListener, (String)"draggerListener");
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            new NodeDragger(node, draggerListener, translator, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

