/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer.gl;

import java.util.Iterator;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.gl.AutoLayout;
import ru.fix.completable.reactor.graph.viewer.gl.GraphNode;
import ru.fix.completable.reactor.graph.viewer.gl.GraphPane;
import ru.fix.completable.reactor.graph.viewer.gl.Rect;
import ru.fix.completable.reactor.graph.viewer.gl.StartPointNode;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0014\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/GraphPane;", "Ljavafx/scene/layout/Pane;", "()V", "GRAPH_PANE_MIN_BORDER_SIZE", "", "afterResizeCallback", "Lkotlin/Function0;", "", "autoLayout", "Lru/fix/completable/reactor/graph/viewer/gl/AutoLayout;", "graphBordersInModelCoordinates", "Lru/fix/completable/reactor/graph/viewer/gl/Rect;", "getGraphBordersInModelCoordinates", "()Lru/fix/completable/reactor/graph/viewer/gl/Rect;", "setGraphBordersInModelCoordinates", "(Lru/fix/completable/reactor/graph/viewer/gl/Rect;)V", "resizeRequested", "", "layoutChildren", "nodes", "Lkotlin/sequences/Sequence;", "Lru/fix/completable/reactor/graph/viewer/gl/GraphNode;", "requestResize", "afterResize", "startPoint", "Lru/fix/completable/reactor/graph/viewer/gl/StartPointNode;", "updatePaneSizeIfRequired", "completable-reactor-graph-viewer"})
public final class GraphPane
extends Pane {
    private final AutoLayout autoLayout = new AutoLayout();
    @NotNull
    private Rect graphBordersInModelCoordinates = new Rect(0, 0, 0, 0);
    private boolean resizeRequested;
    private Function0<Unit> afterResizeCallback;
    private final int GRAPH_PANE_MIN_BORDER_SIZE = 2048;

    @NotNull
    public final Rect getGraphBordersInModelCoordinates() {
        return this.graphBordersInModelCoordinates;
    }

    public final void setGraphBordersInModelCoordinates(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.graphBordersInModelCoordinates = rect;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        StartPointNode startPointNode = this.startPoint();
        if (startPointNode != null) {
            StartPointNode startPointNode2;
            StartPointNode it = startPointNode2 = startPointNode;
            this.autoLayout.layout(it);
        }
        this.updatePaneSizeIfRequired();
        Function1<Integer, Integer> calcX$ = new Function1<Integer, Integer>(this){
            final /* synthetic */ GraphPane this$0;

            public final int invoke(int x) {
                return x - this.this$0.getGraphBordersInModelCoordinates().getMinX();
            }
            {
                this.this$0 = graphPane;
                super(1);
            }
        };
        Function1<Integer, Integer> calcY$ = new Function1<Integer, Integer>(this){
            final /* synthetic */ GraphPane this$0;

            public final int invoke(int y) {
                return y - this.this$0.getGraphBordersInModelCoordinates().getMinY();
            }
            {
                this.this$0 = graphPane;
                super(1);
            }
        };
        Sequence<GraphNode> $receiver$iv = this.nodes();
        for (Object element$iv : $receiver$iv) {
            GraphNode node = (GraphNode)element$iv;
            node.setLayoutX(calcX$.invoke(node.getNodeX()));
            node.setLayoutY(calcY$.invoke(node.getNodeY()));
        }
    }

    @NotNull
    public final Sequence<GraphNode> nodes() {
        ObservableList observableList = this.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"children");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)observableList)), (Function1)nodes.1.INSTANCE);
    }

    @Nullable
    public final StartPointNode startPoint() {
        ObservableList observableList = this.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"children");
        return (StartPointNode)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)observableList)), (Function1)startPoint.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePaneSizeIfRequired() {
        if (!this.resizeRequested) {
            return;
        }
        this.resizeRequested = false;
        Object $receiver$iv = SequencesKt.map(this.nodes(), (Function1)updatePaneSizeIfRequired.graphBorders.1.INSTANCE);
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void rect;
            Rect rect2 = (Rect)iterator$iv.next();
            Rect acc = (Rect)accumulator$iv;
            accumulator$iv = new Rect(Math.min(acc.getMinX(), rect.getMinX()), Math.min(acc.getMinY(), rect.getMinY()), Math.max(acc.getMaxX(), rect.getMaxX()), Math.max(acc.getMaxY(), rect.getMaxY()));
        }
        $receiver$iv = accumulator$iv;
        Rect it = (Rect)$receiver$iv;
        int resizeWidth = it.getWidth() * 2 < this.GRAPH_PANE_MIN_BORDER_SIZE ? this.GRAPH_PANE_MIN_BORDER_SIZE - it.getWidth() : it.getWidth();
        int resizeHeight = it.getHeight() * 2 < this.GRAPH_PANE_MIN_BORDER_SIZE ? this.GRAPH_PANE_MIN_BORDER_SIZE - it.getHeight() : it.getHeight();
        Rect graphBorders2 = new Rect(it.getMinX() - resizeWidth / 2, it.getMinY() - resizeHeight / 2, it.getMaxX() + resizeWidth / 2, it.getMaxY() + resizeHeight / 2);
        double targetWidth = graphBorders2.getWidth();
        double targetHeight = graphBorders2.getHeight();
        if (this.getPrefWidth() != targetWidth || this.getPrefHeight() != targetHeight) {
            this.graphBordersInModelCoordinates = graphBorders2;
            this.setPrefWidth(targetWidth);
            this.setPrefHeight(targetHeight);
            Function0<Unit> function0 = this.afterResizeCallback;
            if (function0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"afterResizeCallback");
            }
            function0.invoke();
            Platform.runLater((Runnable)new Runnable(this){
                final /* synthetic */ GraphPane this$0;

                public final void run() {
                    GraphPane.access$requestParentLayout(this.this$0);
                }
                {
                    this.this$0 = graphPane;
                }
            });
        }
    }

    public final void requestResize(@NotNull Function0<Unit> afterResize) {
        Intrinsics.checkParameterIsNotNull(afterResize, (String)"afterResize");
        this.resizeRequested = true;
        this.afterResizeCallback = afterResize;
        this.requestLayout();
    }

    public static final /* synthetic */ void access$requestParentLayout(GraphPane $this) {
        $this.requestParentLayout();
    }
}

