/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer.gl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.gl.BorderableNode;
import ru.fix.completable.reactor.graph.viewer.gl.GraphViewer;
import ru.fix.completable.reactor.graph.viewer.gl.NodeCenter;
import ru.fix.completable.reactor.model.Source;
import ru.fix.completable.reactor.model.Transition;
import ru.fix.completable.reactor.model.TransitionDocumentation;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0007H\u0002J(\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020$J\u0006\u0010)\u001a\u00020 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006*"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/TransitionLine;", "Ljavafx/scene/Group;", "world", "Ljavafx/scene/Node;", "fromNode", "toNode", "transition", "Lru/fix/completable/reactor/model/Transition;", "actionListener", "Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;", "(Ljavafx/scene/Node;Ljavafx/scene/Node;Ljavafx/scene/Node;Lru/fix/completable/reactor/model/Transition;Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;)V", "getActionListener", "()Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;", "fromCenter", "Lru/fix/completable/reactor/graph/viewer/gl/NodeCenter;", "getFromNode", "()Ljavafx/scene/Node;", "labelsPane", "Ljavafx/scene/layout/VBox;", "line", "Ljavafx/scene/shape/Line;", "menuArea", "Ljavafx/scene/shape/Polygon;", "pointer", "toCenter", "getToNode", "getTransition", "()Lru/fix/completable/reactor/model/Transition;", "getWorld", "buildTooltipContent", "Ljavafx/scene/control/ContextMenu;", "initializePopupMenu", "", "initializeTransition", "transitionItem", "intersection2", "Ljavafx/geometry/Point2D;", "firstStart", "firstEnd", "secondStart", "secondEnd", "updateLine", "completable-reactor-graph-viewer"})
public final class TransitionLine
extends Group {
    private final Polygon pointer;
    private final NodeCenter fromCenter;
    private final NodeCenter toCenter;
    private final Line line;
    private final VBox labelsPane;
    private final Polygon menuArea;
    @NotNull
    private final Node world;
    @NotNull
    private final Node fromNode;
    @NotNull
    private final Node toNode;
    @Nullable
    private final Transition transition;
    @NotNull
    private final GraphViewer.ActionListener actionListener;

    private final void initializeTransition(Transition transitionItem) {
        if (transitionItem.isOnAny()) {
            Label anyStatusLabel = new Label("<Any>");
            this.labelsPane.getChildren().add((Object)anyStatusLabel);
            if (transitionItem.getOnAnySource() != null) {
                anyStatusLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(this, transitionItem){
                    final /* synthetic */ TransitionLine this$0;
                    final /* synthetic */ Transition $transitionItem;

                    public final void handle(MouseEvent mouseEvent) {
                        block1: {
                            if (mouseEvent.getClickCount() != 2) break block1;
                            Source source = this.$transitionItem.getOnAnySource();
                            if (source != null) {
                                Source source2;
                                Source it = source2 = source;
                                this.this$0.getActionListener().goToSource(it);
                            }
                        }
                    }
                    {
                        this.this$0 = transitionLine;
                        this.$transitionItem = transition;
                    }
                });
                this.menuArea.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(this, transitionItem){
                    final /* synthetic */ TransitionLine this$0;
                    final /* synthetic */ Transition $transitionItem;

                    public final void handle(MouseEvent mouseEvent) {
                        block1: {
                            if (mouseEvent.getClickCount() != 2) break block1;
                            Source source = this.$transitionItem.getOnAnySource();
                            if (source != null) {
                                Source source2;
                                Source it = source2 = source;
                                this.this$0.getActionListener().goToSource(it);
                            }
                        }
                    }
                    {
                        this.this$0 = transitionLine;
                        this.$transitionItem = transition;
                    }
                });
            }
        } else {
            Set set = transitionItem.getMergeStatuses();
            if (set != null) {
                Iterable $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    String status = (String)element$iv;
                    Label statusLabel = new Label(status);
                    this.labelsPane.getChildren().add((Object)statusLabel);
                    Map map = transitionItem.getOnStatusSource();
                    if (map != null && (map = (Source)map.get(status)) != null) {
                        Map map2;
                        Map source = map2 = map;
                        statusLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>((Source)source, statusLabel, this, transitionItem){
                            final /* synthetic */ Source $source;
                            final /* synthetic */ Label $statusLabel$inlined;
                            final /* synthetic */ TransitionLine this$0;
                            final /* synthetic */ Transition $transitionItem$inlined;
                            {
                                this.$source = source;
                                this.$statusLabel$inlined = label;
                                this.this$0 = transitionLine;
                                this.$transitionItem$inlined = transition;
                            }

                            public final void handle(MouseEvent mouseEvent) {
                                if (mouseEvent.getClickCount() == 2) {
                                    this.this$0.getActionListener().goToSource(this.$source);
                                }
                            }
                        });
                    }
                }
            }
        }
        this.line.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(this){
            final /* synthetic */ TransitionLine this$0;

            public final void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                double x = (newValue.getMinX() + newValue.getMaxX()) / (double)2;
                double y = (newValue.getMinY() + newValue.getMaxY()) / (double)2;
                TransitionLine.access$getLabelsPane$p(this.this$0).setLayoutX(x);
                TransitionLine.access$getLabelsPane$p(this.this$0).setLayoutY(y);
            }
            {
                this.this$0 = transitionLine;
            }
        });
        this.getChildren().add((Object)this.labelsPane);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateLine() {
        double maxy;
        double maxx;
        double miny;
        double minx;
        Point2D from = new Point2D(this.fromCenter.getCenterX().doubleValue(), this.fromCenter.getCenterY().doubleValue());
        Point2D to = new Point2D(this.toCenter.getCenterX().doubleValue(), this.toCenter.getCenterY().doubleValue());
        if (this.toNode instanceof BorderableNode) {
            minx = ((BorderableNode)this.toNode).getBorderableX();
            miny = ((BorderableNode)this.toNode).getBorderableY();
            maxx = ((BorderableNode)this.toNode).getBorderableX() + ((BorderableNode)this.toNode).getBorderableWidth();
            maxy = ((BorderableNode)this.toNode).getBorderableY() + ((BorderableNode)this.toNode).getBorderableHeight();
        } else {
            minx = this.toNode.getLayoutX();
            miny = this.toNode.getLayoutY();
            maxx = this.toNode.getLayoutX() + this.toNode.getLayoutBounds().getWidth();
            maxy = this.toNode.getLayoutY() + this.toNode.getLayoutBounds().getHeight();
        }
        Point2D[][] toNodeBorders = new Point2D[][]{{new Point2D(minx, miny), new Point2D(maxx, miny)}, {new Point2D(minx, miny), new Point2D(minx, maxy)}, {new Point2D(maxx, maxy), new Point2D(maxx, miny)}, {new Point2D(maxx, maxy), new Point2D(minx, maxy)}};
        Point2D toNodeBorderIntersection = new Point2D(this.toCenter.getCenterX().get(), this.toCenter.getCenterY().get());
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            Point2D intersectionPoint = this.intersection2(from, to, toNodeBorders[i][0], toNodeBorders[i][1]);
            if (intersectionPoint != null) {
                toNodeBorderIntersection = intersectionPoint;
                break;
            }
            ++i;
        }
        double x0 = toNodeBorderIntersection.getX();
        double y0 = toNodeBorderIntersection.getY();
        double tan = (to.getX() - from.getX()) / (to.getY() - from.getY());
        double angleRad = Math.atan(tan);
        double angleDeg = Math.toDegrees(angleRad);
        double rotationDeg = ((double)360 - angleDeg) % (double)360;
        if (to.getY() - from.getY() < 0.0) {
            rotationDeg = (rotationDeg + (double)180) % (double)360;
        }
        this.pointer.getTransforms().clear();
        this.pointer.getTransforms().add((Object)new Rotate(rotationDeg, 0.0, 0.0));
        this.pointer.setLayoutX(x0);
        this.pointer.setLayoutY(y0);
        this.line.setStartX(this.fromCenter.getCenterX().get());
        this.line.setStartY(this.fromCenter.getCenterY().get());
        this.line.setEndX(this.toCenter.getCenterX().get());
        this.line.setEndY(this.toCenter.getCenterY().get());
        this.menuArea.getPoints().clear();
        double menuAreaWidth = 30.0;
        double menu_dx = menuAreaWidth / (double)2 * Math.cos(angleRad);
        double menu_dy = menuAreaWidth / (double)2 * Math.sin(angleRad);
        this.menuArea.getPoints().addAll((Object[])new Double[]{this.line.getStartX() + menu_dx, this.line.getStartY() - menu_dy, this.line.getStartX() - menu_dx, this.line.getStartY() + menu_dy, this.line.getEndX() - menu_dx, this.line.getEndY() + menu_dy, this.line.getEndX() + menu_dx, this.line.getEndY() - menu_dy});
    }

    @Nullable
    public final Point2D intersection2(@NotNull Point2D firstStart, @NotNull Point2D firstEnd, @NotNull Point2D secondStart, @NotNull Point2D secondEnd) {
        boolean denomPositive;
        double denom;
        Intrinsics.checkParameterIsNotNull((Object)firstStart, (String)"firstStart");
        Intrinsics.checkParameterIsNotNull((Object)firstEnd, (String)"firstEnd");
        Intrinsics.checkParameterIsNotNull((Object)secondStart, (String)"secondStart");
        Intrinsics.checkParameterIsNotNull((Object)secondEnd, (String)"secondEnd");
        double p0_x = firstStart.getX();
        double p0_y = firstStart.getY();
        double p1_x = firstEnd.getX();
        double p1_y = firstEnd.getY();
        double p2_x = secondStart.getX();
        double p2_y = secondStart.getY();
        double p3_x = secondEnd.getX();
        double p3_y = secondEnd.getY();
        double s10_x = p1_x - p0_x;
        double s10_y = p1_y - p0_y;
        double s32_x = p3_x - p2_x;
        double s32_y = p3_y - p2_y;
        double d = denom = s10_x * s32_y - s32_x * s10_y;
        if (Double.doubleToRawLongBits(d) == 0L) {
            return null;
        }
        double s02_y = p0_y - p2_y;
        double s02_x = p0_x - p2_x;
        double s_numer = s10_x * s02_y - s10_y * s02_x;
        if (s_numer < 0.0 == (denomPositive = denom > 0.0)) {
            return null;
        }
        double t_numer = s32_x * s02_y - s32_y * s02_x;
        if (t_numer < 0.0 == denomPositive) {
            return null;
        }
        if (s_numer > denom == denomPositive || t_numer > denom == denomPositive) {
            return null;
        }
        double t = t_numer / denom;
        double i_x = p0_x + t * s10_x;
        double i_y = p0_y + t * s10_y;
        return new Point2D(i_x, i_y);
    }

    public final void initializePopupMenu() {
        ContextMenu contextMenu = this.buildTooltipContent();
        EventHandler contextMenuHandler2 = (EventHandler)new EventHandler<ContextMenuEvent>(this, contextMenu){
            final /* synthetic */ TransitionLine this$0;
            final /* synthetic */ ContextMenu $contextMenu;

            public final void handle(ContextMenuEvent contextMenuEvent) {
                Node node = (Node)TransitionLine.access$getLine$p(this.this$0);
                ContextMenuEvent contextMenuEvent2 = contextMenuEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)contextMenuEvent2, (String)"contextMenuEvent");
                this.$contextMenu.show(node, contextMenuEvent2.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
            {
                this.this$0 = transitionLine;
                this.$contextMenu = contextMenu;
            }
        };
        this.labelsPane.setOnContextMenuRequested(contextMenuHandler2);
        this.pointer.setOnContextMenuRequested(contextMenuHandler2);
        this.line.setOnContextMenuRequested(contextMenuHandler2);
        this.menuArea.setOnContextMenuRequested(contextMenuHandler2);
    }

    @NotNull
    public final ContextMenu buildTooltipContent() {
        ContextMenu contextMenu = new ContextMenu();
        if (this.transition != null) {
            Object object;
            String string;
            Object object2;
            Object element$iv;
            HashMap mergeStatusDocumentation = new HashMap();
            Object $receiver$iv = this.transition.getMergeStatuses();
            Iterator<Object> iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                String status = (String)element$iv;
                object2 = mergeStatusDocumentation;
                string = "";
                object2.put(status, string);
            }
            $receiver$iv = this.transition.getTransitionDocs();
            iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                TransitionDocumentation doc = (TransitionDocumentation)element$iv;
                object2 = mergeStatusDocumentation;
                string = doc.getMergeStatus();
                object = doc.getDocs();
                object2.put(string, object);
            }
            element$iv = mergeStatusDocumentation;
            iterator = element$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = $receiver$iv = (Map.Entry)iterator.next();
                String status = (String)object2.getKey();
                object2 = $receiver$iv;
                String statusDoc = (String)object2.getValue();
                VBox content = new VBox();
                object = new MenuItem();
                String $receiver = object;
                $receiver.setGraphic((Node)content);
                String documentationMenuItem = object;
                contextMenu.getItems().add((Object)documentationMenuItem);
                Map map = this.transition.getOnStatusSource();
                if (map != null && (map = (Source)map.get(status)) != null) {
                    Object source = object = map;
                    documentationMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>((Source)source, this, (MenuItem)documentationMenuItem){
                        final /* synthetic */ Source $source;
                        final /* synthetic */ TransitionLine this$0;
                        final /* synthetic */ MenuItem $documentationMenuItem$inlined;
                        {
                            this.$source = source;
                            this.this$0 = transitionLine;
                            this.$documentationMenuItem$inlined = menuItem;
                        }

                        public final void handle(ActionEvent $noName_0) {
                            this.this$0.getActionListener().goToSource(this.$source);
                        }
                    });
                }
                content.getChildren().add((Object)new Text(status));
                content.getChildren().add((Object)new Text(statusDoc));
            }
            if (this.transition.isOnAny()) {
                MenuItem onAnyMenuItem = new MenuItem();
                VBox content = new VBox();
                onAnyMenuItem.setGraphic((Node)content);
                content.getChildren().add((Object)new Text("<Any>"));
                content.getChildren().add((Object)new Text("Transition activated by any status."));
                contextMenu.getItems().add((Object)onAnyMenuItem);
                Source source = this.transition.getOnAnySource();
                if (source != null) {
                    onAnyMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, source){
                        final /* synthetic */ TransitionLine this$0;
                        final /* synthetic */ Source $source;

                        public final void handle(ActionEvent $noName_0) {
                            this.this$0.getActionListener().goToSource(this.$source);
                        }
                        {
                            this.this$0 = transitionLine;
                            this.$source = source;
                        }
                    });
                }
            }
        }
        return contextMenu;
    }

    @NotNull
    public final Node getWorld() {
        return this.world;
    }

    @NotNull
    public final Node getFromNode() {
        return this.fromNode;
    }

    @NotNull
    public final Node getToNode() {
        return this.toNode;
    }

    @Nullable
    public final Transition getTransition() {
        return this.transition;
    }

    @NotNull
    public final GraphViewer.ActionListener getActionListener() {
        return this.actionListener;
    }

    public TransitionLine(@NotNull Node world, @NotNull Node fromNode, @NotNull Node toNode, @Nullable Transition transition, @NotNull GraphViewer.ActionListener actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
        Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        this.world = world;
        this.fromNode = fromNode;
        this.toNode = toNode;
        this.transition = transition;
        this.actionListener = actionListener;
        this.labelsPane = new VBox();
        this.getStyleClass().add((Object)"transitionLine");
        this.line = new Line();
        this.line.getStyleClass().add((Object)"pointerLine");
        this.fromCenter = new NodeCenter(this.world, this.fromNode);
        this.toCenter = new NodeCenter(this.world, this.toNode);
        this.fromCenter.getCenterX().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                this.updateLine();
            }
        });
        this.fromCenter.getCenterY().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                this.updateLine();
            }
        });
        this.toCenter.getCenterX().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                this.updateLine();
            }
        });
        this.toCenter.getCenterY().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                this.updateLine();
            }
        });
        this.pointer = new Polygon();
        this.pointer.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 5.0, -15.0, -5.0, -15.0});
        this.pointer.getStyleClass().add((Object)"pointer");
        this.getChildren().add((Object)this.pointer);
        this.getChildren().add((Object)this.line);
        this.menuArea = new Polygon();
        this.menuArea.setOpacity(0.0);
        this.getChildren().add((Object)this.menuArea);
        Transition transition2 = this.transition;
        if (transition2 != null) {
            Transition transition3;
            Transition it = transition3 = transition2;
            this.initializeTransition(it);
        }
        this.initializePopupMenu();
    }

    @NotNull
    public static final /* synthetic */ VBox access$getLabelsPane$p(TransitionLine $this) {
        return $this.labelsPane;
    }

    @NotNull
    public static final /* synthetic */ Line access$getLine$p(TransitionLine $this) {
        return $this.line;
    }
}

