/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.viewer.gl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.completable.reactor.graph.viewer.gl.CoordinateTranslator;
import ru.fix.completable.reactor.graph.viewer.gl.EndPointNode;
import ru.fix.completable.reactor.graph.viewer.gl.GraphNode;
import ru.fix.completable.reactor.graph.viewer.gl.GraphPane;
import ru.fix.completable.reactor.graph.viewer.gl.GraphViewPane;
import ru.fix.completable.reactor.graph.viewer.gl.GraphViewPaneKt;
import ru.fix.completable.reactor.graph.viewer.gl.GraphViewer;
import ru.fix.completable.reactor.graph.viewer.gl.HandlerNode;
import ru.fix.completable.reactor.graph.viewer.gl.MergerNode;
import ru.fix.completable.reactor.graph.viewer.gl.NodeDragger;
import ru.fix.completable.reactor.graph.viewer.gl.NodeDraggerListener;
import ru.fix.completable.reactor.graph.viewer.gl.RouterNode;
import ru.fix.completable.reactor.graph.viewer.gl.Shortcut;
import ru.fix.completable.reactor.graph.viewer.gl.ShortcutType;
import ru.fix.completable.reactor.graph.viewer.gl.StartPointNode;
import ru.fix.completable.reactor.graph.viewer.gl.SubgraphNode;
import ru.fix.completable.reactor.graph.viewer.gl.TransitionLine;
import ru.fix.completable.reactor.model.EndPoint;
import ru.fix.completable.reactor.model.Figure;
import ru.fix.completable.reactor.model.GraphModel;
import ru.fix.completable.reactor.model.HandleableVertexFigure;
import ru.fix.completable.reactor.model.Handler;
import ru.fix.completable.reactor.model.Merger;
import ru.fix.completable.reactor.model.Router;
import ru.fix.completable.reactor.model.Source;
import ru.fix.completable.reactor.model.StartPoint;
import ru.fix.completable.reactor.model.Subgraph;
import ru.fix.completable.reactor.model.Transition;
import ru.fix.completable.reactor.model.TransitionableFigure;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*J\u0018\u0010,\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010-\u001a\u00020.R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010&\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010$\u00a8\u0006/"}, d2={"Lru/fix/completable/reactor/graph/viewer/gl/GraphViewPane;", "Ljavafx/scene/control/ScrollPane;", "actionListener", "Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;", "shortcutProvider", "Lkotlin/Function1;", "Lru/fix/completable/reactor/graph/viewer/gl/ShortcutType;", "Lru/fix/completable/reactor/graph/viewer/gl/Shortcut;", "(Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;Lkotlin/jvm/functions/Function1;)V", "MAX_SCALE", "", "getMAX_SCALE", "()D", "MIN_SCALE", "getMIN_SCALE", "ZOOM_CHANGE_FACTOR", "getZOOM_CHANGE_FACTOR", "getActionListener", "()Lru/fix/completable/reactor/graph/viewer/gl/GraphViewer$ActionListener;", "<set-?>", "Lru/fix/completable/reactor/model/GraphModel;", "graphModel", "getGraphModel", "()Lru/fix/completable/reactor/model/GraphModel;", "setGraphModel", "(Lru/fix/completable/reactor/model/GraphModel;)V", "oldScrollPosition", "Ljavafx/geometry/Point2D;", "pane", "Lru/fix/completable/reactor/graph/viewer/gl/GraphPane;", "getShortcutProvider", "()Lkotlin/jvm/functions/Function1;", "targetViewportPositionX", "getTargetViewportPositionX", "()Ljava/lang/Double;", "setTargetViewportPositionX", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "targetViewportPositionY", "getTargetViewportPositionY", "setTargetViewportPositionY", "enableNodeDragging", "", "initializePopupMenu", "openGraph", "resetViewer", "", "completable-reactor-graph-viewer"})
public final class GraphViewPane
extends ScrollPane {
    private final double MIN_SCALE = 0.3;
    private final double MAX_SCALE = 2.0;
    private final double ZOOM_CHANGE_FACTOR = 1.15;
    private final GraphPane pane;
    private Point2D oldScrollPosition;
    @Nullable
    private GraphModel graphModel;
    @Nullable
    private Double targetViewportPositionX;
    @Nullable
    private Double targetViewportPositionY;
    @NotNull
    private final GraphViewer.ActionListener actionListener;
    @NotNull
    private final Function1<ShortcutType, Shortcut> shortcutProvider;

    public final double getMIN_SCALE() {
        return this.MIN_SCALE;
    }

    public final double getMAX_SCALE() {
        return this.MAX_SCALE;
    }

    public final double getZOOM_CHANGE_FACTOR() {
        return this.ZOOM_CHANGE_FACTOR;
    }

    @Nullable
    public final GraphModel getGraphModel() {
        return this.graphModel;
    }

    private final void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public final void initializePopupMenu() {
        Object object;
        ContextMenu contextMenu;
        block3: {
            block2: {
                Object object2;
                contextMenu = new ContextMenu();
                object = (Shortcut)this.shortcutProvider.invoke((Object)ShortcutType.GOTO_GRAPH);
                if (object == null || (object = ((Shortcut)object).getTitle()) == null) break block2;
                Object it = object2 = object;
                object = " (" + (String)it + ')';
                if (object != null) break block3;
            }
            object = "";
        }
        Object shortcutTitleSuffix = object;
        MenuItem buildGraphMenuItem = new MenuItem("Graph location" + (String)shortcutTitleSuffix);
        buildGraphMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void handle(ActionEvent it) {
                block0: {
                    GraphModel graphModel;
                    GraphModel graphModel2 = this.this$0.getGraphModel();
                    if (graphModel2 == null || (graphModel2 = graphModel2.getStartPoint()) == null || (graphModel2 = graphModel2.getSource()) == null) break block0;
                    GraphModel it2 = graphModel = graphModel2;
                    this.this$0.getActionListener().goToSource((Source)it2);
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        contextMenu.getItems().add((Object)buildGraphMenuItem);
        this.pane.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(this, contextMenu){
            final /* synthetic */ GraphViewPane this$0;
            final /* synthetic */ ContextMenu $contextMenu;

            public final void handle(ContextMenuEvent contextMenuEvent) {
                this.$contextMenu.show((Node)GraphViewPane.access$getPane$p(this.this$0), contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
            {
                this.this$0 = graphViewPane2;
                this.$contextMenu = contextMenu;
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(contextMenu){
            final /* synthetic */ ContextMenu $contextMenu;

            public final void handle(MouseEvent event) {
                this.$contextMenu.hide();
            }
            {
                this.$contextMenu = contextMenu;
            }
        });
    }

    @NotNull
    public final GraphViewPane openGraph(@NotNull GraphModel graphModel, boolean resetViewer) {
        GraphNode it;
        Object line;
        MergerNode mergerNode;
        Object element$iv;
        Object $receiver$iv;
        RouterNode routerNode;
        Object object;
        Object mergerNode2;
        Iterator iterator;
        Object object2;
        Iterator endPointNode;
        Object object3;
        Object object4;
        Object object5;
        Object handlerNode;
        Intrinsics.checkParameterIsNotNull((Object)graphModel, (String)"graphModel");
        this.graphModel = graphModel;
        if (!resetViewer) {
            this.oldScrollPosition = new Point2D(this.getHvalue(), this.getVvalue());
        }
        this.pane.getChildren().clear();
        AtomicReference<StartPointNode> graphNodeTreeForAutoLayout = new AtomicReference<StartPointNode>();
        HashMap handlers = new HashMap();
        Iterator iterator2 = graphModel.getHandlers().values().iterator();
        while (iterator2.hasNext()) {
            Handler handler;
            Handler handler2 = handler = (Handler)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)handler2, (String)"handler");
            handlerNode = new HandlerNode(handler2, this.actionListener);
            Map map = handlers;
            object5 = handler;
            object4 = handlerNode;
            map.put(object5, object4);
            this.pane.getChildren().add(handlerNode);
        }
        HashMap subgraphs = new HashMap();
        handlerNode = graphModel.getSubgraphs().values().iterator();
        while (handlerNode.hasNext()) {
            Subgraph subgraph;
            Subgraph subgraph2 = subgraph = (Subgraph)handlerNode.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)subgraph2, (String)"subgraph");
            SubgraphNode subgraphNode = new SubgraphNode(subgraph2, this.actionListener);
            object5 = subgraphs;
            object4 = subgraph;
            object3 = subgraphNode;
            object5.put(object4, object3);
            this.pane.getChildren().add((Object)subgraphNode);
        }
        StartPointNode startPointNode = new StartPointNode(graphModel.getStartPoint(), graphModel, this.actionListener);
        this.pane.getChildren().add((Object)startPointNode);
        graphNodeTreeForAutoLayout.set(startPointNode);
        HashMap endpoints = new HashMap();
        object5 = graphModel.getEndpoints().values().iterator();
        while (object5.hasNext()) {
            EndPoint endPoint;
            EndPoint endPoint2 = endPoint = (EndPoint)object5.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)endPoint2, (String)"endPoint");
            endPointNode = new EndPointNode(endPoint2, this.actionListener);
            object3 = endpoints;
            object2 = endPoint;
            iterator = endPointNode;
            object3.put(object2, iterator);
            this.pane.getChildren().addAll((Object[])new Node[]{(Node)endPointNode});
        }
        HashMap mergers = new HashMap();
        endPointNode = graphModel.getMergers().values().iterator();
        while (endPointNode.hasNext()) {
            Merger merger;
            Merger merger2 = merger = (Merger)endPointNode.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)merger2, (String)"merger");
            mergerNode2 = new MergerNode(merger2, this.actionListener);
            object2 = mergers;
            iterator = merger;
            object = mergerNode2;
            object2.put(iterator, object);
            this.pane.getChildren().add(mergerNode2);
        }
        HashMap routers = new HashMap();
        mergerNode2 = graphModel.getRouters().values().iterator();
        while (mergerNode2.hasNext()) {
            Router router;
            Router router2 = router = (Router)mergerNode2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)router2, (String)"router");
            routerNode = new RouterNode(router2, this.actionListener);
            iterator = routers;
            object = router;
            RouterNode routerNode2 = routerNode;
            iterator.put(object, routerNode2);
            this.pane.getChildren().add((Object)routerNode);
        }
        Function1<TransitionableFigure, GraphNode> transitionable$ = new Function1<TransitionableFigure, GraphNode>(mergers, routers){
            final /* synthetic */ HashMap $mergers;
            final /* synthetic */ HashMap $routers;

            @NotNull
            public final GraphNode invoke(@NotNull TransitionableFigure figure) {
                GraphNode graphNode;
                Intrinsics.checkParameterIsNotNull((Object)figure, (String)"figure");
                TransitionableFigure transitionableFigure = figure;
                if (transitionableFigure instanceof Merger) {
                    V v = this.$mergers.get(figure);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"mergers[figure]!!");
                    graphNode = (GraphNode)v;
                } else if (transitionableFigure instanceof Router) {
                    V v = this.$routers.get(figure);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"routers[figure]!!");
                    graphNode = (GraphNode)v;
                } else {
                    throw (Throwable)new IllegalArgumentException("figure: " + figure);
                }
                return graphNode;
            }
            {
                this.$mergers = hashMap;
                this.$routers = hashMap2;
                super(1);
            }
        };
        Function1<Figure, GraphNode> figureNode$ = new Function1<Figure, GraphNode>(subgraphs, handlers, mergers, routers, endpoints, startPointNode){
            final /* synthetic */ HashMap $subgraphs;
            final /* synthetic */ HashMap $handlers;
            final /* synthetic */ HashMap $mergers;
            final /* synthetic */ HashMap $routers;
            final /* synthetic */ HashMap $endpoints;
            final /* synthetic */ StartPointNode $startPointNode;

            @Nullable
            public final GraphNode invoke(@NotNull Figure figure) {
                GraphNode graphNode;
                Intrinsics.checkParameterIsNotNull((Object)figure, (String)"figure");
                Figure figure2 = figure;
                if (figure2 instanceof Subgraph) {
                    graphNode = (GraphNode)this.$subgraphs.get(figure);
                } else if (figure2 instanceof Handler) {
                    graphNode = (GraphNode)this.$handlers.get(figure);
                } else if (figure2 instanceof Merger) {
                    graphNode = (GraphNode)this.$mergers.get(figure);
                } else if (figure2 instanceof Router) {
                    graphNode = (GraphNode)this.$routers.get(figure);
                } else if (figure2 instanceof EndPoint) {
                    graphNode = (GraphNode)this.$endpoints.get(figure);
                } else if (figure2 instanceof StartPoint) {
                    graphNode = this.$startPointNode;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return graphNode;
            }
            {
                this.$subgraphs = hashMap;
                this.$handlers = hashMap2;
                this.$mergers = hashMap3;
                this.$routers = hashMap4;
                this.$endpoints = hashMap5;
                this.$startPointNode = startPointNode;
                super(1);
            }
        };
        Collection collection = graphModel.getHandlers().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"graphModel.handlers.values");
        routerNode = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<Handler, Pair<? extends HandlerNode, ? extends MergerNode>>(graphModel, handlers, mergers){
            final /* synthetic */ GraphModel $graphModel;
            final /* synthetic */ HashMap $handlers;
            final /* synthetic */ HashMap $mergers;

            @Nullable
            public final Pair<HandlerNode, MergerNode> invoke(@NotNull Handler handler) {
                Pair pair;
                Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
                Merger merger = (Merger)this.$graphModel.getMergers().get(handler.getName());
                if (merger != null) {
                    Merger merger2;
                    Merger merger3 = merger2 = merger;
                    V v = this.$handlers.get(handler);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    V v2 = this.$mergers.get(merger3);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    pair = new Pair(v, v2);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$graphModel = graphModel;
                this.$handlers = hashMap;
                this.$mergers = hashMap2;
                super(1);
            }
        }));
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Pair $handlerNode_mergerNode = (Pair)element$iv;
            HandlerNode handlerNode2 = (HandlerNode)$handlerNode_mergerNode.component1();
            mergerNode = (MergerNode)$handlerNode_mergerNode.component2();
            Node node = (Node)this.pane;
            HandlerNode handlerNode3 = handlerNode2;
            Intrinsics.checkExpressionValueIsNotNull((Object)handlerNode3, (String)"handlerNode");
            Node node2 = (Node)handlerNode3;
            MergerNode mergerNode3 = mergerNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergerNode3, (String)"mergerNode");
            line = new TransitionLine(node, node2, (Node)mergerNode3, null, this.actionListener);
            this.pane.getChildren().add(line);
            line.toBack();
            ((ArrayList)handlerNode2.getGraphChildren()).add(mergerNode);
        }
        Collection collection2 = graphModel.getSubgraphs().values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"graphModel.subgraphs.values");
        $receiver$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)((Function1)new Function1<Subgraph, Pair<? extends SubgraphNode, ? extends MergerNode>>(graphModel, subgraphs, mergers){
            final /* synthetic */ GraphModel $graphModel;
            final /* synthetic */ HashMap $subgraphs;
            final /* synthetic */ HashMap $mergers;

            @Nullable
            public final Pair<SubgraphNode, MergerNode> invoke(@NotNull Subgraph subgraph) {
                Pair pair;
                Intrinsics.checkParameterIsNotNull((Object)subgraph, (String)"subgraph");
                Merger merger = (Merger)this.$graphModel.getMergers().get(subgraph.getName());
                if (merger != null) {
                    Merger merger2;
                    Merger merger3 = merger2 = merger;
                    V v = this.$subgraphs.get(subgraph);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    V v2 = this.$mergers.get(merger3);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    pair = new Pair(v, v2);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$graphModel = graphModel;
                this.$subgraphs = hashMap;
                this.$mergers = hashMap2;
                super(1);
            }
        }));
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Pair $subgraphNode_mergerNode = (Pair)element$iv;
            SubgraphNode subgraphNode = (SubgraphNode)$subgraphNode_mergerNode.component1();
            mergerNode = (MergerNode)$subgraphNode_mergerNode.component2();
            Node node = (Node)this.pane;
            SubgraphNode subgraphNode2 = subgraphNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)subgraphNode2, (String)"subgraphNode");
            Node node3 = (Node)subgraphNode2;
            MergerNode mergerNode4 = mergerNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergerNode4, (String)"mergerNode");
            line = new TransitionLine(node, node3, (Node)mergerNode4, null, this.actionListener);
            this.pane.getChildren().add(line);
            line.toBack();
            ((ArrayList)subgraphNode.getGraphChildren()).add(mergerNode);
        }
        $receiver$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)graphModel.getTransitionable().getValues()), (Function1)openGraph.7.INSTANCE), (Function1)((Function1)new Function1<TransitionableFigure, Pair<? extends TransitionableFigure, ? extends GraphNode>>(transitionable$){
            final /* synthetic */ openGraph.1 $transitionable$1;

            @NotNull
            public final Pair<TransitionableFigure, GraphNode> invoke(@NotNull TransitionableFigure it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new Pair((Object)it, (Object)this.$transitionable$1.invoke(it));
            }
            {
                this.$transitionable$1 = var1_1;
                super(1);
            }
        }));
        iterator = $receiver$iv.iterator();
        block7: while (iterator.hasNext()) {
            element$iv = iterator.next();
            Pair $transitionable_transitionableNode = (Pair)element$iv;
            TransitionableFigure transitionable = (TransitionableFigure)$transitionable_transitionableNode.component1();
            GraphNode transitionableNode = (GraphNode)$transitionable_transitionableNode.component2();
            for (Transition transition : transitionable.getTransitions()) {
                GraphNode toNode = figureNode$.invoke(transition.getTarget());
                if (toNode == null) {
                    GraphViewPaneKt.access$getLog$p().error((Function0)new Function0<String>(transitionableNode, transition){
                        final /* synthetic */ GraphNode $transitionableNode;
                        final /* synthetic */ Transition $transition;

                        @NotNull
                        public final String invoke() {
                            return "Failed to build transition line" + " from " + this.$transitionableNode.getFigure() + " to " + this.$transition.getTarget() + '.' + " Skip line and children.";
                        }
                        {
                            this.$transitionableNode = graphNode;
                            this.$transition = transition;
                            super(0);
                        }
                    });
                    continue block7;
                }
                TransitionLine line2 = new TransitionLine((Node)this.pane, (Node)transitionableNode, (Node)toNode, transition, this.actionListener);
                this.pane.getChildren().add((Object)line2);
                line2.toBack();
                ((ArrayList)transitionableNode.getGraphChildren()).add(toNode);
            }
        }
        $receiver$iv = graphModel.getStartPoint().getHandleBy();
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            HandleableVertexFigure figure = (HandleableVertexFigure)element$iv;
            GraphNode toNode = figureNode$.invoke((Figure)figure);
            if (toNode == null) {
                GraphViewPaneKt.access$getLog$p().error((Function0)new Function0<String>(figure){
                    final /* synthetic */ HandleableVertexFigure $figure;

                    @NotNull
                    public final String invoke() {
                        return "Failed to build transition line" + " from StartPoint to " + this.$figure + '.' + " Skip transition and children.";
                    }
                    {
                        this.$figure = handleableVertexFigure;
                        super(0);
                    }
                });
                continue;
            }
            TransitionLine line3 = new TransitionLine((Node)this.pane, (Node)startPointNode, (Node)toNode, null, this.actionListener);
            this.pane.getChildren().add((Object)line3);
            line3.toBack();
            ((ArrayList)startPointNode.getGraphChildren()).add(toNode);
        }
        Collection collection3 = mergers.values();
        Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"mergers.values");
        $receiver$iv = collection3;
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (MergerNode)element$iv;
            it.toFront();
        }
        Collection collection4 = routers.values();
        Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"routers.values");
        $receiver$iv = collection4;
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (RouterNode)element$iv;
            it.toFront();
        }
        this.enableNodeDragging();
        this.hvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void changed(ObservableValue<? extends Number> observable, Number old, Number number) {
                Double positionX = this.this$0.getTargetViewportPositionX();
                if (positionX != null && Intrinsics.areEqual((Object)positionX, (Object)number) ^ true) {
                    Platform.runLater((Runnable)new Runnable(this, positionX){
                        final /* synthetic */ openGraph.13 this$0;
                        final /* synthetic */ Double $positionX;

                        public final void run() {
                            this.this$0.this$0.setTargetViewportPositionX(null);
                            this.this$0.this$0.setHvalue(this.$positionX);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$positionX = d;
                        }
                    });
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        this.vvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GraphViewPane this$0;

            public final void changed(ObservableValue<? extends Number> observable, Number old, Number number) {
                Double positionY = this.this$0.getTargetViewportPositionY();
                if (positionY != null && Intrinsics.areEqual((Object)positionY, (Object)number) ^ true) {
                    Platform.runLater((Runnable)new Runnable(this, positionY){
                        final /* synthetic */ openGraph.14 this$0;
                        final /* synthetic */ Double $positionY;

                        public final void run() {
                            this.this$0.this$0.setTargetViewportPositionY(null);
                            this.this$0.this$0.setVvalue(this.$positionY);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$positionY = d;
                        }
                    });
                }
            }
            {
                this.this$0 = graphViewPane2;
            }
        });
        this.pane.requestResize((Function0<Unit>)((Function0)new Function0<Unit>(this, resetViewer){
            final /* synthetic */ GraphViewPane this$0;
            final /* synthetic */ boolean $resetViewer;

            public final void invoke() {
                Point2D position = this.$resetViewer ? new Point2D(0.5, 0.5) : GraphViewPane.access$getOldScrollPosition$p(this.this$0);
                this.this$0.setTargetViewportPositionX(position.getX());
                this.this$0.setTargetViewportPositionY(position.getY());
                this.this$0.setHvalue(position.getX());
                this.this$0.setVvalue(position.getY());
            }
            {
                this.this$0 = graphViewPane2;
                this.$resetViewer = bl;
                super(0);
            }
        }));
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ GraphViewPane openGraph$default(GraphViewPane graphViewPane2, GraphModel graphModel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return graphViewPane2.openGraph(graphModel, bl);
    }

    public final void enableNodeDragging() {
        ObservableList observableList = this.pane.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"pane.children");
        Sequence $receiver$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)observableList)), (Function1)enableNodeDragging.1.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            GraphNode it = (GraphNode)element$iv;
            NodeDragger.Companion.attach(it, new NodeDraggerListener(this){
                final /* synthetic */ GraphViewPane this$0;
                {
                    this.this$0 = graphViewPane2;
                }

                public void modelChanging() {
                    GraphViewPane.access$getPane$p(this.this$0).requestLayout();
                }

                public void modelChanged() {
                    block0: {
                        GraphModel graphModel;
                        GraphViewPane.access$getPane$p(this.this$0).requestResize((Function0<Unit>)((Function0)enableNodeDragging.2.modelChanged.1.INSTANCE));
                        GraphModel graphModel2 = this.this$0.getGraphModel();
                        if (graphModel2 == null) break block0;
                        GraphModel it = graphModel = graphModel2;
                        this.this$0.getActionListener().coordinatesChanged(it);
                    }
                }
            }, new CoordinateTranslator(this.pane));
        }
    }

    @Nullable
    public final Double getTargetViewportPositionX() {
        return this.targetViewportPositionX;
    }

    public final void setTargetViewportPositionX(@Nullable Double d) {
        this.targetViewportPositionX = d;
    }

    @Nullable
    public final Double getTargetViewportPositionY() {
        return this.targetViewportPositionY;
    }

    public final void setTargetViewportPositionY(@Nullable Double d) {
        this.targetViewportPositionY = d;
    }

    @NotNull
    public final GraphViewer.ActionListener getActionListener() {
        return this.actionListener;
    }

    @NotNull
    public final Function1<ShortcutType, Shortcut> getShortcutProvider() {
        return this.shortcutProvider;
    }

    public GraphViewPane(@NotNull GraphViewer.ActionListener actionListener, @NotNull Function1<? super ShortcutType, Shortcut> shortcutProvider) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        Intrinsics.checkParameterIsNotNull(shortcutProvider, (String)"shortcutProvider");
        this.actionListener = actionListener;
        this.shortcutProvider = shortcutProvider;
        this.MIN_SCALE = 0.3;
        this.MAX_SCALE = 2.0;
        this.ZOOM_CHANGE_FACTOR = 1.15;
        this.pane = new GraphPane();
        this.oldScrollPosition = new Point2D(0.5, 0.5);
        this.pane.getStyleClass().add((Object)"graphViewer");
        this.setPannable(true);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setContent((Node)this.pane);
        this.pane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public final void handle(ScrollEvent scrollEvent) {
                ScrollEvent scrollEvent2 = scrollEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)scrollEvent2, (String)"scrollEvent");
                if (scrollEvent2.isControlDown()) {
                    scrollEvent.consume();
                    double zoomChangeFactor = scrollEvent.getDeltaY() > 0.0 ? this.getZOOM_CHANGE_FACTOR() : 1.0 / this.getZOOM_CHANGE_FACTOR();
                    double newScaleX = pane.getScaleX() * zoomChangeFactor;
                    double newScaleY = pane.getScaleY() * zoomChangeFactor;
                    if (newScaleX > this.getMIN_SCALE() && newScaleX < this.getMAX_SCALE() && newScaleY > this.getMIN_SCALE() && newScaleY < this.getMAX_SCALE()) {
                        pane.setScaleX(newScaleX);
                        pane.setScaleY(newScaleY);
                    }
                } else {
                    scrollEvent.consume();
                }
            }
        });
        this.initializePopupMenu();
    }

    @Nullable
    public static final /* synthetic */ GraphModel access$getGraphModel$p(GraphViewPane $this) {
        return $this.graphModel;
    }

    public static final /* synthetic */ void access$setGraphModel$p(GraphViewPane $this, @Nullable GraphModel graphModel) {
        $this.graphModel = graphModel;
    }

    @NotNull
    public static final /* synthetic */ Point2D access$getOldScrollPosition$p(GraphViewPane $this) {
        return $this.oldScrollPosition;
    }

    public static final /* synthetic */ void access$setOldScrollPosition$p(GraphViewPane $this, @NotNull Point2D point2D) {
        $this.oldScrollPosition = point2D;
    }
}

