/*
 * Decompiled with CFR 0.152.
 */
package br.com.sapereaude.maskedEditText;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import br.com.sapereaude.maskedEditText.R;
import br.com.sapereaude.maskedEditText.Range;
import br.com.sapereaude.maskedEditText.RawText;

public class MaskedEditText
extends AppCompatEditText
implements TextWatcher {
    public static final String SPACE = " ";
    private String mask;
    private char charRepresentation;
    private boolean keepHint;
    private int[] rawToMask;
    private RawText rawText;
    private boolean editingBefore;
    private boolean editingOnChanged;
    private boolean editingAfter;
    private int[] maskToRaw;
    private int selection;
    private boolean initialized;
    private boolean ignore;
    protected int maxRawLength;
    private int lastValidMaskPosition;
    private boolean selectionChanged;
    private View.OnFocusChangeListener focusChangeListener;
    private String allowedChars;
    private String deniedChars;

    public MaskedEditText(Context context) {
        super(context);
        this.init();
    }

    public MaskedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.MaskedEditText);
        this.mask = attributes.getString(R.styleable.MaskedEditText_mask);
        this.allowedChars = attributes.getString(R.styleable.MaskedEditText_allowed_chars);
        this.deniedChars = attributes.getString(R.styleable.MaskedEditText_denied_chars);
        String representation = attributes.getString(R.styleable.MaskedEditText_char_representation);
        this.charRepresentation = representation == null ? (char)35 : representation.charAt(0);
        this.keepHint = attributes.getBoolean(R.styleable.MaskedEditText_keep_hint, false);
        this.cleanUp();
        this.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                switch (actionId) {
                    default: 
                }
                return true;
            }
        });
        attributes.recycle();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superParcellable = super.onSaveInstanceState();
        Bundle state = new Bundle();
        state.putParcelable("super", superParcellable);
        state.putString("text", this.getRawText());
        return state;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        super.onRestoreInstanceState(((Bundle)state).getParcelable("super"));
        String text = bundle.getString("text");
        Log.d((String)"ContentValues", (String)("onRestoreInstanceState: " + text));
        this.setText(text);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        this.focusChangeListener = listener;
    }

    private void cleanUp() {
        this.initialized = false;
        this.generatePositionArrays();
        this.rawText = new RawText();
        this.selection = this.rawToMask[0];
        this.editingBefore = true;
        this.editingOnChanged = true;
        this.editingAfter = true;
        if (this.hasHint() && this.rawText.length() == 0) {
            this.setText(this.makeMaskedTextWithHint());
        } else {
            this.setText(this.makeMaskedText());
        }
        this.editingBefore = false;
        this.editingOnChanged = false;
        this.editingAfter = false;
        this.maxRawLength = this.maskToRaw[this.previousValidPosition(this.mask.length() - 1)] + 1;
        this.lastValidMaskPosition = this.findLastValidMaskPosition();
        this.initialized = true;
        super.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (MaskedEditText.this.focusChangeListener != null) {
                    MaskedEditText.this.focusChangeListener.onFocusChange(v, hasFocus);
                }
                if (MaskedEditText.this.hasFocus()) {
                    MaskedEditText.this.selectionChanged = false;
                    MaskedEditText.this.setSelection(MaskedEditText.this.lastValidPosition());
                }
            }
        });
    }

    private int findLastValidMaskPosition() {
        for (int i = this.maskToRaw.length - 1; i >= 0; --i) {
            if (this.maskToRaw[i] == -1) continue;
            return i;
        }
        throw new RuntimeException("Mask must contain at least one representation char");
    }

    private boolean hasHint() {
        return this.getHint() != null;
    }

    public MaskedEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.cleanUp();
    }

    public String getMask() {
        return this.mask;
    }

    public String getRawText() {
        return this.rawText.getText();
    }

    public void setCharRepresentation(char charRepresentation) {
        this.charRepresentation = charRepresentation;
        this.cleanUp();
    }

    public char getCharRepresentation() {
        return this.charRepresentation;
    }

    private void generatePositionArrays() {
        int[] aux = new int[this.mask.length()];
        this.maskToRaw = new int[this.mask.length()];
        String charsInMaskAux = "";
        int charIndex = 0;
        for (int i = 0; i < this.mask.length(); ++i) {
            char currentChar = this.mask.charAt(i);
            if (currentChar == this.charRepresentation) {
                aux[charIndex] = i;
                this.maskToRaw[i] = charIndex++;
                continue;
            }
            String charAsString = Character.toString(currentChar);
            if (!charsInMaskAux.contains(charAsString)) {
                charsInMaskAux = charsInMaskAux.concat(charAsString);
            }
            this.maskToRaw[i] = -1;
        }
        if (charsInMaskAux.indexOf(32) < 0) {
            charsInMaskAux = charsInMaskAux + SPACE;
        }
        char[] charsInMask = charsInMaskAux.toCharArray();
        this.rawToMask = new int[charIndex];
        for (int i = 0; i < charIndex; ++i) {
            this.rawToMask[i] = aux[i];
        }
    }

    private void init() {
        this.addTextChangedListener(this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (!this.editingBefore) {
            Range range;
            this.editingBefore = true;
            if (start > this.lastValidMaskPosition) {
                this.ignore = true;
            }
            int rangeStart = start;
            if (after == 0) {
                rangeStart = this.erasingStart(start);
            }
            if ((range = this.calculateRange(rangeStart, start + count)).getStart() != -1) {
                this.rawText.subtractFromString(range);
            }
            if (count > 0) {
                this.selection = this.previousValidPosition(start);
            }
        }
    }

    private int erasingStart(int start) {
        while (start > 0 && this.maskToRaw[start] == -1) {
            --start;
        }
        return start;
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (!this.editingOnChanged && this.editingBefore) {
            this.editingOnChanged = true;
            if (this.ignore) {
                return;
            }
            if (count > 0) {
                int startingPosition = this.maskToRaw[this.nextValidPosition(start)];
                String addedString = s.subSequence(start, start + count).toString();
                count = this.rawText.addToString(this.clear(addedString), startingPosition, this.maxRawLength);
                if (this.initialized) {
                    int currentPosition = startingPosition + count < this.rawToMask.length ? this.rawToMask[startingPosition + count] : this.lastValidMaskPosition + 1;
                    this.selection = this.nextValidPosition(currentPosition);
                }
            }
        }
    }

    public void afterTextChanged(Editable s) {
        if (!this.editingAfter && this.editingBefore && this.editingOnChanged) {
            this.editingAfter = true;
            if (this.hasHint() && (this.keepHint || this.rawText.length() == 0)) {
                this.setText(this.makeMaskedTextWithHint());
            } else {
                this.setText(this.makeMaskedText());
            }
            this.selectionChanged = false;
            this.setSelection(this.selection);
            this.editingBefore = false;
            this.editingOnChanged = false;
            this.editingAfter = false;
            this.ignore = false;
        }
    }

    public boolean isKeepHint() {
        return this.keepHint;
    }

    public void setKeepHint(boolean keepHint) {
        this.keepHint = keepHint;
        this.setText(this.getRawText());
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        if (this.initialized) {
            if (!this.selectionChanged) {
                selStart = this.fixSelection(selStart);
                selEnd = this.fixSelection(selEnd);
                if (selStart > this.getText().length()) {
                    selStart = this.getText().length();
                }
                if (selStart < 0) {
                    selStart = 0;
                }
                if (selEnd > this.getText().length()) {
                    selEnd = this.getText().length();
                }
                if (selEnd < 0) {
                    selEnd = 0;
                }
                this.setSelection(selStart, selEnd);
                this.selectionChanged = true;
            } else if (selStart > this.rawText.length() - 1) {
                int start = this.fixSelection(selStart);
                int end = this.fixSelection(selEnd);
                if (start >= 0 && end < this.getText().length()) {
                    this.setSelection(start, end);
                }
            }
        }
        super.onSelectionChanged(selStart, selEnd);
    }

    private int fixSelection(int selection) {
        if (selection > this.lastValidPosition()) {
            return this.lastValidPosition();
        }
        return this.nextValidPosition(selection);
    }

    private int nextValidPosition(int currentPosition) {
        while (currentPosition < this.lastValidMaskPosition && this.maskToRaw[currentPosition] == -1) {
            ++currentPosition;
        }
        if (currentPosition > this.lastValidMaskPosition) {
            return this.lastValidMaskPosition + 1;
        }
        return currentPosition;
    }

    private int previousValidPosition(int currentPosition) {
        while (currentPosition >= 0 && this.maskToRaw[currentPosition] == -1) {
            if (--currentPosition >= 0) continue;
            return this.nextValidPosition(0);
        }
        return currentPosition;
    }

    private int lastValidPosition() {
        if (this.rawText.length() == this.maxRawLength) {
            return this.rawToMask[this.rawText.length() - 1] + 1;
        }
        return this.nextValidPosition(this.rawToMask[this.rawText.length()]);
    }

    private String makeMaskedText() {
        int maskedTextLength = this.rawText.length() < this.rawToMask.length ? this.rawToMask[this.rawText.length()] : this.mask.length();
        char[] maskedText = new char[maskedTextLength];
        for (int i = 0; i < maskedText.length; ++i) {
            int rawIndex = this.maskToRaw[i];
            maskedText[i] = rawIndex == -1 ? this.mask.charAt(i) : this.rawText.charAt(rawIndex);
        }
        return new String(maskedText);
    }

    private CharSequence makeMaskedTextWithHint() {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        int maskFirstChunkEnd = this.rawToMask[0];
        for (int i = 0; i < this.mask.length(); ++i) {
            int mtrv = this.maskToRaw[i];
            if (mtrv != -1) {
                if (mtrv < this.rawText.length()) {
                    ssb.append(this.rawText.charAt(mtrv));
                } else {
                    ssb.append(this.getHint().charAt(this.maskToRaw[i]));
                }
            } else {
                ssb.append(this.mask.charAt(i));
            }
            if ((!this.keepHint || this.rawText.length() >= this.rawToMask.length || i < this.rawToMask[this.rawText.length()]) && (this.keepHint || i < maskFirstChunkEnd)) continue;
            ssb.setSpan((Object)new ForegroundColorSpan(this.getCurrentHintTextColor()), i, i + 1, 0);
        }
        return ssb;
    }

    private Range calculateRange(int start, int end) {
        int newStart;
        Range range = new Range();
        for (int i = start; i <= end && i < this.mask.length(); ++i) {
            if (this.maskToRaw[i] == -1) continue;
            if (range.getStart() == -1) {
                range.setStart(this.maskToRaw[i]);
            }
            range.setEnd(this.maskToRaw[i]);
        }
        if (end == this.mask.length()) {
            range.setEnd(this.rawText.length());
        }
        if (range.getStart() == range.getEnd() && start < end && (newStart = this.previousValidPosition(range.getStart() - 1)) < range.getStart()) {
            range.setStart(newStart);
        }
        return range;
    }

    private String clear(String string) {
        if (this.deniedChars != null) {
            for (char c : this.deniedChars.toCharArray()) {
                string = string.replace(Character.toString(c), "");
            }
        }
        if (this.allowedChars != null) {
            StringBuilder builder = new StringBuilder(string.length());
            for (char c : string.toCharArray()) {
                if (!this.allowedChars.contains(String.valueOf(c))) continue;
                builder.append(c);
            }
            string = builder.toString();
        }
        return string;
    }
}

