/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.render;

import java.util.Arrays;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.divinecraft.customstuff.api.render.CustomBlockRenderingProperties;

public final class SimpleCustomBlockRenderingProperties
implements CustomBlockRenderingProperties {
    @NonNull
    private final ItemStack displayedItem;
    private final @NotNull CustomBlockRenderingProperties.RenderingHint @NonNull [] renderingHints;

    public static CustomBlockRenderingProperties create(@NonNull ItemStack renderItem) {
        if (renderItem == null) {
            throw new NullPointerException("renderItem is marked non-null but is null");
        }
        return new SimpleCustomBlockRenderingProperties(renderItem, CustomBlockRenderingProperties.RenderingHint.none());
    }

    public static CustomBlockRenderingProperties create(@NonNull ItemStack renderItem, CustomBlockRenderingProperties.RenderingHint ... renderingHints) {
        if (renderItem == null) {
            throw new NullPointerException("renderItem is marked non-null but is null");
        }
        if (renderingHints == null) {
            throw new NullPointerException("renderingHints is marked non-null but is null");
        }
        return new SimpleCustomBlockRenderingProperties(renderItem, CustomBlockRenderingProperties.RenderingHint.none());
    }

    public SimpleCustomBlockRenderingProperties(@NonNull ItemStack displayedItem, @NotNull CustomBlockRenderingProperties.RenderingHint @NonNull [] renderingHints) {
        if (displayedItem == null) {
            throw new NullPointerException("displayedItem is marked non-null but is null");
        }
        if (renderingHints == null) {
            throw new NullPointerException("renderingHints is marked non-null but is null");
        }
        this.displayedItem = displayedItem;
        this.renderingHints = renderingHints;
    }

    @Override
    @NonNull
    public ItemStack displayedItem() {
        return this.displayedItem;
    }

    @Override
    public @NotNull CustomBlockRenderingProperties.RenderingHint @NonNull [] renderingHints() {
        return this.renderingHints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCustomBlockRenderingProperties)) {
            return false;
        }
        SimpleCustomBlockRenderingProperties other = (SimpleCustomBlockRenderingProperties)o;
        ItemStack this$displayedItem = this.displayedItem();
        ItemStack other$displayedItem = other.displayedItem();
        if (this$displayedItem == null ? other$displayedItem != null : !this$displayedItem.equals(other$displayedItem)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.renderingHints(), (Object[])other.renderingHints());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $displayedItem = this.displayedItem();
        result = result * 59 + ($displayedItem == null ? 43 : $displayedItem.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.renderingHints());
        return result;
    }

    public String toString() {
        return "SimpleCustomBlockRenderingProperties(displayedItem=" + this.displayedItem() + ", renderingHints=" + this.renderingHints() + ")";
    }
}

