/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.recipe;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import ru.progrm_jarvis.minecraft.commons.util.ItemStackUtil;

@FunctionalInterface
public interface ItemStackMatcher
extends Predicate<ItemStack> {
    public static boolean matches(@Nullable ItemStackMatcher matcher, @Nullable ItemStack item) {
        return ItemStackUtil.isEmpty((ItemStack)item) ? matcher == null : matcher != null && matcher.matches(item);
    }

    public boolean matches(@NotNull ItemStack var1);

    default public @Unmodifiable @Nullable Set<ItemStack> icons() {
        return null;
    }

    @Override
    default public boolean test(@NotNull ItemStack itemStack) {
        return this.matches(itemStack);
    }

    @NotNull
    default public ItemStackMatcher negate() {
        return item -> !this.matches(item);
    }

    @NotNull
    default public ItemStackMatcher and(@NonNull ItemStackMatcher other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return item -> this.matches(item) && other.matches(item);
    }

    @NotNull
    default public ItemStackMatcher or(@NonNull ItemStackMatcher other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return item -> this.matches(item) || other.matches(item);
    }

    @NotNull
    default public ItemStackMatcher withIcon(@Unmodifiable @Nullable ItemStack icon) {
        return this.withIcons(icon == null ? null : Collections.singleton(icon));
    }

    @NotNull
    default public ItemStackMatcher withIcons(final @Unmodifiable @Nullable Set<@NonNull ItemStack> icons) {
        if (icons != null) {
            for (ItemStack icon : icons) {
                Preconditions.checkNotNull((Object)icon, (Object)"None of the icons can be null");
            }
        }
        return new ItemStackMatcher(){

            @Override
            public boolean matches(@NotNull ItemStack item) {
                return ItemStackMatcher.this.matches(item);
            }

            @Override
            @Nullable
            public Set<ItemStack> icons() {
                return icons;
            }
        };
    }

    @NotNull
    public static ItemStackMatcher forMaterial(final @NonNull Material material) {
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        final Set<ItemStack> icons = Collections.singleton(new ItemStack(material));
        return new ItemStackMatcher(){

            @Override
            public boolean matches(@NotNull ItemStack item) {
                return item.getType() == material;
            }

            @Override
            public @Unmodifiable @NotNull Set<ItemStack> icons() {
                return icons;
            }
        };
    }

    @NotNull
    public static ItemStackMatcher forMaterials(final @NonNull @Unmodifiable @NonNull Set<@NonNull Material> materials) {
        if (materials == null) {
            throw new NullPointerException("materials is marked non-null but is null");
        }
        HashSet<ItemStack> iconItems = new HashSet<ItemStack>(materials.size());
        for (Material material : materials) {
            Preconditions.checkNotNull((Object)material, (Object)"None of the materials can be null");
            iconItems.add(new ItemStack(material));
        }
        final Set icons = Collections.unmodifiableSet(iconItems);
        return new ItemStackMatcher(){

            @Override
            public boolean matches(@NotNull ItemStack item) {
                return materials.contains(item.getType());
            }

            @Override
            public @Unmodifiable @NotNull Set<ItemStack> icons() {
                return icons;
            }
        };
    }

    @NotNull
    public static ItemStackMatcher forMaterials(@NonNull Material firstMaterial, Material ... restMaterials) {
        if (firstMaterial == null) {
            throw new NullPointerException("firstMaterial is marked non-null but is null");
        }
        if (restMaterials == null) {
            throw new NullPointerException("restMaterials is marked non-null but is null");
        }
        return ItemStackMatcher.forMaterials(EnumSet.of(firstMaterial, restMaterials));
    }
}

