/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.nbt;

import org.bukkit.entity.Entity;
import ru.divinecraft.customstuff.api.nbt.NBTCompound;
import ru.divinecraft.customstuff.api.nbt.NBTContainer;
import ru.divinecraft.customstuff.api.nbt.NBTReflectionUtil;
import ru.divinecraft.customstuff.api.nbt.utils.MinecraftVersion;
import ru.divinecraft.customstuff.api.nbt.utils.annotations.AvaliableSince;
import ru.divinecraft.customstuff.api.nbt.utils.annotations.CheckUtil;
import ru.divinecraft.customstuff.api.nbt.utils.annotations.FAUtil;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("BukkitValues").booleanValue()) {
            return this.getCompound("BukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("BukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("BukkitValues");
    }
}

