/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.item.event;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.divinecraft.customstuff.api.item.CustomItem;

public final class CustomItemClickEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private boolean cancelled = false;
    @Nullable
    private final CustomItem item;
    @NotNull
    private final Player player;
    @NotNull
    private final Action action;
    @NotNull
    private final BlockFace blockFace;
    private final boolean mainHand;
    @NotNull
    private final Block block;

    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Nullable
    public CustomItem getItem() {
        return this.item;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @NotNull
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public boolean isMainHand() {
        return this.mainHand;
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        return "CustomItemClickEvent(cancelled=" + this.isCancelled() + ", item=" + this.getItem() + ", player=" + this.getPlayer() + ", action=" + this.getAction() + ", blockFace=" + this.getBlockFace() + ", mainHand=" + this.isMainHand() + ", block=" + this.getBlock() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomItemClickEvent)) {
            return false;
        }
        CustomItemClickEvent other = (CustomItemClickEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        if (this.isMainHand() != other.isMainHand()) {
            return false;
        }
        CustomItem this$item = this.getItem();
        CustomItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        BlockFace this$blockFace = this.getBlockFace();
        BlockFace other$blockFace = other.getBlockFace();
        if (this$blockFace == null ? other$blockFace != null : !this$blockFace.equals(other$blockFace)) {
            return false;
        }
        Block this$block = this.getBlock();
        Block other$block = other.getBlock();
        return !(this$block == null ? other$block != null : !this$block.equals(other$block));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomItemClickEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        result = result * 59 + (this.isMainHand() ? 79 : 97);
        CustomItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        BlockFace $blockFace = this.getBlockFace();
        result = result * 59 + ($blockFace == null ? 43 : $blockFace.hashCode());
        Block $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        return result;
    }

    public CustomItemClickEvent(@Nullable CustomItem item, @NotNull Player player, @NotNull Action action, @NotNull BlockFace blockFace, boolean mainHand, @NotNull Block block) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (blockFace == null) {
            throw new NullPointerException("blockFace is marked non-null but is null");
        }
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        this.item = item;
        this.player = player;
        this.action = action;
        this.blockFace = blockFace;
        this.mainHand = mainHand;
        this.block = block;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

