/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.block.event;

import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.divinecraft.customstuff.api.block.CustomBlock;

public final class CustomBlockClickEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private boolean cancelled = false;
    @NotNull
    private final CustomBlock block;
    @NotNull
    private final Player player;
    @NotNull
    private final Action action;
    @NotNull
    private final BlockFace blockFace;
    private final boolean mainHand;
    @Nullable
    private final ItemStack item;

    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @NotNull
    public CustomBlock getBlock() {
        return this.block;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @NotNull
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public boolean isMainHand() {
        return this.mainHand;
    }

    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    public String toString() {
        return "CustomBlockClickEvent(cancelled=" + this.isCancelled() + ", block=" + this.getBlock() + ", player=" + this.getPlayer() + ", action=" + this.getAction() + ", blockFace=" + this.getBlockFace() + ", mainHand=" + this.isMainHand() + ", item=" + this.getItem() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomBlockClickEvent)) {
            return false;
        }
        CustomBlockClickEvent other = (CustomBlockClickEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        if (this.isMainHand() != other.isMainHand()) {
            return false;
        }
        CustomBlock this$block = this.getBlock();
        CustomBlock other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        BlockFace this$blockFace = this.getBlockFace();
        BlockFace other$blockFace = other.getBlockFace();
        if (this$blockFace == null ? other$blockFace != null : !this$blockFace.equals(other$blockFace)) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !this$item.equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomBlockClickEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        result = result * 59 + (this.isMainHand() ? 79 : 97);
        CustomBlock $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        BlockFace $blockFace = this.getBlockFace();
        result = result * 59 + ($blockFace == null ? 43 : $blockFace.hashCode());
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        return result;
    }

    public CustomBlockClickEvent(@NotNull CustomBlock block, @NotNull Player player, @NotNull Action action, @NotNull BlockFace blockFace, boolean mainHand, @Nullable ItemStack item) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (blockFace == null) {
            throw new NullPointerException("blockFace is marked non-null but is null");
        }
        this.block = block;
        this.player = player;
        this.action = action;
        this.blockFace = blockFace;
        this.mainHand = mainHand;
        this.item = item;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

