/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.block;

import java.util.Enumeration;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ru.divinecraft.customstuff.api.block.manager.CustomBlockManager;
import ru.divinecraft.customstuff.api.block.manager.LoadingCustomBlockManager;
import ru.divinecraft.customstuff.api.service.CustomStuff;
import ru.divinecraft.customstuff.api.service.CustomStuffDependantService;
import ru.divinecraft.customstuff.api.service.LoadingCustomStuff;

public interface CustomBlocks
extends CustomStuffDependantService {
    @NotNull
    public @NotNull Enumeration<@NotNull CustomBlockRegistration> registrations();

    public static void register(@NonNull CustomBlocks customBlocks, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull PendingService.OwnedService<@NotNull LoadingCustomStuff.PreLoaders, @NotNull CustomStuff> loadingCustomStuff) {
        if (customBlocks == null) {
            throw new NullPointerException("customBlocks is marked non-null but is null");
        }
        if (loadingCustomStuff == null) {
            throw new NullPointerException("loadingCustomStuff is marked non-null but is null");
        }
        Enumeration<CustomBlockRegistration> registrations = customBlocks.registrations();
        LoadingCustomBlockManager manager = ((LoadingCustomStuff.PreLoaders)loadingCustomStuff.service()).blockManager();
        while (registrations.hasMoreElements()) {
            CustomBlockRegistration registration = registrations.nextElement();
            manager.registerCustomBlock(registration.name(), registration.blockFactory());
        }
        loadingCustomStuff.onceReady(customBlocks::setup);
    }

    public static final class SimpleCustomBlockRegistration
    implements CustomBlockRegistration {
        @NonNull
        private final String name;
        @NonNull
        private final CustomBlockManager.BlockFactory blockFactory;

        @NotNull
        public static CustomBlockRegistration of(@NonNull String name, @NonNull CustomBlockManager.BlockFactory blockFactory) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (blockFactory == null) {
                throw new NullPointerException("blockFactory is marked non-null but is null");
            }
            return new SimpleCustomBlockRegistration(name, blockFactory);
        }

        @Override
        @NonNull
        public String name() {
            return this.name;
        }

        @Override
        @NonNull
        public CustomBlockManager.BlockFactory blockFactory() {
            return this.blockFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleCustomBlockRegistration)) {
                return false;
            }
            SimpleCustomBlockRegistration other = (SimpleCustomBlockRegistration)o;
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            CustomBlockManager.BlockFactory this$blockFactory = this.blockFactory();
            CustomBlockManager.BlockFactory other$blockFactory = other.blockFactory();
            return !(this$blockFactory == null ? other$blockFactory != null : !this$blockFactory.equals(other$blockFactory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            CustomBlockManager.BlockFactory $blockFactory = this.blockFactory();
            result = result * 59 + ($blockFactory == null ? 43 : $blockFactory.hashCode());
            return result;
        }

        public String toString() {
            return "CustomBlocks.SimpleCustomBlockRegistration(name=" + this.name() + ", blockFactory=" + this.blockFactory() + ")";
        }

        private SimpleCustomBlockRegistration(@NonNull String name, @NonNull CustomBlockManager.BlockFactory blockFactory) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (blockFactory == null) {
                throw new NullPointerException("blockFactory is marked non-null but is null");
            }
            this.name = name;
            this.blockFactory = blockFactory;
        }
    }

    public static interface CustomBlockRegistration {
        @Contract(pure=true)
        @NotNull
        public String name();

        @Contract(pure=true)
        @NotNull
        public CustomBlockManager.BlockFactory blockFactory();
    }
}

