/*
 * Decompiled with CFR 0.152.
 */
package ru.digipeople.database.room.repository;

import android.arch.persistence.db.SimpleSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.room.RoomDatabase;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.digipeople.database.model.ModelWithId;
import ru.digipeople.database.repository.ModelRepository;
import ru.digipeople.database.room.dao.BaseDao;
import ru.digipeople.database.room.entity.EntityWithId;
import ru.digipeople.database.room.mapper.BaseMapper;
import ru.digipeople.database.room.repository.RepositoryImpl;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u0005*\u0004\b\u0002\u0010\u00032\u00020\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0007B\u000f\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\u0017\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010$\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010)\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\u0015\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006+"}, d2={"Lru/digipeople/database/room/repository/ModelRepositoryImpl;", "Model", "Lru/digipeople/database/model/ModelWithId;", "Id", "Entity", "Lru/digipeople/database/room/entity/EntityWithId;", "Lru/digipeople/database/room/repository/RepositoryImpl;", "Lru/digipeople/database/repository/ModelRepository;", "roomDb", "Landroid/arch/persistence/room/RoomDatabase;", "(Landroid/arch/persistence/room/RoomDatabase;)V", "dao", "Lru/digipeople/database/room/dao/BaseDao;", "getDao", "()Lru/digipeople/database/room/dao/BaseDao;", "idColumnName", "", "getIdColumnName", "()Ljava/lang/String;", "mapper", "Lru/digipeople/database/room/mapper/BaseMapper;", "getMapper", "()Lru/digipeople/database/room/mapper/BaseMapper;", "tableName", "getTableName", "tableName$delegate", "Lkotlin/Lazy;", "delete", "", "model", "(Lru/digipeople/database/model/ModelWithId;)V", "models", "", "deleteAll", "exists", "", "id", "(Ljava/lang/Object;)Z", "getAll", "getById", "(Ljava/lang/Object;)Lru/digipeople/database/model/ModelWithId;", "insert", "update", "room_release"})
public abstract class ModelRepositoryImpl<Model extends ModelWithId<Id>, Entity extends EntityWithId<Id>, Id>
extends RepositoryImpl
implements ModelRepository<Model, Id> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy tableName$delegate;
    @NotNull
    private final String idColumnName = "id";

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ModelRepositoryImpl.class), "tableName", "getTableName()Ljava/lang/String;"))};
    }

    @NotNull
    public String getTableName() {
        Lazy lazy = this.tableName$delegate;
        ModelRepositoryImpl modelRepositoryImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    @NotNull
    public String getIdColumnName() {
        return this.idColumnName;
    }

    @NotNull
    public abstract BaseDao<Entity> getDao();

    @NotNull
    public abstract BaseMapper<Model, Entity> getMapper();

    @Override
    @Nullable
    public Model getById(Id id) {
        Object[] objectArray = new Object[1];
        Id Id = id;
        if (Id == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        objectArray[0] = Id;
        SimpleSQLiteQuery query = new SimpleSQLiteQuery("SELECT * FROM " + this.getTableName() + " WHERE " + this.getIdColumnName() + " = ?", objectArray);
        EntityWithId entity = (EntityWithId)this.getDao().getSingle((SupportSQLiteQuery)query);
        return (Model)((ModelWithId)this.getMapper().entityToModel(entity));
    }

    @Override
    @NotNull
    public List<Model> getAll() {
        SimpleSQLiteQuery query = new SimpleSQLiteQuery("SELECT * FROM " + this.getTableName());
        List<Entity> entities = this.getDao().getList((SupportSQLiteQuery)query);
        List<Model> list = this.getMapper().entityListToModelList(entities);
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @Override
    public void insert(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        EntityWithId entity = (EntityWithId)this.getMapper().modelToEntity(model);
        BaseDao<EntityWithId> baseDao = this.getDao();
        EntityWithId entityWithId = entity;
        if (entityWithId == null) {
            Intrinsics.throwNpe();
        }
        baseDao.insert(entityWithId);
    }

    @Override
    public void insert(@NotNull List<? extends Model> models) {
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        List<Entity> entities = this.getMapper().modelListToEntityList(models);
        BaseDao<Entity> baseDao = this.getDao();
        List<Entity> list = entities;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        baseDao.insert(list);
    }

    @Override
    public void update(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        BaseDao<Entity> baseDao = this.getDao();
        Entity Entity = this.getMapper().modelToEntity(model);
        if (Entity == null) {
            Intrinsics.throwNpe();
        }
        baseDao.update(Entity);
    }

    @Override
    public void delete(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        BaseDao<Entity> baseDao = this.getDao();
        Entity Entity = this.getMapper().modelToEntity(model);
        if (Entity == null) {
            Intrinsics.throwNpe();
        }
        baseDao.delete(Entity);
    }

    @Override
    public void delete(@NotNull List<? extends Model> models) {
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        List<Entity> entities = this.getMapper().modelListToEntityList(models);
        BaseDao<Entity> baseDao = this.getDao();
        List<Entity> list = entities;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        baseDao.delete(list);
    }

    @Override
    public void deleteAll() {
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.getRoomDb().getOpenHelper();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"roomDb.openHelper");
        supportSQLiteOpenHelper.getWritableDatabase().execSQL("DELETE FROM " + this.getTableName());
    }

    @Override
    public boolean exists(Id id) {
        Object[] objectArray = new Object[1];
        Id Id = id;
        if (Id == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        objectArray[0] = Id;
        SimpleSQLiteQuery query = new SimpleSQLiteQuery("SELECT EXISTS(SELECT * FROM " + this.getTableName() + " WHERE " + this.getIdColumnName() + " = ?)", objectArray);
        return this.getDao().getBoolean((SupportSQLiteQuery)query);
    }

    protected ModelRepositoryImpl(@NotNull RoomDatabase roomDb) {
        Intrinsics.checkParameterIsNotNull((Object)roomDb, (String)"roomDb");
        super(roomDb);
        this.tableName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ModelRepositoryImpl this$0;

            @NotNull
            public final String invoke() {
                String className;
                String string = className = this.this$0.getDao().getClass().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                String string2 = string;
                int n = 0;
                int n2 = className.length() - "Dao_Impl".length();
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string4;
            }
            {
                this.this$0 = modelRepositoryImpl;
                super(0);
            }
        }));
        this.idColumnName = "id";
    }
}

