/*
 * Decompiled with CFR 0.152.
 */
package ru.digipeople.database.room.repository;

import android.arch.persistence.room.RoomDatabase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.digipeople.database.model.ModelWithId;
import ru.digipeople.database.repository.ModelRepository;
import ru.digipeople.database.room.dao.BaseDao;
import ru.digipeople.database.room.entity.EntityWithId;
import ru.digipeople.database.room.mapper.BaseMapper;
import ru.digipeople.database.room.repository.RepositoryImpl;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u0005*\u0004\b\u0002\u0010\u00032\u00020\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0007B\u000f\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0019\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lru/digipeople/database/room/repository/ModelRepositoryImpl;", "Model", "Lru/digipeople/database/model/ModelWithId;", "Id", "Entity", "Lru/digipeople/database/room/entity/EntityWithId;", "Lru/digipeople/database/room/repository/RepositoryImpl;", "Lru/digipeople/database/repository/ModelRepository;", "appDatabase", "Landroid/arch/persistence/room/RoomDatabase;", "(Landroid/arch/persistence/room/RoomDatabase;)V", "dao", "Lru/digipeople/database/room/dao/BaseDao;", "getDao", "()Lru/digipeople/database/room/dao/BaseDao;", "mapper", "Lru/digipeople/database/room/mapper/BaseMapper;", "getMapper", "()Lru/digipeople/database/room/mapper/BaseMapper;", "delete", "", "model", "(Lru/digipeople/database/model/ModelWithId;)V", "models", "", "insert", "loadById", "id", "(Ljava/lang/Object;)Lru/digipeople/database/model/ModelWithId;", "update", "room_release"})
public abstract class ModelRepositoryImpl<Model extends ModelWithId<Id>, Entity extends EntityWithId<Id>, Id>
extends RepositoryImpl
implements ModelRepository<Model, Id> {
    @NotNull
    public abstract BaseDao<Entity> getDao();

    @NotNull
    public abstract BaseMapper<Model, Entity> getMapper();

    @NotNull
    public abstract Model loadById(Id var1);

    @Override
    public void insert(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        EntityWithId entity = (EntityWithId)this.getMapper().modelToEntity(model);
        BaseDao<EntityWithId> baseDao = this.getDao();
        EntityWithId entityWithId = entity;
        if (entityWithId == null) {
            Intrinsics.throwNpe();
        }
        baseDao.insert(entityWithId);
    }

    @Override
    public void insert(@NotNull List<? extends Model> models) {
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        List<Entity> entities = this.getMapper().modelListToEntityList(models);
        BaseDao<Entity> baseDao = this.getDao();
        List<Entity> list = entities;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        baseDao.insert(list);
    }

    @Override
    public void update(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        BaseDao<Entity> baseDao = this.getDao();
        Entity Entity = this.getMapper().modelToEntity(model);
        if (Entity == null) {
            Intrinsics.throwNpe();
        }
        baseDao.update(Entity);
    }

    @Override
    public void delete(@NotNull Model model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        BaseDao<Entity> baseDao = this.getDao();
        Entity Entity = this.getMapper().modelToEntity(model);
        if (Entity == null) {
            Intrinsics.throwNpe();
        }
        baseDao.delete(Entity);
    }

    @Override
    public void delete(@NotNull List<? extends Model> models) {
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        List<Entity> entities = this.getMapper().modelListToEntityList(models);
        BaseDao<Entity> baseDao = this.getDao();
        List<Entity> list = entities;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        baseDao.delete(list);
    }

    protected ModelRepositoryImpl(@NotNull RoomDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)appDatabase, (String)"appDatabase");
        super(appDatabase);
    }
}

