/*
 * Decompiled with CFR 0.152.
 */
package ru.bullyboo.text_animation;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.widget.TextView;
import java.text.DecimalFormat;
import ru.bullyboo.text_animation.AlphaBuilder;
import ru.bullyboo.text_animation.AnimationBuilder;
import ru.bullyboo.text_animation.ModeConstructor;
import ru.bullyboo.text_animation.exeptions.BuilderDataException;

public class TextCounter {
    public static final int LINEAR_MODE = 1;
    public static final int LINEAR_ACCELERATION_MODE = 2;
    public static final int LINEAR_DECELERATION_MODE = 3;
    public static final int DECELERATION_MODE = 4;
    public static final int DECELERATION_LINEAR_MODE = 5;
    public static final int DECELERATION_ACCELERATION_MODE = 6;
    public static final int ACCELERATION_MODE = 7;
    public static final int ACCELERATION_LINEAR_MODE = 8;
    public static final int ACCELERATION_DECELERATION_MODE = 9;
    public static final int LINEAR_TO_ALPHA_MODE = 10;
    public static final int LINEAR_FROM_ALPHA_MODE = 11;
    public static final int DECELERATION_TO_ALPHA_MODE = 12;
    public static final int DECELERATION_FROM_ALPHA_MODE = 13;
    public static final int ACCELERATION_TO_ALPHA_MODE = 14;
    public static final int ACCELERATION_FROM_ALPHA_MODE = 15;
    public static final int CUSTOM_MODE = 16;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    private TextView textView;
    private Double from;
    private Double to;
    private String prefix = "";
    private String postfix = "";
    private int autoType;
    private int userType;
    private int type;
    private int mode = 1;
    private long duration;
    private Double step;
    private int fps = 60;
    private Integer fromFps;
    private Integer toFps;
    private int[] fpsDynamic;
    private int[] userFpsDynamic;
    private float alpha = 1.0f;
    private Float fromAlpha;
    private Float toAlpha;
    private float[] alphaDynamic;
    private float[] userAlphaDynamic;
    private AnimationBuilder partList;
    private Double currentNumber;
    private double targetNumber;
    private DecimalFormat decimalFormat;
    private boolean isAnimate = false;
    private TextCounterListener listener;
    private int frame;
    private Runnable changeText = new Runnable(){

        @Override
        public void run() {
            TextCounter.this.currentNumber = TextCounter.this.currentNumber + TextCounter.this.step;
            if (TextCounter.this.alphaDynamic != null) {
                TextCounter.this.textView.setAlpha(TextCounter.this.alphaDynamic[TextCounter.this.frame]);
            }
            if (TextCounter.this.frame + 1 < TextCounter.this.fpsDynamic.length) {
                TextCounter.this.frame++;
            }
            String roundedDouble = TextCounter.this.decimalFormat.format(TextCounter.this.currentNumber);
            roundedDouble = roundedDouble.replace(",", ".");
            TextCounter.this.changeText(roundedDouble);
            if (TextCounter.this.step > 0.0) {
                if (TextCounter.this.currentNumber < TextCounter.this.targetNumber) {
                    TextCounter.this.timer();
                } else {
                    TextCounter.this.lastTextUpdate();
                    TextCounter.this.isAnimate = false;
                }
            } else if (TextCounter.this.step < 0.0) {
                if (TextCounter.this.currentNumber > TextCounter.this.targetNumber) {
                    TextCounter.this.timer();
                } else {
                    TextCounter.this.lastTextUpdate();
                    TextCounter.this.isAnimate = false;
                }
            }
        }
    };

    private TextCounter() {
    }

    public static Builder newBuilder() {
        TextCounter textCounter = new TextCounter();
        textCounter.getClass();
        return textCounter.new Builder();
    }

    public void start() {
        if (!this.isAnimate) {
            this.isAnimate = true;
            this.frame = 0;
            this.init();
            this.timer();
        }
    }

    private void init() {
        long amountFrames = this.fpsDynamic.length + 1;
        this.currentNumber = this.from;
        this.targetNumber = this.to;
        this.step = this.to - this.from;
        this.step = this.step / (double)amountFrames;
    }

    private void timer() {
        new Handler().postDelayed(this.changeText, (long)this.fpsDynamic[this.frame]);
    }

    private void changeText(String current) {
        switch (this.type) {
            case 1: {
                this.textView.setText((CharSequence)(this.prefix + this.currentNumber.byteValue() + this.postfix));
                break;
            }
            case 2: {
                this.textView.setText((CharSequence)(this.prefix + this.currentNumber.shortValue() + this.postfix));
                break;
            }
            case 3: {
                this.textView.setText((CharSequence)(this.prefix + this.currentNumber.intValue() + this.postfix));
                break;
            }
            case 4: {
                this.textView.setText((CharSequence)(this.prefix + current + this.postfix));
                break;
            }
            case 5: {
                this.textView.setText((CharSequence)(this.prefix + this.currentNumber.longValue() + this.postfix));
                break;
            }
            case 6: {
                this.textView.setText((CharSequence)(this.prefix + current + this.postfix));
                break;
            }
            default: {
                return;
            }
        }
    }

    private void lastTextUpdate() {
        switch (this.type) {
            case 1: {
                this.textView.setText((CharSequence)(this.prefix + this.to.byteValue() + this.postfix));
                break;
            }
            case 2: {
                this.textView.setText((CharSequence)(this.prefix + this.to.shortValue() + this.postfix));
                break;
            }
            case 3: {
                this.textView.setText((CharSequence)(this.prefix + this.to.intValue() + this.postfix));
                break;
            }
            case 4: {
                this.textView.setText((CharSequence)(this.prefix + this.decimalFormat.format(this.to.floatValue()).replace(",", ".") + this.postfix));
                break;
            }
            case 5: {
                this.textView.setText((CharSequence)(this.prefix + this.to.longValue() + this.postfix));
                break;
            }
            case 6: {
                this.textView.setText((CharSequence)(this.prefix + this.decimalFormat.format(this.to).replace(",", ".") + this.postfix));
                break;
            }
            default: {
                return;
            }
        }
        if (this.listener != null) {
            this.listener.onEnd();
        }
    }

    static /* synthetic */ int[] access$2202(TextCounter x0, int[] x1) {
        x0.userFpsDynamic = x1;
        return x1;
    }

    static /* synthetic */ float[] access$2702(TextCounter x0, float[] x1) {
        x0.userAlphaDynamic = x1;
        return x1;
    }

    static /* synthetic */ int[] access$602(TextCounter x0, int[] x1) {
        x0.fpsDynamic = x1;
        return x1;
    }

    static /* synthetic */ float[] access$302(TextCounter x0, float[] x1) {
        x0.alphaDynamic = x1;
        return x1;
    }

    public static @interface Mode {
    }

    public static @interface Type {
    }

    public class Builder {
        private Builder() {
        }

        public Builder setTextView(@NonNull TextView textView) {
            TextCounter.this.textView = textView;
            return this;
        }

        public Builder from(byte fromByte) {
            TextCounter.this.from = Double.valueOf(fromByte);
            TextCounter.this.autoType = 1;
            return this;
        }

        public Builder to(byte toByte) {
            TextCounter.this.to = Double.valueOf(toByte);
            TextCounter.this.autoType = 1;
            return this;
        }

        public Builder from(short fromShort) {
            TextCounter.this.from = Double.valueOf(fromShort);
            TextCounter.this.autoType = 2;
            return this;
        }

        public Builder to(short toShort) {
            TextCounter.this.to = Double.valueOf(toShort);
            TextCounter.this.autoType = 2;
            return this;
        }

        public Builder from(int fromInt) {
            TextCounter.this.from = Double.valueOf(fromInt);
            TextCounter.this.autoType = 3;
            return this;
        }

        public Builder to(int toInt) {
            TextCounter.this.to = Double.valueOf(toInt);
            TextCounter.this.autoType = 3;
            return this;
        }

        public Builder from(float fromFloat) {
            TextCounter.this.from = Double.valueOf(fromFloat);
            TextCounter.this.autoType = 4;
            return this;
        }

        public Builder to(float toFloat) {
            TextCounter.this.to = Double.valueOf(toFloat);
            TextCounter.this.autoType = 4;
            return this;
        }

        public Builder from(long fromLong) {
            TextCounter.this.from = Double.valueOf(fromLong);
            TextCounter.this.autoType = 5;
            return this;
        }

        public Builder to(long toLong) {
            TextCounter.this.to = Double.valueOf(toLong);
            TextCounter.this.autoType = 5;
            return this;
        }

        public Builder from(double fromDouble) {
            TextCounter.this.from = fromDouble;
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder to(double toDouble) {
            TextCounter.this.to = toDouble;
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder from(Byte fromByte) {
            TextCounter.this.from = (double)fromByte;
            TextCounter.this.autoType = 1;
            return this;
        }

        public Builder to(Byte toByte) {
            TextCounter.this.to = (double)toByte;
            TextCounter.this.autoType = 1;
            return this;
        }

        public Builder from(Short fromShort) {
            TextCounter.this.from = (double)fromShort;
            TextCounter.this.autoType = 2;
            return this;
        }

        public Builder to(Short toShort) {
            TextCounter.this.to = (double)toShort;
            TextCounter.this.autoType = 2;
            return this;
        }

        public Builder from(Integer fromInt) {
            TextCounter.this.from = (double)fromInt;
            TextCounter.this.autoType = 3;
            return this;
        }

        public Builder to(Integer toInt) {
            TextCounter.this.to = (double)toInt;
            TextCounter.this.autoType = 3;
            return this;
        }

        public Builder from(Float fromFloat) {
            TextCounter.this.from = Double.valueOf(fromFloat.floatValue());
            TextCounter.this.autoType = 4;
            return this;
        }

        public Builder to(Float toFloat) {
            TextCounter.this.to = Double.valueOf(toFloat.floatValue());
            TextCounter.this.autoType = 4;
            return this;
        }

        public Builder from(Long fromLong) {
            TextCounter.this.from = (double)fromLong;
            TextCounter.this.autoType = 5;
            return this;
        }

        public Builder to(Long toLong) {
            TextCounter.this.to = (double)toLong;
            TextCounter.this.autoType = 5;
            return this;
        }

        public Builder from(Double fromDouble) {
            TextCounter.this.from = fromDouble;
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder to(Double toDouble) {
            TextCounter.this.to = toDouble;
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder from(String fromDouble) {
            TextCounter.this.from = this.parseStringToDigitFrom(fromDouble);
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder to(String toDouble) {
            TextCounter.this.to = this.parseStringToDigitTo(toDouble);
            TextCounter.this.autoType = 6;
            return this;
        }

        public Builder setPrefix(String prefix) {
            TextCounter.this.prefix = prefix;
            return this;
        }

        public Builder setType(@Type int type) {
            TextCounter.this.userType = type;
            return this;
        }

        public Builder setPostfix(String postfix) {
            TextCounter.this.postfix = postfix;
            return this;
        }

        public Builder setDuration(long millis) {
            TextCounter.this.duration = millis;
            return this;
        }

        public Builder setFPS(int fps) {
            TextCounter.this.fps = fps;
            return this;
        }

        public Builder setMode(@Mode int mode) {
            TextCounter.this.mode = mode;
            return this;
        }

        public Builder setFpsDynamic(int[] dynamic) {
            TextCounter.access$2202(TextCounter.this, dynamic);
            return this;
        }

        public Builder setRound(int round) {
            TextCounter.this.decimalFormat = new DecimalFormat(this.getRoundPattern(round));
            return this;
        }

        public Builder setDecimalFormat(DecimalFormat decimalFormat) {
            TextCounter.this.decimalFormat = decimalFormat;
            return this;
        }

        public Builder setFromFps(int fromFps) {
            TextCounter.this.fromFps = fromFps;
            return this;
        }

        public Builder setToFps(int toFps) {
            TextCounter.this.toFps = toFps;
            return this;
        }

        public Builder setFromAlpha(float fromAlpha) {
            TextCounter.this.fromAlpha = Float.valueOf(fromAlpha);
            return this;
        }

        public Builder setToAlpha(float toAlpha) {
            TextCounter.this.toAlpha = Float.valueOf(toAlpha);
            return this;
        }

        public Builder setAlphaDynamic(float[] alphaDynamic) {
            TextCounter.access$2702(TextCounter.this, TextCounter.this.userAlphaDynamic);
            return this;
        }

        public Builder setCustomAnimation(@NonNull AnimationBuilder partList) {
            TextCounter.this.partList = partList;
            return this;
        }

        public Builder setListener(TextCounterListener listener) {
            TextCounter.this.listener = listener;
            return this;
        }

        public TextCounter build() {
            ModeConstructor constuctor = this.buildFpsDynamic(new ModeConstructor());
            this.buildAlphaDynamic(constuctor);
            this.buildType();
            if (TextCounter.this.decimalFormat == null) {
                TextCounter.this.decimalFormat = new DecimalFormat(this.getRoundPattern(0));
            }
            try {
                this.checkData();
            }
            catch (BuilderDataException e) {
                e.printStackTrace();
                throw new NullPointerException("You didn`t set all the necessery data");
            }
            return TextCounter.this;
        }

        private double parseStringToDigitFrom(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        private double parseStringToDigitTo(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        private String getRoundPattern(int round) {
            StringBuilder roundPattern = new StringBuilder();
            roundPattern.append("#0");
            if (round < 0) {
                return null;
            }
            if (round > 0) {
                roundPattern.append(".");
                for (int i = 0; i < round; ++i) {
                    roundPattern.append("0");
                }
            }
            return roundPattern.toString();
        }

        private ModeConstructor buildFpsDynamic(ModeConstructor constuctor) {
            if (TextCounter.this.partList != null) {
                TextCounter.access$602(TextCounter.this, constuctor.buildFpsDynamic(TextCounter.this.partList.getFpsList()));
                return constuctor;
            }
            if (TextCounter.this.userFpsDynamic != null) {
                TextCounter.access$602(TextCounter.this, ModeConstructor.convertFpsToTimePause(TextCounter.this.userFpsDynamic));
                return constuctor;
            }
            if (TextCounter.this.fromFps != null && TextCounter.this.toFps != null) {
                TextCounter.access$602(TextCounter.this, constuctor.getModeFpsDynamic(TextCounter.this.mode, TextCounter.this.duration, TextCounter.this.fromFps, TextCounter.this.toFps));
                return constuctor;
            }
            if (TextCounter.this.fromFps == null && TextCounter.this.toFps == null) {
                TextCounter.access$602(TextCounter.this, constuctor.getModeFpsDynamic(TextCounter.this.mode, TextCounter.this.duration, TextCounter.this.fps));
                return constuctor;
            }
            try {
                if (TextCounter.this.fromFps == null && TextCounter.this.toFps != null) {
                    throw new BuilderDataException("Value of fromFps is null, when value of toFps is not null");
                }
                if (TextCounter.this.fromFps != null && TextCounter.this.toFps == null) {
                    throw new BuilderDataException("Value of toFps is null, when value of fromFps is not null");
                }
                throw new BuilderDataException("You didn`t set data of fps. Try to use setCustomAnimation(), or setFpsDynamic(), or setFromFps() with setToFps(), or setFps()");
            }
            catch (BuilderDataException e) {
                e.printStackTrace();
                return constuctor;
            }
        }

        private void buildAlphaDynamic(ModeConstructor constuctor) {
            if (TextCounter.this.partList != null) {
                TextCounter.access$302(TextCounter.this, constuctor.buildAlphaDynamic(TextCounter.this.partList.getFpsList()));
                if (TextCounter.this.alphaDynamic != null) {
                    return;
                }
            }
            if (TextCounter.this.userAlphaDynamic != null) {
                TextCounter.access$302(TextCounter.this, TextCounter.this.userAlphaDynamic);
                return;
            }
            if (TextCounter.this.fromAlpha != null && TextCounter.this.toAlpha != null) {
                AlphaBuilder alphaBuilder = AlphaBuilder.newInstance().fromAlpha(TextCounter.this.fromAlpha.floatValue()).toAlpha(TextCounter.this.toAlpha.floatValue());
                TextCounter.access$302(TextCounter.this, alphaBuilder.createAlphaDynamic(TextCounter.this.fpsDynamic.length));
                return;
            }
            if (TextCounter.this.mode >= 10 && TextCounter.this.mode <= 15) {
                TextCounter.access$302(TextCounter.this, constuctor.getAlphaDynamic());
                return;
            }
            if (TextCounter.this.fromAlpha == null && TextCounter.this.toAlpha == null) {
                AlphaBuilder alphaBuilder = AlphaBuilder.newInstance().fromAlpha(TextCounter.this.alpha).toAlpha(TextCounter.this.alpha);
                TextCounter.access$302(TextCounter.this, alphaBuilder.createAlphaDynamic(TextCounter.this.fpsDynamic.length));
                return;
            }
            try {
                if (TextCounter.this.fromAlpha == null && TextCounter.this.toAlpha != null) {
                    throw new BuilderDataException("Value of fromAlpha is null, when value of toAlpha is not null");
                }
                if (TextCounter.this.fromAlpha != null && TextCounter.this.toAlpha == null) {
                    throw new BuilderDataException("Value of toAlpha is null, when value of fromAlpha is not null");
                }
                throw new BuilderDataException("You didn`t set data of alpha. Try to use setFromAlpha() and setToAlpha(), or setAlphaDynamic(), or set alpha in setCustomAnimation()");
            }
            catch (BuilderDataException e) {
                e.printStackTrace();
                return;
            }
        }

        private void buildType() {
            if (TextCounter.this.userType == 0) {
                TextCounter.this.type = TextCounter.this.autoType;
            } else {
                TextCounter.this.type = TextCounter.this.userType;
            }
        }

        private void checkData() throws BuilderDataException {
            if (TextCounter.this.duration == 0L && TextCounter.this.partList == null) {
                throw new BuilderDataException("You didn`t set duration");
            }
            if (TextCounter.this.textView == null) {
                throw new BuilderDataException("You didn`t set TextView object");
            }
            if (TextCounter.this.from == null && TextCounter.this.to == null) {
                throw new BuilderDataException("You didn`t set from and to numeric");
            }
        }
    }

    public static interface TextCounterListener {
        public void onEnd();
    }
}

