/*
 * Decompiled with CFR 0.152.
 */
package ru.bullyboo.text_animation;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import ru.bullyboo.text_animation.AlphaBuilder;
import ru.bullyboo.text_animation.AnimationBuilder;
import ru.bullyboo.text_animation.Part;

class ModeConstructor {
    private float[] alphaDynamic;

    ModeConstructor() {
    }

    public float[] getAlphaDynamic() {
        return this.alphaDynamic;
    }

    protected int[] getModeFpsDynamic(int mode, long duration, Integer fps) {
        return this.getModeFpsDynamic(mode, duration, fps, null);
    }

    protected int[] getModeFpsDynamic(int mode, long duration, Integer fromFps, Integer toFps) {
        AlphaBuilder fromAlpha = AlphaBuilder.newInstance().fromAlpha(0.0f).toAlpha(1.0f);
        AlphaBuilder toAlpha = AlphaBuilder.newInstance().fromAlpha(1.0f).toAlpha(0.0f);
        switch (mode) {
            case 1: {
                return this.getFpsDynamicLinear(duration, fromFps);
            }
            case 2: {
                return this.getFpsDynamicLinearAcceleration(duration, fromFps);
            }
            case 3: {
                return this.getFpsDynamicLinearDeceleration(duration, fromFps);
            }
            case 4: {
                if (toFps != null) {
                    return this.getFpsDynamicDeceleration(duration, fromFps, toFps);
                }
                return this.getFpsDynamicDeceleration(duration, fromFps);
            }
            case 5: {
                return this.getFpsDynamicDecelerationLinear(duration, fromFps);
            }
            case 6: {
                return this.getFpsDynamicDecelerationAcceleration(duration, fromFps);
            }
            case 7: {
                if (toFps != null) {
                    return this.getFpsDynamicAcceleration(duration, fromFps, toFps);
                }
                return this.getFpsDynamicAcceleration(duration, fromFps);
            }
            case 8: {
                return this.getFpsDynamicAccelerationLinear(duration, fromFps);
            }
            case 9: {
                return this.getFpsDynamicAccelerationDeceleration(duration, fromFps);
            }
            case 10: {
                int[] linearToAlpha = this.getFpsDynamicLinear(duration, fromFps);
                this.alphaDynamic = toAlpha.createAlphaDynamic(linearToAlpha.length);
                return linearToAlpha;
            }
            case 11: {
                int[] linearFromAlpha = this.getFpsDynamicLinear(duration, fromFps);
                this.alphaDynamic = fromAlpha.createAlphaDynamic(linearFromAlpha.length);
                return linearFromAlpha;
            }
            case 12: {
                int[] decToAlpha = this.getFpsDynamicDeceleration(duration, fromFps);
                this.alphaDynamic = toAlpha.createAlphaDynamic(decToAlpha.length);
                return decToAlpha;
            }
            case 13: {
                int[] decFromAlpha = this.getFpsDynamicDeceleration(duration, fromFps);
                this.alphaDynamic = fromAlpha.createAlphaDynamic(decFromAlpha.length);
                return decFromAlpha;
            }
            case 14: {
                int[] accToAlpha = this.getFpsDynamicAcceleration(duration, fromFps);
                this.alphaDynamic = toAlpha.createAlphaDynamic(accToAlpha.length);
                return accToAlpha;
            }
            case 15: {
                int[] accFromAlpha = this.getFpsDynamicAcceleration(duration, fromFps);
                this.alphaDynamic = fromAlpha.createAlphaDynamic(accFromAlpha.length);
                return accFromAlpha;
            }
            case 16: {
                return this.getCustomDynamic(duration, fromFps, toFps);
            }
        }
        return this.getFpsDynamicLinear(duration, fromFps);
    }

    protected int[] buildFpsDynamic(@NonNull List<Part> list) {
        return this.getFpsDynamic(list);
    }

    protected float[] buildAlphaDynamic(@NonNull List<Part> list) {
        return this.getAlphaDynamic(list);
    }

    public int[] getFpsDynamicLinear(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fps, fps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicDeceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fps, fps - fps * 9 / 10).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicDeceleration(long duration, int fromFps, int toFps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fromFps, toFps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicAcceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fps - fps * 9 / 10, fps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicAcceleration(long duration, int fromFps, int toFps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fromFps, toFps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicLinearAcceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration / 4L, fps / 4, fps / 4).addPart(duration * 3L / 4L, fps / 4, fps + fps * 19 / 20).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicLinearDeceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration / 3L, fps, fps).addPart(duration * 2L / 3L, fps, fps - fps * 9 / 10).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicAccelerationLinear(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration * 2L / 3L, fps - fps * 9 / 10, fps).addPart(duration / 3L, fps, fps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicAccelerationDeceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration / 2L, fps - fps * 9 / 10, fps + fps * 9 / 10).addPart(duration / 2L, fps + fps * 9 / 10, fps - fps * 9 / 10).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicDecelerationLinear(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration * 2L / 3L, fps + fps * 9 / 10, fps / 2).addPart(duration / 3L, fps / 2, fps / 2).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getFpsDynamicDecelerationAcceleration(long duration, int fps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration / 2L, fps + fps * 9 / 10, fps - fps * 9 / 10).addPart(duration / 2L, fps - fps * 9 / 10, fps + fps * 9 / 10).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    public int[] getCustomDynamic(long duration, int fromFps, int toFps) {
        List<Part> fpsList = AnimationBuilder.newBuilder().addPart(duration, fromFps, toFps).build().getFpsList();
        return this.getFpsDynamic(fpsList);
    }

    private int[] getFpsDynamic(List<Part> fpsList) {
        ArrayList<int[]> arrays = new ArrayList<int[]>();
        for (Part part : fpsList) {
            int[] onePart = this.getFpsDynamicOfPart(part.getDuration(), part.getFromFps(), part.getToFps());
            part.setAmountFrames(onePart.length);
            arrays.add(onePart);
        }
        return ModeConstructor.convertFpsToTimePause(this.unitIntArrays(arrays));
    }

    private int[] getFpsDynamicOfPart(long duration, int fromFps, int toFps) {
        int[] fpsDynamic = this.countTimePauses(duration, fromFps, toFps);
        fpsDynamic = ModeConstructor.convertTimePauseToFps(fpsDynamic);
        return fpsDynamic;
    }

    private float[] getAlphaDynamic(List<Part> fpsList) {
        ArrayList<float[]> arrays = new ArrayList<float[]>();
        boolean hasAlphaData = false;
        for (Part part : fpsList) {
            if (part.getAlphaDynamic() == null) continue;
            hasAlphaData = true;
            break;
        }
        if (!hasAlphaData) {
            return null;
        }
        for (Part part : fpsList) {
            if (part.getAlphaDynamic() == null) {
                AlphaBuilder alphaBuilder = AlphaBuilder.newInstance().fromAlpha(1.0f).toAlpha(1.0f);
                arrays.add(alphaBuilder.createAlphaDynamic(part.getAmountFrames()));
                continue;
            }
            arrays.add(part.getAlphaDynamic().createAlphaDynamic(part.getAmountFrames()));
        }
        return this.unitFloatArrays(arrays);
    }

    public static int convertFpsToTimePause(int fps) {
        return ModeConstructor.convert(fps);
    }

    public static int[] convertFpsToTimePause(int[] fpsArray) {
        for (int i = 0; i < fpsArray.length; ++i) {
            fpsArray[i] = ModeConstructor.convertFpsToTimePause(fpsArray[i]);
        }
        return fpsArray;
    }

    private static int convertTimePauseToFps(int timePause) {
        return ModeConstructor.convert(timePause);
    }

    private static int[] convertTimePauseToFps(int[] timePauses) {
        for (int i = 0; i < timePauses.length; ++i) {
            timePauses[i] = ModeConstructor.convertTimePauseToFps(timePauses[i]);
        }
        return timePauses;
    }

    private static int convert(int value) {
        return 1000 / value;
    }

    public int[] countTimePauses(long duration, int fromFps, int toFps) {
        int toTimePause;
        int fromTimePause = ModeConstructor.convertFpsToTimePause(fromFps);
        float midleTimePause = (fromTimePause + (toTimePause = ModeConstructor.convertFpsToTimePause(toFps))) / 2;
        int amountFrames = (int)((float)duration / midleTimePause);
        if (amountFrames == 0) {
            amountFrames = 1;
        }
        float stepFps = toTimePause - fromTimePause;
        stepFps /= (float)amountFrames;
        int[] timePause = new int[amountFrames];
        for (int i = 0; i < amountFrames; ++i) {
            timePause[i] = (int)((float)fromTimePause + stepFps * (float)i);
        }
        return timePause;
    }

    private int[] unitIntArrays(List<int[]> list) {
        int arraylenght = 0;
        for (int[] array : list) {
            arraylenght += array.length;
        }
        int[] unitArray = new int[arraylenght];
        int index = 0;
        for (int[] array : list) {
            for (int i = 0; i < array.length; ++i) {
                unitArray[index] = array[i];
                ++index;
            }
        }
        return unitArray;
    }

    private float[] unitFloatArrays(List<float[]> list) {
        int arraylenght = 0;
        for (float[] array : list) {
            arraylenght += array.length;
        }
        float[] unitArray = new float[arraylenght];
        int index = 0;
        for (float[] array : list) {
            for (int i = 0; i < array.length; ++i) {
                unitArray[index] = array[i];
                ++index;
            }
        }
        return unitArray;
    }
}

