/*
 * Decompiled with CFR 0.152.
 */
package ru.bullyboo.text_animation;

import java.util.ArrayList;
import java.util.List;
import ru.bullyboo.text_animation.AlphaBuilder;
import ru.bullyboo.text_animation.Part;
import ru.bullyboo.text_animation.exeptions.NullPartException;

public class AnimationBuilder {
    private List<Part> fpsList = new ArrayList<Part>();

    public static Builder newBuilder() {
        return new AnimationBuilder().new Builder();
    }

    private AnimationBuilder() {
    }

    protected List<Part> getFpsList() {
        return this.fpsList;
    }

    public class Builder {
        public Builder addPart(long duration, int fps) {
            AnimationBuilder.this.fpsList.add(new Part(duration, fps, fps));
            return this;
        }

        public Builder addPart(long duration, int fps, AlphaBuilder animator) {
            AnimationBuilder.this.fpsList.add(new Part(duration, fps, animator));
            return this;
        }

        public Builder addPart(long duration, int fromFps, int toFps) {
            AnimationBuilder.this.fpsList.add(new Part(duration, fromFps, toFps));
            return this;
        }

        public Builder addPart(long duration, int fromFps, int toFps, AlphaBuilder animator) {
            AnimationBuilder.this.fpsList.add(new Part(duration, fromFps, toFps, animator));
            return this;
        }

        public AnimationBuilder build() {
            if (AnimationBuilder.this.fpsList.size() > 0) {
                return AnimationBuilder.this;
            }
            try {
                throw new NullPartException("Didn`t find the parts on animation, try to use addPart() method");
            }
            catch (NullPartException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

