/*
 * Decompiled with CFR 0.152.
 */
package ru.bullyboo.text_animation;

public class AlphaBuilder {
    private float fromAlpha;
    private float toAlpha;

    public static AlphaBuilder newInstance() {
        return new AlphaBuilder();
    }

    private AlphaBuilder() {
    }

    public AlphaBuilder fromAlpha(float fromAlpha) {
        this.fromAlpha = fromAlpha;
        return this;
    }

    public AlphaBuilder toAlpha(float toAlpha) {
        this.toAlpha = toAlpha;
        return this;
    }

    protected float[] createAlphaDynamic(int arraySize) {
        if (arraySize == 0) {
            return null;
        }
        float[] alphaDynamic = new float[arraySize];
        float step = (this.toAlpha - this.fromAlpha) / (float)arraySize;
        for (int i = 0; i < arraySize; ++i) {
            alphaDynamic[i] = this.fromAlpha + step * (float)i;
        }
        alphaDynamic[0] = this.fromAlpha;
        alphaDynamic[arraySize - 1] = this.toAlpha;
        return alphaDynamic;
    }
}

