/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.utils;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sqlite.database.sqlite.SQLiteDatabase;
import ru.arturvasilov.sqlite.core.Table;

public final class TableBuilder {
    private String mTableName;
    private final List<String> mPrimaryKeys = new ArrayList<String>();
    private final List<String> mIntegerColumns = new ArrayList<String>();
    private final List<String> mRealColumns = new ArrayList<String>();
    private final List<String> mTextColumns = new ArrayList<String>();

    private TableBuilder() {
    }

    @NonNull
    public static TableBuilder create(@NonNull Table table) {
        TableBuilder builder = new TableBuilder();
        builder.mTableName = table.getTableName();
        return builder;
    }

    @NonNull
    public TableBuilder primaryKey(String ... keys) {
        this.mPrimaryKeys.clear();
        for (String key : keys) {
            if (this.mPrimaryKeys.contains(key)) continue;
            this.mPrimaryKeys.add(key);
        }
        return this;
    }

    @NonNull
    public TableBuilder intColumn(@NonNull String columnName) {
        if (!this.mIntegerColumns.contains(columnName)) {
            this.mIntegerColumns.add(columnName);
        }
        return this;
    }

    @NonNull
    public TableBuilder realColumn(@NonNull String columnName) {
        if (!this.mRealColumns.contains(columnName)) {
            this.mRealColumns.add(columnName);
        }
        return this;
    }

    @NonNull
    public TableBuilder textColumn(@NonNull String columnName) {
        if (!this.mTextColumns.contains(columnName)) {
            this.mTextColumns.add(columnName);
        }
        return this;
    }

    public void execute(@NonNull SQLiteDatabase database) {
        database.execSQL(this.buildSQL());
    }

    @VisibleForTesting
    String buildSQL() {
        Iterator<String> column;
        if (this.mIntegerColumns.isEmpty() && this.mRealColumns.isEmpty() && this.mTextColumns.isEmpty()) {
            throw new IllegalStateException("Cannot create table with no columns");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS ").append(this.mTableName).append("(");
        if (!this.mIntegerColumns.isEmpty()) {
            column = this.mIntegerColumns.remove(0);
            builder.append((String)((Object)column)).append(" INTEGER");
        } else if (!this.mRealColumns.isEmpty()) {
            column = this.mRealColumns.remove(0);
            builder.append((String)((Object)column)).append(" REAL");
        } else {
            column = this.mTextColumns.remove(0);
            builder.append((String)((Object)column)).append(" TEXT");
        }
        for (String column2 : this.mIntegerColumns) {
            builder.append(", ").append(column2).append(" INTEGER");
        }
        for (String column2 : this.mRealColumns) {
            builder.append(", ").append(column2).append(" REAL");
        }
        for (String column2 : this.mTextColumns) {
            builder.append(", ").append(column2).append(" TEXT");
        }
        if (!this.mPrimaryKeys.isEmpty()) {
            builder.append(", PRIMARY KEY (").append(this.mPrimaryKeys.get(0));
        }
        for (int i = 1; i < this.mPrimaryKeys.size(); ++i) {
            builder.append(", ").append(this.mPrimaryKeys.get(i));
        }
        if (!this.mPrimaryKeys.isEmpty()) {
            builder.append(")");
        }
        builder.append(");");
        return builder.toString();
    }
}

