/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import ru.arturvasilov.sqlite.core.BasicTableObserver;
import ru.arturvasilov.sqlite.core.ContentTableObserver;
import ru.arturvasilov.sqlite.core.Observers;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.Where;
import ru.arturvasilov.sqlite.utils.SQLiteUtils;

public class SQLite {
    private static SQLite sSQLite;
    private final Context mContext;
    private final Observers mObservers;
    private boolean mIsAutomaticNotificationsEnabled;

    private SQLite(@NonNull Context context) {
        this.mContext = context;
        this.mObservers = new Observers();
        this.mIsAutomaticNotificationsEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static SQLite initialize(@NonNull Context context) {
        SQLite sqLite = sSQLite;
        if (sqLite != null) return sqLite;
        Class<SQLite> clazz = SQLite.class;
        synchronized (SQLite.class) {
            sqLite = sSQLite;
            if (sqLite != null) return sqLite;
            sSQLite = new SQLite(context.getApplicationContext());
            return sSQLite;
        }
    }

    @NonNull
    public static SQLite get() {
        if (sSQLite == null) {
            throw new IllegalStateException("You should call initialize(Context) first, to initialize the database");
        }
        return sSQLite;
    }

    @NonNull
    public <T> List<T> query(@NonNull Table<T> table) {
        return this.query(table, Where.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T> List<T> query(@NonNull Table<T> table, @NonNull Where where) {
        ArrayList<T> list = new ArrayList<T>();
        Cursor cursor = this.mContext.getContentResolver().query(table.getUri(), null, where.where(), where.whereArgs(), null);
        try {
            if (SQLiteUtils.isEmptyCursor(cursor)) {
                ArrayList<T> arrayList = list;
                return arrayList;
            }
            do {
                T t = table.fromCursor(cursor);
                list.add(t);
            } while (cursor.moveToNext());
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            SQLiteUtils.safeCloseCursor(cursor);
        }
    }

    @Nullable
    public <T> T querySingle(@NonNull Table<T> table) {
        return this.querySingle(table, Where.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T querySingle(@NonNull Table<T> table, @NonNull Where where) {
        Cursor cursor = this.mContext.getContentResolver().query(table.getUri(), null, where.where(), where.whereArgs(), where.limit());
        try {
            if (SQLiteUtils.isEmptyCursor(cursor)) {
                T t = null;
                return t;
            }
            T t = table.fromCursor(cursor);
            return t;
        }
        finally {
            SQLiteUtils.safeCloseCursor(cursor);
        }
    }

    @Nullable
    public <T> Uri insert(@NonNull Table<T> table, @NonNull T object) {
        Uri uri = this.mContext.getContentResolver().insert(table.getUri(), table.toValues(object));
        if (uri != null && this.mIsAutomaticNotificationsEnabled) {
            this.notifyTableChanged(table);
        }
        return uri;
    }

    public <T> int insert(@NonNull Table<T> table, @NonNull List<T> objects) {
        ContentValues[] values = new ContentValues[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            values[i] = table.toValues(objects.get(i));
        }
        int count = this.mContext.getContentResolver().bulkInsert(table.getUri(), values);
        if (count > 0 && this.mIsAutomaticNotificationsEnabled) {
            this.notifyTableChanged(table);
        }
        return count;
    }

    public <T> int delete(@NonNull Table<T> table) {
        return this.delete(table, Where.create());
    }

    public <T> int delete(@NonNull Table<T> table, @NonNull Where where) {
        int count = this.mContext.getContentResolver().delete(table.getUri(), where.where(), where.whereArgs());
        if (count > 0 && this.mIsAutomaticNotificationsEnabled) {
            this.notifyTableChanged(table);
        }
        return count;
    }

    public <T> int update(@NonNull Table<T> table, @NonNull Where where, @NonNull T newObject) {
        int count = this.mContext.getContentResolver().update(table.getUri(), table.toValues(newObject), where.where(), where.whereArgs());
        if (count > 0 && this.mIsAutomaticNotificationsEnabled) {
            this.notifyTableChanged(table);
        }
        return count;
    }

    public <T> void registerObserver(@NonNull Table<T> table, @NonNull BasicTableObserver observer) {
        this.mObservers.registerObserver(this.mContext, table, observer);
    }

    public <T> void registerObserver(@NonNull Table<T> table, @NonNull ContentTableObserver<T> observer) {
        this.mObservers.registerObserver(this.mContext, table, observer, Where.create());
    }

    public <T> void registerObserver(@NonNull Table<T> table, @NonNull ContentTableObserver<T> observer, @NonNull Where where) {
        this.mObservers.registerObserver(this.mContext, table, observer, where);
    }

    public void unregisterObserver(@NonNull BasicTableObserver observer) {
        this.mObservers.unregisterObserver(this.mContext, observer);
    }

    public <T> void unregisterObserver(@NonNull ContentTableObserver<T> observer) {
        this.mObservers.unregisterObserver(this.mContext, observer);
    }

    public void enabledAutomaticNotifications() {
        this.mIsAutomaticNotificationsEnabled = true;
    }

    public void disabledAutomaticNotifications() {
        this.mIsAutomaticNotificationsEnabled = false;
    }

    public <T> void notifyTableChanged(@NonNull Table<T> table) {
        this.mContext.getContentResolver().notifyChange(table.getUri(), null);
    }

    static {
        System.loadLibrary("sqliteX");
    }
}

