/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Where {
    private final StringBuilder mWhereBuilder = new StringBuilder();
    private final List<Object> mBindValues = new ArrayList<Object>();
    private String mLimit;
    private String mOffset;

    private Where() {
    }

    @NonNull
    public static Where create() {
        return new Where();
    }

    @NonNull
    public Where where(@NonNull String where, Object ... values) {
        this.mWhereBuilder.append(where);
        Collections.addAll(this.mBindValues, values);
        return this;
    }

    @NonNull
    public Where equalTo(@NonNull String column, @NonNull Object value) {
        return this.where(column, " = ?", value);
    }

    @NonNull
    public Where notEqualTo(@NonNull String column, @NonNull Object value) {
        return this.where(column, " <> ?", value);
    }

    @NonNull
    public Where lessThan(@NonNull String column, @NonNull Object value) {
        return this.where(column, " < ?", value);
    }

    @NonNull
    public Where lessThanOrEqualTo(@NonNull String column, @NonNull Object value) {
        return this.where(column, " <= ?", value);
    }

    @NonNull
    public Where greaterThan(@NonNull String column, @NonNull Object value) {
        return this.where(column, " > ?", value);
    }

    @NonNull
    public Where greaterThanOrEqualTo(@NonNull String column, @NonNull Object value) {
        return this.where(column, " >= ?", value);
    }

    @NonNull
    public Where like(@NonNull String column, @NonNull Object value) {
        return this.where(column, " LIKE ?", value);
    }

    @NonNull
    public Where between(@NonNull String column, @NonNull Object first, @NonNull Object second) {
        return this.where(column, " BETWEEN ? AND ?", first, second);
    }

    @NonNull
    public Where isNull(@NonNull String column) {
        return this.where(column, " IS NULL", new Object[0]);
    }

    @NonNull
    public Where notNull(@NonNull String column) {
        return this.where(column, " NOT NULL", new Object[0]);
    }

    @NonNull
    public Where in(@NonNull String column, Object ... values) {
        int last = values.length - 1;
        this.mWhereBuilder.append(column).append(" IN(");
        for (int i = 0; i < values.length; ++i) {
            this.mWhereBuilder.append("?");
            if (i >= last) continue;
            this.mWhereBuilder.append(", ");
        }
        this.mWhereBuilder.append(")");
        Collections.addAll(this.mBindValues, values);
        return this;
    }

    @NonNull
    public Where and() {
        this.mWhereBuilder.append(" AND ");
        return this;
    }

    @NonNull
    public Where or() {
        this.mWhereBuilder.append(" OR ");
        return this;
    }

    @NonNull
    public Where limit(int limit) {
        this.mLimit = String.valueOf(limit);
        return this;
    }

    @NonNull
    public Where offset(int offset) {
        this.mOffset = String.valueOf(offset);
        return this;
    }

    @Nullable
    public String where() {
        if (this.mWhereBuilder.length() == 0) {
            return null;
        }
        return this.mWhereBuilder.toString();
    }

    @Nullable
    public String[] whereArgs() {
        if (this.mBindValues.isEmpty()) {
            return null;
        }
        String[] args = new String[this.mBindValues.size()];
        for (int i = 0; i < this.mBindValues.size(); ++i) {
            args[i] = String.valueOf(this.mBindValues.get(i));
        }
        return args;
    }

    @Nullable
    public String limit() {
        String result = "";
        if (this.mLimit != null && !this.mLimit.isEmpty()) {
            result = result + " LIMIT " + this.mLimit;
        }
        if (this.mOffset != null && !this.mOffset.isEmpty()) {
            result = result + " OFFSET " + this.mOffset;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @NonNull
    private Where where(@NonNull String column, @NonNull String operand, Object ... values) {
        this.mWhereBuilder.append(column).append(operand);
        Collections.addAll(this.mBindValues, values);
        return this;
    }
}

