/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.UriMatcher;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.arturvasilov.sqlite.core.SQLiteContentProvider;
import ru.arturvasilov.sqlite.core.Table;

public class SQLiteSchema
implements Iterable<Table> {
    private final UriMatcher mUriMatcher = new UriMatcher(-1);
    private final List<Table> mTables = new ArrayList<Table>();

    SQLiteSchema() {
    }

    public void register(@NonNull Table table) {
        this.mUriMatcher.addURI(SQLiteContentProvider.getContentAuthority(), table.getTableName(), this.mTables.size());
        this.mTables.add(table);
    }

    int calculateVersion() {
        int version = 1;
        for (Table table : this.mTables) {
            int tableVersion = table.getLastUpgradeVersion();
            if (tableVersion <= version) continue;
            version = tableVersion;
        }
        return version;
    }

    @NonNull
    String findTable(@NonNull Uri uri) {
        int index = this.mUriMatcher.match(uri);
        return this.mTables.get(index).getTableName();
    }

    @Override
    public Iterator<Table> iterator() {
        return this.mTables.iterator();
    }
}

