/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import ru.arturvasilov.sqlite.core.SQLiteConfig;
import ru.arturvasilov.sqlite.core.SQLiteSchema;
import ru.arturvasilov.sqlite.core.Table;

class SQLiteHelper
extends SQLiteOpenHelper {
    private final SQLiteSchema mSchema;

    public SQLiteHelper(Context context, @NonNull SQLiteConfig config, @NonNull SQLiteSchema schema) {
        super(context, config.getDatabaseName(), null, schema.calculateVersion());
        this.mSchema = schema;
    }

    public void onCreate(SQLiteDatabase database) {
        for (Table table : this.mSchema) {
            table.onCreate(database);
        }
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        for (Table table : this.mSchema) {
            if (oldVersion >= newVersion || newVersion > table.getLastUpgradeVersion()) continue;
            table.onUpgrade(database);
        }
    }
}

