/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import ru.arturvasilov.sqlite.core.SQLiteConfig;
import ru.arturvasilov.sqlite.core.SQLiteHelper;
import ru.arturvasilov.sqlite.core.SQLiteSchema;

public abstract class SQLiteContentProvider
extends ContentProvider {
    private SQLiteSchema mSchema;
    private SQLiteOpenHelper mSQLiteHelper;
    private static String sContentAuthority;
    private static Uri sBaseUri;

    protected abstract void prepareConfig(@NonNull SQLiteConfig var1);

    protected abstract void prepareSchema(@NonNull SQLiteSchema var1);

    public final boolean onCreate() {
        SQLiteConfig config = new SQLiteConfig(this.getContext());
        this.prepareConfig(config);
        sContentAuthority = config.getAuthority();
        sBaseUri = Uri.parse((String)("content://" + sContentAuthority));
        this.mSchema = new SQLiteSchema();
        this.prepareSchema(this.mSchema);
        this.mSQLiteHelper = new SQLiteHelper(this.getContext(), config, this.mSchema);
        return true;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return this.mSchema.findTable(uri);
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase database = this.mSQLiteHelper.getWritableDatabase();
        String table = this.getType(uri);
        if (TextUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("No such table to query");
        }
        return database.query(table, projection, selection, selectionArgs, null, null, sortOrder);
    }

    @NonNull
    public final Uri insert(@NonNull Uri uri, ContentValues values) {
        SQLiteDatabase database = this.mSQLiteHelper.getWritableDatabase();
        String table = this.getType(uri);
        if (TextUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("No such table to insert");
        }
        long id = database.insertWithOnConflict(table, null, values, 5);
        return ContentUris.withAppendedId((Uri)uri, (long)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        SQLiteDatabase database = this.mSQLiteHelper.getWritableDatabase();
        String table = this.getType(uri);
        if (TextUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("No such table to insert");
        }
        int numInserted = 0;
        database.beginTransaction();
        try {
            for (ContentValues contentValues : values) {
                long id = database.insertWithOnConflict(table, null, contentValues, 5);
                if (id <= 0L) continue;
                ++numInserted;
            }
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
        return numInserted;
    }

    public final int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase database = this.mSQLiteHelper.getWritableDatabase();
        String table = this.getType(uri);
        if (TextUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("No such table to delete");
        }
        return database.delete(table, selection, selectionArgs);
    }

    public final int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase database = this.mSQLiteHelper.getWritableDatabase();
        String table = this.getType(uri);
        if (TextUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("No such table to update");
        }
        return database.update(table, values, selection, selectionArgs);
    }

    @NonNull
    static String getContentAuthority() {
        return sContentAuthority;
    }

    @NonNull
    static Uri getBaseUri() {
        return sBaseUri;
    }
}

