/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.database.ContentObserver;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import java.util.ArrayList;
import java.util.List;
import ru.arturvasilov.sqlite.core.BasicTableObserver;
import ru.arturvasilov.sqlite.core.ContentTableObserver;
import ru.arturvasilov.sqlite.core.DatabaseObserver;
import ru.arturvasilov.sqlite.core.SQLite;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.ThreadUtils;
import ru.arturvasilov.sqlite.core.Where;

final class Observers {
    private final List<Pair<Object, ContentObserver>> mObservers = new ArrayList<Pair<Object, ContentObserver>>();

    Observers() {
    }

    public <T> void registerObserver(@NonNull Context context, @NonNull Table<T> table, final @NonNull BasicTableObserver observer) {
        DatabaseObserver contentObserver = new DatabaseObserver(){

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                observer.onTableChanged();
            }
        };
        context.getContentResolver().registerContentObserver(table.getUri(), false, (ContentObserver)contentObserver);
        this.mObservers.add((Pair<Object, ContentObserver>)new Pair((Object)observer, (Object)contentObserver));
    }

    public <T> void registerObserver(@NonNull Context context, final @NonNull Table<T> table, final @NonNull ContentTableObserver<T> observer) {
        DatabaseObserver contentObserver = new DatabaseObserver(){

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                ThreadUtils.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        List elements = SQLite.get().query(table, Where.create());
                        observer.onTableChanged(elements);
                    }
                });
            }
        };
        context.getContentResolver().registerContentObserver(table.getUri(), false, (ContentObserver)contentObserver);
        this.mObservers.add((Pair<Object, ContentObserver>)new Pair(observer, (Object)contentObserver));
    }

    public void unregisterObserver(@NonNull Context context, @NonNull BasicTableObserver observer) {
        this.unregisterObserver(context, (Object)observer);
    }

    public <T> void unregisterObserver(@NonNull Context context, @NonNull ContentTableObserver<T> observer) {
        this.unregisterObserver(context, (Object)observer);
    }

    private void unregisterObserver(@NonNull Context context, @NonNull Object object) {
        int index = -1;
        for (int i = 0; i < this.mObservers.size(); ++i) {
            if (this.mObservers.get((int)i).first != object) continue;
            index = i;
        }
        if (index >= 0) {
            context.getContentResolver().unregisterContentObserver((ContentObserver)this.mObservers.get((int)index).second);
            this.mObservers.remove(index);
        }
    }
}

