/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.support.annotation.NonNull;
import ru.arturvasilov.sqlite.core.SQLiteContentProvider;
import ru.arturvasilov.sqlite.core.Table;

public abstract class BaseTable<T>
implements Table<T> {
    @Override
    @NonNull
    public final Uri getUri() {
        return SQLiteContentProvider.getBaseUri().buildUpon().appendPath(this.getTableName()).build();
    }

    @Override
    public int getLastUpgradeVersion() {
        return 1;
    }

    @Override
    @NonNull
    public String getTableName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void onUpgrade(@NonNull SQLiteDatabase database, int oldVersion, int newVersion) {
        if (newVersion <= this.getLastUpgradeVersion() && newVersion > oldVersion) {
            database.execSQL("DROP TABLE IF EXISTS " + this.getTableName());
            this.onCreate(database);
        }
    }
}

