/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.rxloader;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.Loader;
import rx.Emitter;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Action1;

class RxLoader<D>
extends Loader<D> {
    private Observable<D> mObservable;
    private Emitter<D> mEmitter;
    private Subscription mSubscription;
    @Nullable
    private D mData;
    private boolean mIsErrorReported = false;
    @Nullable
    private Throwable mError;
    private boolean mIsCompleted = false;

    public RxLoader(@NonNull Context context, @NonNull Observable<D> observable) {
        super(context);
        this.mObservable = observable;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        this.subscribe();
    }

    protected void onStopLoading() {
        super.onStopLoading();
    }

    protected void onReset() {
        this.clearSubscription();
        this.mObservable = null;
        this.mData = null;
        this.mError = null;
        this.mIsCompleted = false;
        this.mIsErrorReported = false;
        this.mEmitter = null;
        super.onReset();
    }

    private void subscribe() {
        if (this.mEmitter != null && this.mSubscription == null && !this.mIsCompleted && this.mError == null) {
            this.mSubscription = this.mObservable.subscribe((Subscriber)new LoaderSubscriber());
        }
    }

    @NonNull
    Observable<D> createObservable() {
        return Observable.fromEmitter((Action1)new Action1<Emitter<D>>(){

            public void call(Emitter<D> asyncEmitter) {
                RxLoader.this.mEmitter = asyncEmitter;
                RxLoader.this.mEmitter.setSubscription((Subscription)new MainThreadSubscription(){

                    protected void onUnsubscribe() {
                        RxLoader.this.clearSubscription();
                    }
                });
                if (RxLoader.this.mData != null) {
                    RxLoader.this.mEmitter.onNext(RxLoader.this.mData);
                }
                if (RxLoader.this.mIsCompleted) {
                    RxLoader.this.mEmitter.onCompleted();
                } else if (RxLoader.this.mError != null && !RxLoader.this.mIsErrorReported) {
                    RxLoader.this.mEmitter.onError(RxLoader.this.mError);
                    RxLoader.this.mIsErrorReported = true;
                }
                RxLoader.this.subscribe();
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.LATEST);
    }

    private void clearSubscription() {
        if (this.mSubscription != null) {
            this.mSubscription.unsubscribe();
            this.mSubscription = null;
        }
    }

    private class LoaderSubscriber
    extends Subscriber<D> {
        private LoaderSubscriber() {
        }

        public void onNext(D d) {
            RxLoader.this.mData = d;
            if (RxLoader.this.mEmitter != null && RxLoader.this.isStarted()) {
                RxLoader.this.mEmitter.onNext(d);
            }
        }

        public void onError(Throwable throwable) {
            RxLoader.this.mError = throwable;
            if (RxLoader.this.mEmitter != null && RxLoader.this.isStarted()) {
                RxLoader.this.mEmitter.onError(throwable);
                RxLoader.this.mIsErrorReported = true;
            }
        }

        public void onCompleted() {
            RxLoader.this.mIsCompleted = true;
            if (RxLoader.this.mEmitter != null && RxLoader.this.isStarted()) {
                RxLoader.this.mEmitter.onCompleted();
            }
        }
    }
}

